"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultAddPrincipalToAssumeRole = void 0;
const policy_statement_1 = require("../policy-statement");
/**
 * Add a principal to an AssumeRolePolicyDocument in the right way
 *
 * Delegate to the principal if it can do the job itself, do a default job if it can't.
 */
function defaultAddPrincipalToAssumeRole(principal, doc) {
    if (isAssumeRolePrincipal(principal)) {
        // Principal knows how to add itself
        principal.addToAssumeRolePolicy(doc);
    }
    else {
        // Principal can't add itself, we do it for them
        doc.addStatements(new policy_statement_1.PolicyStatement({
            actions: [principal.assumeRoleAction],
            principals: [principal],
        }));
    }
}
exports.defaultAddPrincipalToAssumeRole = defaultAddPrincipalToAssumeRole;
function isAssumeRolePrincipal(principal) {
    return !!principal.addToAssumeRolePolicy;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzdW1lLXJvbGUtcG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXNzdW1lLXJvbGUtcG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLDBEQUFzRDtBQUd0RDs7OztHQUlHO0FBQ0gsU0FBZ0IsK0JBQStCLENBQUMsU0FBcUIsRUFBRSxHQUFtQjtJQUN4RixJQUFJLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxFQUFFO1FBQ3BDLG9DQUFvQztRQUNwQyxTQUFTLENBQUMscUJBQXFCLENBQUMsR0FBRyxDQUFDLENBQUM7S0FDdEM7U0FBTTtRQUNMLGdEQUFnRDtRQUNoRCxHQUFHLENBQUMsYUFBYSxDQUFDLElBQUksa0NBQWUsQ0FBQztZQUNwQyxPQUFPLEVBQUUsQ0FBQyxTQUFTLENBQUMsZ0JBQWdCLENBQUM7WUFDckMsVUFBVSxFQUFFLENBQUMsU0FBUyxDQUFDO1NBQ3hCLENBQUMsQ0FBQyxDQUFDO0tBQ0w7QUFDSCxDQUFDO0FBWEQsMEVBV0M7QUFFRCxTQUFTLHFCQUFxQixDQUFDLFNBQXFCO0lBQ2xELE9BQU8sQ0FBQyxDQUFFLFNBQWtDLENBQUMscUJBQXFCLENBQUM7QUFDckUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBvbGljeURvY3VtZW50IH0gZnJvbSAnLi4vcG9saWN5LWRvY3VtZW50JztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uL3BvbGljeS1zdGF0ZW1lbnQnO1xuaW1wb3J0IHsgSVByaW5jaXBhbCwgSUFzc3VtZVJvbGVQcmluY2lwYWwgfSBmcm9tICcuLi9wcmluY2lwYWxzJztcblxuLyoqXG4gKiBBZGQgYSBwcmluY2lwYWwgdG8gYW4gQXNzdW1lUm9sZVBvbGljeURvY3VtZW50IGluIHRoZSByaWdodCB3YXlcbiAqXG4gKiBEZWxlZ2F0ZSB0byB0aGUgcHJpbmNpcGFsIGlmIGl0IGNhbiBkbyB0aGUgam9iIGl0c2VsZiwgZG8gYSBkZWZhdWx0IGpvYiBpZiBpdCBjYW4ndC5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGRlZmF1bHRBZGRQcmluY2lwYWxUb0Fzc3VtZVJvbGUocHJpbmNpcGFsOiBJUHJpbmNpcGFsLCBkb2M6IFBvbGljeURvY3VtZW50KSB7XG4gIGlmIChpc0Fzc3VtZVJvbGVQcmluY2lwYWwocHJpbmNpcGFsKSkge1xuICAgIC8vIFByaW5jaXBhbCBrbm93cyBob3cgdG8gYWRkIGl0c2VsZlxuICAgIHByaW5jaXBhbC5hZGRUb0Fzc3VtZVJvbGVQb2xpY3koZG9jKTtcbiAgfSBlbHNlIHtcbiAgICAvLyBQcmluY2lwYWwgY2FuJ3QgYWRkIGl0c2VsZiwgd2UgZG8gaXQgZm9yIHRoZW1cbiAgICBkb2MuYWRkU3RhdGVtZW50cyhuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIGFjdGlvbnM6IFtwcmluY2lwYWwuYXNzdW1lUm9sZUFjdGlvbl0sXG4gICAgICBwcmluY2lwYWxzOiBbcHJpbmNpcGFsXSxcbiAgICB9KSk7XG4gIH1cbn1cblxuZnVuY3Rpb24gaXNBc3N1bWVSb2xlUHJpbmNpcGFsKHByaW5jaXBhbDogSVByaW5jaXBhbCk6IHByaW5jaXBhbCBpcyBJQXNzdW1lUm9sZVByaW5jaXBhbCB7XG4gIHJldHVybiAhIShwcmluY2lwYWwgYXMgSUFzc3VtZVJvbGVQcmluY2lwYWwpLmFkZFRvQXNzdW1lUm9sZVBvbGljeTtcbn1cbiJdfQ==