import * as iot from '../../aws-iot';
import * as logs from '../../aws-logs';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for CloudWatch Logs.
 */
export interface CloudWatchLogsActionProps extends CommonActionProps {
}
/**
 * The action to send data to Amazon CloudWatch Logs
 */
export declare class CloudWatchLogsAction implements iot.IAction {
    private readonly logGroup;
    private readonly role?;
    /**
     * @param logGroup The CloudWatch log group to which the action sends data
     * @param props Optional properties to not use default
     */
    constructor(logGroup: logs.ILogGroup, props?: CloudWatchLogsActionProps);
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
