"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3PutObjectAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const case_1 = require("case");
const role_1 = require("./private/role");
/**
 * The action to write the data from an MQTT message to an Amazon S3 bucket.
 */
class S3PutObjectAction {
    /**
     * @param bucket The Amazon S3 bucket to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(bucket, props = {}) {
        this.bucket = bucket;
        try {
            jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
            jsiiDeprecationWarnings.monocdk_aws_iot_actions_S3PutObjectActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3PutObjectAction);
            }
            throw error;
        }
        this.accessControl = props.accessControl;
        this.key = props.key;
        this.role = props.role;
    }
    bind(rule) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iot_ITopicRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const role = this.role ?? role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['s3:PutObject'],
            resources: [this.bucket.arnForObjects('*')],
        }));
        return {
            configuration: {
                s3: {
                    bucketName: this.bucket.bucketName,
                    cannedAcl: this.accessControl && case_1.kebab(this.accessControl.toString()),
                    key: this.key ?? '${topic()}/${timestamp()}',
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.S3PutObjectAction = S3PutObjectAction;
_a = JSII_RTTI_SYMBOL_1;
S3PutObjectAction[_a] = { fqn: "monocdk.aws_iot_actions.S3PutObjectAction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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