import * as iot from '../../aws-iot';
import * as sns from '../../aws-sns';
import { CommonActionProps } from '.';
/**
 * SNS topic action message format options.
 */
export declare enum SnsActionMessageFormat {
    /**
     * RAW message format.
     */
    RAW = "RAW",
    /**
     * JSON message format.
     */
    JSON = "JSON"
}
/**
 * Configuration options for the SNS topic action.
 */
export interface SnsTopicActionProps extends CommonActionProps {
    /**
     * The message format of the message to publish.
     *
     * SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted.
     * @see https://docs.aws.amazon.com/sns/latest/dg/sns-message-and-json-formats.html
     *
     * @default SnsActionMessageFormat.RAW
     */
    readonly messageFormat?: SnsActionMessageFormat;
}
/**
 * The action to write the data from an MQTT message to an Amazon SNS topic.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/sns-rule-action.html
 */
export declare class SnsTopicAction implements iot.IAction {
    private readonly role?;
    private readonly topic;
    private readonly messageFormat?;
    /**
     * @param topic The Amazon SNS topic to publish data on. Must not be a FIFO topic.
     * @param props Properties to configure the action.
     */
    constructor(topic: sns.ITopic, props?: SnsTopicActionProps);
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
