import { Resource, IResource } from '../../core';
import { Construct } from 'constructs';
import { IAction } from './action';
import { IotSql } from './iot-sql';
/**
 * Represents an AWS IoT Rule
 */
export interface ITopicRule extends IResource {
    /**
     * The value of the topic rule Amazon Resource Name (ARN), such as
     * arn:aws:iot:us-east-2:123456789012:rule/rule_name
     *
     * @attribute
     */
    readonly topicRuleArn: string;
    /**
     * The name topic rule
     *
     * @attribute
     */
    readonly topicRuleName: string;
}
/**
 * Properties for defining an AWS IoT Rule
 */
export interface TopicRuleProps {
    /**
     * The name of the topic rule.
     * @default None
     */
    readonly topicRuleName?: string;
    /**
     * The actions associated with the topic rule.
     *
     * @default No actions will be perform
     */
    readonly actions?: IAction[];
    /**
     * A textual description of the topic rule.
     *
     * @default None
     */
    readonly description?: string;
    /**
     * The action AWS IoT performs when it is unable to perform a rule's action.
     *
     * @default - no action will be performed
     */
    readonly errorAction?: IAction;
    /**
     * Specifies whether the rule is enabled.
     *
     * @default true
     */
    readonly enabled?: boolean;
    /**
     * A simplified SQL syntax to filter messages received on an MQTT topic and push the data elsewhere.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html
     */
    readonly sql: IotSql;
}
/**
 * Defines an AWS IoT Rule in this stack.
 */
export declare class TopicRule extends Resource implements ITopicRule {
    /**
     * Import an existing AWS IoT Rule provided an ARN
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule).
     */
    static fromTopicRuleArn(scope: Construct, id: string, topicRuleArn: string): ITopicRule;
    /**
     * Arn of this topic rule
     * @attribute
     */
    readonly topicRuleArn: string;
    /**
     * Name of this topic rule
     * @attribute
     */
    readonly topicRuleName: string;
    private readonly actions;
    constructor(scope: Construct, id: string, props: TopicRuleProps);
    /**
     * Add a action to the topic rule.
     *
     * @param action the action to associate with the topic rule.
     */
    addAction(action: IAction): void;
}
