"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvokeAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The action to write the data to an AWS Lambda function.
 */
class LambdaInvokeAction {
    /**
     * @param func the AWS Lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(func);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaInvokeAction);
            }
            throw error;
        }
    }
    bind(_scope, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iotevents_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.func.grantInvoke(options.role);
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaInvokeAction = LambdaInvokeAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaInvokeAction[_a] = { fqn: "monocdk.aws_iotevents_actions.LambdaInvokeAction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWludm9rZS1hY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsYW1iZGEtaW52b2tlLWFjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFJQTs7R0FFRztBQUNILE1BQWEsa0JBQWtCO0lBQzdCOztPQUVHO0lBQ0gsWUFBNkIsSUFBc0I7UUFBdEIsU0FBSSxHQUFKLElBQUksQ0FBa0I7Ozs7OzsrQ0FKeEMsa0JBQWtCOzs7O0tBSzVCO0lBRUQsSUFBSSxDQUFDLE1BQWlCLEVBQUUsT0FBb0M7Ozs7Ozs7Ozs7UUFDMUQsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3BDLE9BQU87WUFDTCxhQUFhLEVBQUU7Z0JBQ2IsTUFBTSxFQUFFO29CQUNOLFdBQVcsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVc7aUJBQ25DO2FBQ0Y7U0FDRixDQUFDO0tBQ0g7O0FBaEJILGdEQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlvdGV2ZW50cyBmcm9tICcuLi8uLi9hd3MtaW90ZXZlbnRzJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICcuLi8uLi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIFRoZSBhY3Rpb24gdG8gd3JpdGUgdGhlIGRhdGEgdG8gYW4gQVdTIExhbWJkYSBmdW5jdGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIExhbWJkYUludm9rZUFjdGlvbiBpbXBsZW1lbnRzIGlvdGV2ZW50cy5JQWN0aW9uIHtcbiAgLyoqXG4gICAqIEBwYXJhbSBmdW5jIHRoZSBBV1MgTGFtYmRhIGZ1bmN0aW9uIHRvIGJlIGludm9rZWQgYnkgdGhpcyBhY3Rpb25cbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZnVuYzogbGFtYmRhLklGdW5jdGlvbikge1xuICB9XG5cbiAgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgb3B0aW9uczogaW90ZXZlbnRzLkFjdGlvbkJpbmRPcHRpb25zKTogaW90ZXZlbnRzLkFjdGlvbkNvbmZpZyB7XG4gICAgdGhpcy5mdW5jLmdyYW50SW52b2tlKG9wdGlvbnMucm9sZSk7XG4gICAgcmV0dXJuIHtcbiAgICAgIGNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgbGFtYmRhOiB7XG4gICAgICAgICAgZnVuY3Rpb25Bcm46IHRoaXMuZnVuYy5mdW5jdGlvbkFybixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19