"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.State = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines a state of a detector.
 */
class State {
    constructor(props) {
        this.props = props;
        this.transitionEvents = [];
        try {
            jsiiDeprecationWarnings.monocdk_aws_iotevents_StateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, State);
            }
            throw error;
        }
        this.stateName = props.stateName;
    }
    /**
     * Add a transition event to the state.
     * The transition event will be triggered if condition is evaluated to `true`.
     *
     * @param targetState the state that will be transit to when the event triggered
     * @param options transition options including the condition that causes the state transition
     */
    transitionTo(targetState, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iotevents_State(targetState);
            jsiiDeprecationWarnings.monocdk_aws_iotevents_TransitionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.transitionTo);
            }
            throw error;
        }
        const alreadyAdded = this.transitionEvents.some(transitionEvent => transitionEvent.nextState === targetState);
        if (alreadyAdded) {
            throw new Error(`State '${this.stateName}' already has a transition defined to '${targetState.stateName}'`);
        }
        this.transitionEvents.push({
            eventName: options.eventName ?? `${this.stateName}_to_${targetState.stateName}`,
            nextState: targetState,
            condition: options.when,
            actions: options.executing,
        });
    }
    /**
     * Collect states in dependency gragh that constructed by state transitions,
     * and return the JSONs of the states.
     * This function is called recursively and collect the states.
     *
     * @internal
     */
    _collectStateJsons(scope, actionBindOptions, collectedStates) {
        if (collectedStates.has(this)) {
            return [];
        }
        collectedStates.add(this);
        return [
            this.toStateJson(scope, actionBindOptions),
            ...this.transitionEvents.flatMap(transitionEvent => {
                return transitionEvent.nextState._collectStateJsons(scope, actionBindOptions, collectedStates);
            }),
        ];
    }
    /**
     * Returns true if this state has at least one condition via events.
     *
     * @internal
     */
    _onEnterEventsHaveAtLeastOneCondition() {
        return this.props.onEnter?.some(event => event.condition) ?? false;
    }
    toStateJson(scope, actionBindOptions) {
        const { onEnter, onInput, onExit } = this.props;
        return {
            stateName: this.stateName,
            onEnter: onEnter && {
                events: toEventsJson(scope, actionBindOptions, onEnter),
            },
            onInput: (onInput || this.transitionEvents.length !== 0) ? {
                events: toEventsJson(scope, actionBindOptions, onInput),
                transitionEvents: toTransitionEventsJson(scope, actionBindOptions, this.transitionEvents),
            } : undefined,
            onExit: onExit && {
                events: toEventsJson(scope, actionBindOptions, onExit),
            },
        };
    }
}
exports.State = State;
_a = JSII_RTTI_SYMBOL_1;
State[_a] = { fqn: "monocdk.aws_iotevents.State", version: "1.191.0" };
function toEventsJson(scope, actionBindOptions, events) {
    return events?.map(event => ({
        eventName: event.eventName,
        condition: event.condition?.evaluate(),
        actions: event.actions?.map(action => action.bind(scope, actionBindOptions).configuration),
    }));
}
function toTransitionEventsJson(scope, actionBindOptions, transitionEvents) {
    if (transitionEvents.length === 0) {
        return undefined;
    }
    return transitionEvents.map(transitionEvent => ({
        eventName: transitionEvent.eventName,
        condition: transitionEvent.condition.evaluate(),
        actions: transitionEvent.actions?.map(action => action.bind(scope, actionBindOptions).configuration),
        nextState: transitionEvent.nextState.stateName,
    }));
}
//# sourceMappingURL=data:application/json;base64,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