import * as iam from '../../../aws-iam';
import * as firehose from '../../../aws-kinesisfirehose';
import { CfnDeliveryStream } from '../../../aws-kinesisfirehose';
import * as kms from '../../../aws-kms';
import * as logs from '../../../aws-logs';
import * as cdk from '../../../core';
import { Construct } from 'constructs';
import { DestinationS3BackupProps } from '../common';
export interface DestinationLoggingProps {
    /**
     * If true, log errors when data transformation or data delivery fails.
     *
     * If `logGroup` is provided, this will be implicitly set to `true`.
     *
     * @default true - errors are logged.
     */
    readonly logging?: boolean;
    /**
     * The CloudWatch log group where log streams will be created to hold error logs.
     *
     * @default - if `logging` is set to `true`, a log group will be created for you.
     */
    readonly logGroup?: logs.ILogGroup;
    /**
     * The IAM role associated with this destination.
     */
    readonly role: iam.IRole;
    /**
     * The ID of the stream that is created in the log group where logs will be placed.
     *
     * Must be unique within the log group, so should be different every time this function is called.
     */
    readonly streamId: string;
}
interface ConfigWithDependables {
    /**
     * Resources that were created by the sub-config creator that must be deployed before the delivery stream is deployed.
     */
    readonly dependables: cdk.IDependable[];
}
export interface DestinationLoggingConfig extends ConfigWithDependables {
    /**
     * Logging options that will be injected into the destination configuration.
     */
    readonly loggingOptions: CfnDeliveryStream.CloudWatchLoggingOptionsProperty;
}
export interface DestinationBackupConfig extends ConfigWithDependables {
    /**
     * S3 backup configuration that will be injected into the destination configuration.
     */
    readonly backupConfig: CfnDeliveryStream.S3DestinationConfigurationProperty;
}
export declare function createLoggingOptions(scope: Construct, props: DestinationLoggingProps): DestinationLoggingConfig | undefined;
export declare function createBufferingHints(interval?: cdk.Duration, size?: cdk.Size): CfnDeliveryStream.BufferingHintsProperty | undefined;
export declare function createEncryptionConfig(role: iam.IRole, encryptionKey?: kms.IKey): CfnDeliveryStream.EncryptionConfigurationProperty | undefined;
export declare function createProcessingConfig(scope: Construct, role: iam.IRole, dataProcessor?: firehose.IDataProcessor): CfnDeliveryStream.ProcessingConfigurationProperty | undefined;
export declare function createBackupConfig(scope: Construct, role: iam.IRole, props?: DestinationS3BackupProps): DestinationBackupConfig | undefined;
export {};
