"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionProcessor = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an AWS Lambda function to transform records.
 */
class LambdaFunctionProcessor {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(lambdaFunction);
            jsiiDeprecationWarnings.monocdk_aws_kinesisfirehose_DataProcessorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaFunctionProcessor);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_kinesisfirehose_DataProcessorBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.lambdaFunction.grantInvoke(options.role);
        return {
            processorType: 'Lambda',
            processorIdentifier: {
                parameterName: 'LambdaArn',
                parameterValue: this.lambdaFunction.functionArn,
            },
        };
    }
}
exports.LambdaFunctionProcessor = LambdaFunctionProcessor;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionProcessor[_a] = { fqn: "monocdk.aws_kinesisfirehose.LambdaFunctionProcessor", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWZ1bmN0aW9uLXByb2Nlc3Nvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxhbWJkYS1mdW5jdGlvbi1wcm9jZXNzb3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBSUE7O0dBRUc7QUFDSCxNQUFhLHVCQUF1QjtJQU1sQyxZQUE2QixjQUFnQyxFQUFFLFFBQTRCLEVBQUU7UUFBaEUsbUJBQWMsR0FBZCxjQUFjLENBQWtCOzs7Ozs7OytDQU5sRCx1QkFBdUI7Ozs7UUFPaEMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7S0FDcEI7SUFFTSxJQUFJLENBQUMsTUFBaUIsRUFBRSxPQUFpQzs7Ozs7Ozs7OztRQUM5RCxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFOUMsT0FBTztZQUNMLGFBQWEsRUFBRSxRQUFRO1lBQ3ZCLG1CQUFtQixFQUFFO2dCQUNuQixhQUFhLEVBQUUsV0FBVztnQkFDMUIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVzthQUNoRDtTQUNGLENBQUM7S0FDSDs7QUFwQkgsMERBcUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJy4uLy4uL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBEYXRhUHJvY2Vzc29yQmluZE9wdGlvbnMsIERhdGFQcm9jZXNzb3JDb25maWcsIERhdGFQcm9jZXNzb3JQcm9wcywgSURhdGFQcm9jZXNzb3IgfSBmcm9tICcuL3Byb2Nlc3Nvcic7XG5cbi8qKlxuICogVXNlIGFuIEFXUyBMYW1iZGEgZnVuY3Rpb24gdG8gdHJhbnNmb3JtIHJlY29yZHMuXG4gKi9cbmV4cG9ydCBjbGFzcyBMYW1iZGFGdW5jdGlvblByb2Nlc3NvciBpbXBsZW1lbnRzIElEYXRhUHJvY2Vzc29yIHtcbiAgLyoqXG4gICAqIFRoZSBjb25zdHJ1Y3RvciBwcm9wcyBvZiB0aGUgTGFtYmRhRnVuY3Rpb25Qcm9jZXNzb3IuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcHJvcHM6IERhdGFQcm9jZXNzb3JQcm9wcztcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uOiBsYW1iZGEuSUZ1bmN0aW9uLCBwcm9wczogRGF0YVByb2Nlc3NvclByb3BzID0ge30pIHtcbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gIH1cblxuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgb3B0aW9uczogRGF0YVByb2Nlc3NvckJpbmRPcHRpb25zKTogRGF0YVByb2Nlc3NvckNvbmZpZyB7XG4gICAgdGhpcy5sYW1iZGFGdW5jdGlvbi5ncmFudEludm9rZShvcHRpb25zLnJvbGUpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIHByb2Nlc3NvclR5cGU6ICdMYW1iZGEnLFxuICAgICAgcHJvY2Vzc29ySWRlbnRpZmllcjoge1xuICAgICAgICBwYXJhbWV0ZXJOYW1lOiAnTGFtYmRhQXJuJyxcbiAgICAgICAgcGFyYW1ldGVyVmFsdWU6IHRoaXMubGFtYmRhRnVuY3Rpb24uZnVuY3Rpb25Bcm4sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==