"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
/**
 * A principal to allow access to a key if it's being used through another AWS service
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        try {
            jsiiDeprecationWarnings.monocdk_aws_iam_IPrincipal(basePrincipal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ViaServicePrincipal);
            }
            throw error;
        }
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
    dedupeString() {
        const base = iam.ComparablePrincipal.dedupeStringFor(this.basePrincipal);
        return base !== undefined ? `ViaServicePrincipal:${this.serviceName}:${base}` : undefined;
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
_a = JSII_RTTI_SYMBOL_1;
ViaServicePrincipal[_a] = { fqn: "monocdk.aws_kms.ViaServicePrincipal", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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