"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsEventSource = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const subs = require("../../aws-sns-subscriptions");
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
class SnsEventSource {
    constructor(topic, props) {
        this.topic = topic;
        try {
            jsiiDeprecationWarnings.monocdk_aws_sns_ITopic(topic);
            jsiiDeprecationWarnings.monocdk_aws_lambda_event_sources_SnsEventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsEventSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(target) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(target);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.topic.addSubscription(new subs.LambdaSubscription(target, this.props));
    }
}
exports.SnsEventSource = SnsEventSource;
_a = JSII_RTTI_SYMBOL_1;
SnsEventSource[_a] = { fqn: "monocdk.aws_lambda_event_sources.SnsEventSource", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLG9EQUFvRDtBQVFwRDs7R0FFRztBQUNILE1BQWEsY0FBYztJQUd6QixZQUFxQixLQUFpQixFQUFFLEtBQTJCO1FBQTlDLFVBQUssR0FBTCxLQUFLLENBQVk7Ozs7Ozs7K0NBSDNCLGNBQWM7Ozs7UUFJdkIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7S0FDcEI7SUFFTSxJQUFJLENBQUMsTUFBd0I7Ozs7Ozs7Ozs7UUFDbEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLENBQUMsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0tBQzdFOztBQVRILHdDQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJy4uLy4uL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJy4uLy4uL2F3cy1zbnMnO1xuaW1wb3J0ICogYXMgc3VicyBmcm9tICcuLi8uLi9hd3Mtc25zLXN1YnNjcmlwdGlvbnMnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yd2FyZGVkIHRvIHRoZSBMYW1iZGEgU3Vic2NyaXB0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNuc0V2ZW50U291cmNlUHJvcHMgZXh0ZW5kcyBzdWJzLkxhbWJkYVN1YnNjcmlwdGlvblByb3BzIHtcbn1cblxuLyoqXG4gKiBVc2UgYW4gQW1hem9uIFNOUyB0b3BpYyBhcyBhbiBldmVudCBzb3VyY2UgZm9yIEFXUyBMYW1iZGEuXG4gKi9cbmV4cG9ydCBjbGFzcyBTbnNFdmVudFNvdXJjZSBpbXBsZW1lbnRzIGxhbWJkYS5JRXZlbnRTb3VyY2Uge1xuICBwcml2YXRlIHJlYWRvbmx5IHByb3BzPzogU25zRXZlbnRTb3VyY2VQcm9wcztcblxuICBjb25zdHJ1Y3RvcihyZWFkb25seSB0b3BpYzogc25zLklUb3BpYywgcHJvcHM/OiBTbnNFdmVudFNvdXJjZVByb3BzKSB7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICB9XG5cbiAgcHVibGljIGJpbmQodGFyZ2V0OiBsYW1iZGEuSUZ1bmN0aW9uKSB7XG4gICAgdGhpcy50b3BpYy5hZGRTdWJzY3JpcHRpb24obmV3IHN1YnMuTGFtYmRhU3Vic2NyaXB0aW9uKHRhcmdldCwgdGhpcy5wcm9wcykpO1xuICB9XG59XG4iXX0=