"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDlq = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SQS dead letter queue destination configuration for a Lambda event source
 */
class SqsDlq {
    constructor(queue) {
        this.queue = queue;
        try {
            jsiiDeprecationWarnings.monocdk_aws_sqs_IQueue(queue);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsDlq);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IEventSourceMapping(_target);
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(targetHandler);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.queue.grantSendMessages(targetHandler);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDlq = SqsDlq;
_a = JSII_RTTI_SYMBOL_1;
SqsDlq[_a] = { fqn: "monocdk.aws_lambda_event_sources.SqsDlq", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLE1BQU07SUFDakIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTs7Ozs7OytDQURuQyxNQUFNOzs7O0tBRWhCO0lBRUQ7O09BRUc7SUFDSSxJQUFJLENBQUMsT0FBNEIsRUFBRSxhQUF3Qjs7Ozs7Ozs7Ozs7UUFDaEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUU1QyxPQUFPO1lBQ0wsV0FBVyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtTQUNqQyxDQUFDO0tBQ0g7O0FBYkgsd0JBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEbHFEZXN0aW5hdGlvbkNvbmZpZywgSUV2ZW50U291cmNlRGxxLCBJRXZlbnRTb3VyY2VNYXBwaW5nLCBJRnVuY3Rpb24gfSBmcm9tICcuLi8uLi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNxcyBmcm9tICcuLi8uLi9hd3Mtc3FzJztcblxuLyoqXG4gKiBBbiBTUVMgZGVhZCBsZXR0ZXIgcXVldWUgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgYSBMYW1iZGEgZXZlbnQgc291cmNlXG4gKi9cbmV4cG9ydCBjbGFzcyBTcXNEbHEgaW1wbGVtZW50cyBJRXZlbnRTb3VyY2VEbHEge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHF1ZXVlOiBzcXMuSVF1ZXVlKSB7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gZm9yIHRoZSBETFFcbiAgICovXG4gIHB1YmxpYyBiaW5kKF90YXJnZXQ6IElFdmVudFNvdXJjZU1hcHBpbmcsIHRhcmdldEhhbmRsZXI6IElGdW5jdGlvbik6IERscURlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICB0aGlzLnF1ZXVlLmdyYW50U2VuZE1lc3NhZ2VzKHRhcmdldEhhbmRsZXIpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGRlc3RpbmF0aW9uOiB0aGlzLnF1ZXVlLnF1ZXVlQXJuLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==