"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerImageFunction = exports.DockerImageCode = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const code_1 = require("./code");
const function_1 = require("./function");
const handler_1 = require("./handler");
const runtime_1 = require("./runtime");
/**
 * Code property for the DockerImageFunction construct
 */
class DockerImageCode {
    /**
     * Use an existing ECR image as the Lambda code.
     * @param repository the ECR repository that the image is in
     * @param props properties to further configure the selected image
     */
    static fromEcr(repository, props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecr_IRepository(repository);
            jsiiDeprecationWarnings.monocdk_aws_lambda_EcrImageCodeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return {
            _bind() {
                return new code_1.EcrImageCode(repository, props);
            },
        };
    }
    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * @param directory the directory from which the asset must be created
     * @param props properties to further configure the selected image
     */
    static fromImageAsset(directory, props = {}) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_AssetImageCodeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromImageAsset);
            }
            throw error;
        }
        return {
            _bind() {
                return new code_1.AssetImageCode(directory, props);
            },
        };
    }
}
exports.DockerImageCode = DockerImageCode;
_a = JSII_RTTI_SYMBOL_1;
DockerImageCode[_a] = { fqn: "monocdk.aws_lambda.DockerImageCode", version: "1.191.0" };
/**
 * Create a lambda function where the handler is a docker image
 */
class DockerImageFunction extends function_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            handler: handler_1.Handler.FROM_IMAGE,
            runtime: runtime_1.Runtime.FROM_IMAGE,
            code: props.code._bind(),
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_DockerImageFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DockerImageFunction);
            }
            throw error;
        }
    }
}
exports.DockerImageFunction = DockerImageFunction;
_b = JSII_RTTI_SYMBOL_1;
DockerImageFunction[_b] = { fqn: "monocdk.aws_lambda.DockerImageFunction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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