"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
class Runtime {
    constructor(name, family, props = {}) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_RuntimeFamily(family);
            jsiiDeprecationWarnings.monocdk_aws_lambda_LambdaRuntimeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Runtime);
            }
            throw error;
        }
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        const imageName = props.bundlingDockerImage ?? `public.ecr.aws/sam/build-${name}`;
        this.bundlingDockerImage = core_1.DockerImage.fromRegistry(imageName);
        this.bundlingImage = this.bundlingDockerImage;
        this.supportsCodeGuruProfiling = props.supportsCodeGuruProfiling ?? false;
        Runtime.ALL.push(this);
    }
    toString() {
        return this.name;
    }
    runtimeEquals(other) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_Runtime(other);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.runtimeEquals);
            }
            throw error;
        }
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "monocdk.aws_lambda.Runtime", version: "1.191.0" };
/** A list of all known `Runtime`'s. */
Runtime.ALL = new Array();
/**
 * The NodeJS runtime (nodejs)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 4.3 runtime (nodejs4.3)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 6.10 runtime (nodejs6.10)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 8.10 runtime (nodejs8.10)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 10.x runtime (nodejs10.x)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
 */
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 12.x runtime (nodejs12.x)
 */
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 14.x runtime (nodejs14.x)
 */
Runtime.NODEJS_14_X = new Runtime('nodejs14.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 16.x runtime (nodejs16.x)
 */
Runtime.NODEJS_16_X = new Runtime('nodejs16.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The Python 2.7 runtime (python2.7)
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
 */
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.6 runtime (python3.6) (not recommended)
 *
 * The Python 3.6 runtime is deprecated as of July 2022.
 *
 * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
 */
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.7 runtime (python3.7)
 */
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.8 runtime (python3.8)
 */
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.9 runtime (python3.9)
 */
Runtime.PYTHON_3_9 = new Runtime('python3.9', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 runtime (java8)
 */
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 Corretto runtime (java8.al2)
 */
Runtime.JAVA_8_CORRETTO = new Runtime('java8.al2', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 11 runtime (java11)
 */
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The .NET 6 runtime (dotnet6)
 */
Runtime.DOTNET_6 = new Runtime('dotnet6', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 1.0 runtime (dotnetcore1.0)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.0 runtime (dotnetcore2.0)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.1 runtime (dotnetcore2.1)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
 */
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 3.1 runtime (dotnetcore3.1)
 */
Runtime.DOTNET_CORE_3_1 = new Runtime('dotnetcore3.1', RuntimeFamily.DOTNET_CORE);
/**
 * The Go 1.x runtime (go1.x)
 */
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO);
/**
 * The Ruby 2.5 runtime (ruby2.5)
 * Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Ruby runtime.
 */
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY);
/**
 * The Ruby 2.7 runtime (ruby2.7)
 */
Runtime.RUBY_2_7 = new Runtime('ruby2.7', RuntimeFamily.RUBY);
/**
 * The custom provided runtime (provided)
 */
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
/**
 * The custom provided runtime (provided)
 */
Runtime.PROVIDED_AL2 = new Runtime('provided.al2', RuntimeFamily.OTHER);
/**
 * A special runtime entry to be used when function is using a docker image.
 */
Runtime.FROM_IMAGE = new Runtime('FROM_IMAGE');
//# sourceMappingURL=data:application/json;base64,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