"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const cdk = require("../../core");
const lambda = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-layer-version-1');
// Just for the example - granting to the current account is not necessary.
const awsAccountId = stack.account;
/// !show
const layer = new lambda.LayerVersion(stack, 'MyLayer', {
    code: lambda.Code.fromAsset(path.join(__dirname, 'layer-code')),
    compatibleRuntimes: [lambda.Runtime.NODEJS_14_X],
    license: 'Apache-2.0',
    description: 'A layer to test the L2 construct',
});
// To grant usage by other AWS accounts
layer.addPermission('remote-account-grant', { accountId: awsAccountId });
// To grant usage to all accounts in some AWS Ogranization
// layer.grantUsage({ accountId: '*', organizationId });
new lambda.Function(stack, 'MyLayeredLambda', {
    code: new lambda.InlineCode('foo'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_14_X,
    layers: [layer],
});
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubGF5ZXItdmVyc2lvbi5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5sYXllci12ZXJzaW9uLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDZCQUE2QjtBQUM3QixrQ0FBa0M7QUFDbEMsaUNBQWlDO0FBRWpDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUseUJBQXlCLENBQUMsQ0FBQztBQUU1RCwyRUFBMkU7QUFDM0UsTUFBTSxZQUFZLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztBQUVuQyxTQUFTO0FBQ1QsTUFBTSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUU7SUFDdEQsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFlBQVksQ0FBQyxDQUFDO0lBQy9ELGtCQUFrQixFQUFFLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUM7SUFDaEQsT0FBTyxFQUFFLFlBQVk7SUFDckIsV0FBVyxFQUFFLGtDQUFrQztDQUNoRCxDQUFDLENBQUM7QUFFSCx1Q0FBdUM7QUFDdkMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxzQkFBc0IsRUFBRSxFQUFFLFNBQVMsRUFBRSxZQUFZLEVBQUUsQ0FBQyxDQUFDO0FBRXpFLDBEQUEwRDtBQUMxRCx3REFBd0Q7QUFFeEQsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUM1QyxJQUFJLEVBQUUsSUFBSSxNQUFNLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztJQUNsQyxPQUFPLEVBQUUsZUFBZTtJQUN4QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO0lBQ25DLE1BQU0sRUFBRSxDQUFDLEtBQUssQ0FBQztDQUNoQixDQUFDLENBQUM7QUFDSCxTQUFTO0FBRVQsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi9jb3JlJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1sYXllci12ZXJzaW9uLTEnKTtcblxuLy8gSnVzdCBmb3IgdGhlIGV4YW1wbGUgLSBncmFudGluZyB0byB0aGUgY3VycmVudCBhY2NvdW50IGlzIG5vdCBuZWNlc3NhcnkuXG5jb25zdCBhd3NBY2NvdW50SWQgPSBzdGFjay5hY2NvdW50O1xuXG4vLy8gIXNob3dcbmNvbnN0IGxheWVyID0gbmV3IGxhbWJkYS5MYXllclZlcnNpb24oc3RhY2ssICdNeUxheWVyJywge1xuICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJ2xheWVyLWNvZGUnKSksXG4gIGNvbXBhdGlibGVSdW50aW1lczogW2xhbWJkYS5SdW50aW1lLk5PREVKU18xNF9YXSxcbiAgbGljZW5zZTogJ0FwYWNoZS0yLjAnLFxuICBkZXNjcmlwdGlvbjogJ0EgbGF5ZXIgdG8gdGVzdCB0aGUgTDIgY29uc3RydWN0Jyxcbn0pO1xuXG4vLyBUbyBncmFudCB1c2FnZSBieSBvdGhlciBBV1MgYWNjb3VudHNcbmxheWVyLmFkZFBlcm1pc3Npb24oJ3JlbW90ZS1hY2NvdW50LWdyYW50JywgeyBhY2NvdW50SWQ6IGF3c0FjY291bnRJZCB9KTtcblxuLy8gVG8gZ3JhbnQgdXNhZ2UgdG8gYWxsIGFjY291bnRzIGluIHNvbWUgQVdTIE9ncmFuaXphdGlvblxuLy8gbGF5ZXIuZ3JhbnRVc2FnZSh7IGFjY291bnRJZDogJyonLCBvcmdhbml6YXRpb25JZCB9KTtcblxubmV3IGxhbWJkYS5GdW5jdGlvbihzdGFjaywgJ015TGF5ZXJlZExhbWJkYScsIHtcbiAgY29kZTogbmV3IGxhbWJkYS5JbmxpbmVDb2RlKCdmb28nKSxcbiAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5OT0RFSlNfMTRfWCxcbiAgbGF5ZXJzOiBbbGF5ZXJdLFxufSk7XG4vLy8gIWhpZGVcblxuYXBwLnN5bnRoKCk7XG4iXX0=