"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnOptionGroup = exports.CfnGlobalCluster = exports.CfnEventSubscription = exports.CfnDBSubnetGroup = exports.CfnDBSecurityGroupIngress = exports.CfnDBSecurityGroup = exports.CfnDBProxyTargetGroup = exports.CfnDBProxyEndpoint = exports.CfnDBProxy = exports.CfnDBParameterGroup = exports.CfnDBInstance = exports.CfnDBClusterParameterGroup = exports.CfnDBCluster = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-01-31T17:55:07.441Z","fingerprint":"CiI+KNYw8gHXwn/leUutCoeDkKbdn26BxJUrk/qsur8="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnDBClusterProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterProps`
 *
 * @returns the result of the validation.
 */
function CfnDBClusterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allocatedStorage', cdk.validateNumber)(properties.allocatedStorage));
    errors.collect(cdk.propertyValidator('associatedRoles', cdk.listValidator(CfnDBCluster_DBClusterRolePropertyValidator))(properties.associatedRoles));
    errors.collect(cdk.propertyValidator('autoMinorVersionUpgrade', cdk.validateBoolean)(properties.autoMinorVersionUpgrade));
    errors.collect(cdk.propertyValidator('availabilityZones', cdk.listValidator(cdk.validateString))(properties.availabilityZones));
    errors.collect(cdk.propertyValidator('backtrackWindow', cdk.validateNumber)(properties.backtrackWindow));
    errors.collect(cdk.propertyValidator('backupRetentionPeriod', cdk.validateNumber)(properties.backupRetentionPeriod));
    errors.collect(cdk.propertyValidator('copyTagsToSnapshot', cdk.validateBoolean)(properties.copyTagsToSnapshot));
    errors.collect(cdk.propertyValidator('dbClusterIdentifier', cdk.validateString)(properties.dbClusterIdentifier));
    errors.collect(cdk.propertyValidator('dbClusterInstanceClass', cdk.validateString)(properties.dbClusterInstanceClass));
    errors.collect(cdk.propertyValidator('dbClusterParameterGroupName', cdk.validateString)(properties.dbClusterParameterGroupName));
    errors.collect(cdk.propertyValidator('dbInstanceParameterGroupName', cdk.validateString)(properties.dbInstanceParameterGroupName));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('dbSystemId', cdk.validateString)(properties.dbSystemId));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('domainIamRoleName', cdk.validateString)(properties.domainIamRoleName));
    errors.collect(cdk.propertyValidator('enableCloudwatchLogsExports', cdk.listValidator(cdk.validateString))(properties.enableCloudwatchLogsExports));
    errors.collect(cdk.propertyValidator('enableHttpEndpoint', cdk.validateBoolean)(properties.enableHttpEndpoint));
    errors.collect(cdk.propertyValidator('enableIamDatabaseAuthentication', cdk.validateBoolean)(properties.enableIamDatabaseAuthentication));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineMode', cdk.validateString)(properties.engineMode));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('globalClusterIdentifier', cdk.validateString)(properties.globalClusterIdentifier));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('manageMasterUserPassword', cdk.validateBoolean)(properties.manageMasterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserSecret', CfnDBCluster_MasterUserSecretPropertyValidator)(properties.masterUserSecret));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.validateString)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('monitoringInterval', cdk.validateNumber)(properties.monitoringInterval));
    errors.collect(cdk.propertyValidator('monitoringRoleArn', cdk.validateString)(properties.monitoringRoleArn));
    errors.collect(cdk.propertyValidator('networkType', cdk.validateString)(properties.networkType));
    errors.collect(cdk.propertyValidator('performanceInsightsEnabled', cdk.validateBoolean)(properties.performanceInsightsEnabled));
    errors.collect(cdk.propertyValidator('performanceInsightsKmsKeyId', cdk.validateString)(properties.performanceInsightsKmsKeyId));
    errors.collect(cdk.propertyValidator('performanceInsightsRetentionPeriod', cdk.validateNumber)(properties.performanceInsightsRetentionPeriod));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('replicationSourceIdentifier', cdk.validateString)(properties.replicationSourceIdentifier));
    errors.collect(cdk.propertyValidator('restoreType', cdk.validateString)(properties.restoreType));
    errors.collect(cdk.propertyValidator('scalingConfiguration', CfnDBCluster_ScalingConfigurationPropertyValidator)(properties.scalingConfiguration));
    errors.collect(cdk.propertyValidator('serverlessV2ScalingConfiguration', CfnDBCluster_ServerlessV2ScalingConfigurationPropertyValidator)(properties.serverlessV2ScalingConfiguration));
    errors.collect(cdk.propertyValidator('snapshotIdentifier', cdk.validateString)(properties.snapshotIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbClusterIdentifier', cdk.validateString)(properties.sourceDbClusterIdentifier));
    errors.collect(cdk.propertyValidator('sourceRegion', cdk.validateString)(properties.sourceRegion));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    errors.collect(cdk.propertyValidator('storageType', cdk.validateString)(properties.storageType));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('useLatestRestorableTime', cdk.validateBoolean)(properties.useLatestRestorableTime));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    return errors.wrap('supplied properties not correct for "CfnDBClusterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBClusterPropsValidator(properties).assertSuccess();
    return {
        AllocatedStorage: cdk.numberToCloudFormation(properties.allocatedStorage),
        AssociatedRoles: cdk.listMapper(cfnDBClusterDBClusterRolePropertyToCloudFormation)(properties.associatedRoles),
        AutoMinorVersionUpgrade: cdk.booleanToCloudFormation(properties.autoMinorVersionUpgrade),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(properties.availabilityZones),
        BacktrackWindow: cdk.numberToCloudFormation(properties.backtrackWindow),
        BackupRetentionPeriod: cdk.numberToCloudFormation(properties.backupRetentionPeriod),
        CopyTagsToSnapshot: cdk.booleanToCloudFormation(properties.copyTagsToSnapshot),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        DBClusterIdentifier: cdk.stringToCloudFormation(properties.dbClusterIdentifier),
        DBClusterInstanceClass: cdk.stringToCloudFormation(properties.dbClusterInstanceClass),
        DBClusterParameterGroupName: cdk.stringToCloudFormation(properties.dbClusterParameterGroupName),
        DBInstanceParameterGroupName: cdk.stringToCloudFormation(properties.dbInstanceParameterGroupName),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        DBSystemId: cdk.stringToCloudFormation(properties.dbSystemId),
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Domain: cdk.stringToCloudFormation(properties.domain),
        DomainIAMRoleName: cdk.stringToCloudFormation(properties.domainIamRoleName),
        EnableCloudwatchLogsExports: cdk.listMapper(cdk.stringToCloudFormation)(properties.enableCloudwatchLogsExports),
        EnableHttpEndpoint: cdk.booleanToCloudFormation(properties.enableHttpEndpoint),
        EnableIAMDatabaseAuthentication: cdk.booleanToCloudFormation(properties.enableIamDatabaseAuthentication),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineMode: cdk.stringToCloudFormation(properties.engineMode),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        GlobalClusterIdentifier: cdk.stringToCloudFormation(properties.globalClusterIdentifier),
        Iops: cdk.numberToCloudFormation(properties.iops),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        ManageMasterUserPassword: cdk.booleanToCloudFormation(properties.manageMasterUserPassword),
        MasterUsername: cdk.stringToCloudFormation(properties.masterUsername),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
        MasterUserSecret: cfnDBClusterMasterUserSecretPropertyToCloudFormation(properties.masterUserSecret),
        MonitoringInterval: cdk.numberToCloudFormation(properties.monitoringInterval),
        MonitoringRoleArn: cdk.stringToCloudFormation(properties.monitoringRoleArn),
        NetworkType: cdk.stringToCloudFormation(properties.networkType),
        PerformanceInsightsEnabled: cdk.booleanToCloudFormation(properties.performanceInsightsEnabled),
        PerformanceInsightsKmsKeyId: cdk.stringToCloudFormation(properties.performanceInsightsKmsKeyId),
        PerformanceInsightsRetentionPeriod: cdk.numberToCloudFormation(properties.performanceInsightsRetentionPeriod),
        Port: cdk.numberToCloudFormation(properties.port),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        ReplicationSourceIdentifier: cdk.stringToCloudFormation(properties.replicationSourceIdentifier),
        RestoreType: cdk.stringToCloudFormation(properties.restoreType),
        ScalingConfiguration: cfnDBClusterScalingConfigurationPropertyToCloudFormation(properties.scalingConfiguration),
        ServerlessV2ScalingConfiguration: cfnDBClusterServerlessV2ScalingConfigurationPropertyToCloudFormation(properties.serverlessV2ScalingConfiguration),
        SnapshotIdentifier: cdk.stringToCloudFormation(properties.snapshotIdentifier),
        SourceDBClusterIdentifier: cdk.stringToCloudFormation(properties.sourceDbClusterIdentifier),
        SourceRegion: cdk.stringToCloudFormation(properties.sourceRegion),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
        StorageType: cdk.stringToCloudFormation(properties.storageType),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        UseLatestRestorableTime: cdk.booleanToCloudFormation(properties.useLatestRestorableTime),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBClusterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allocatedStorage', 'AllocatedStorage', properties.AllocatedStorage != null ? cfn_parse.FromCloudFormation.getNumber(properties.AllocatedStorage) : undefined);
    ret.addPropertyResult('associatedRoles', 'AssociatedRoles', properties.AssociatedRoles != null ? cfn_parse.FromCloudFormation.getArray(CfnDBClusterDBClusterRolePropertyFromCloudFormation)(properties.AssociatedRoles) : undefined);
    ret.addPropertyResult('autoMinorVersionUpgrade', 'AutoMinorVersionUpgrade', properties.AutoMinorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoMinorVersionUpgrade) : undefined);
    ret.addPropertyResult('availabilityZones', 'AvailabilityZones', properties.AvailabilityZones != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AvailabilityZones) : undefined);
    ret.addPropertyResult('backtrackWindow', 'BacktrackWindow', properties.BacktrackWindow != null ? cfn_parse.FromCloudFormation.getNumber(properties.BacktrackWindow) : undefined);
    ret.addPropertyResult('backupRetentionPeriod', 'BackupRetentionPeriod', properties.BackupRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionPeriod) : undefined);
    ret.addPropertyResult('copyTagsToSnapshot', 'CopyTagsToSnapshot', properties.CopyTagsToSnapshot != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshot) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('dbClusterIdentifier', 'DBClusterIdentifier', properties.DBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterIdentifier) : undefined);
    ret.addPropertyResult('dbClusterInstanceClass', 'DBClusterInstanceClass', properties.DBClusterInstanceClass != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterInstanceClass) : undefined);
    ret.addPropertyResult('dbClusterParameterGroupName', 'DBClusterParameterGroupName', properties.DBClusterParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterParameterGroupName) : undefined);
    ret.addPropertyResult('dbInstanceParameterGroupName', 'DBInstanceParameterGroupName', properties.DBInstanceParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBInstanceParameterGroupName) : undefined);
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('dbSystemId', 'DBSystemId', properties.DBSystemId != null ? cfn_parse.FromCloudFormation.getString(properties.DBSystemId) : undefined);
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('domainIamRoleName', 'DomainIAMRoleName', properties.DomainIAMRoleName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainIAMRoleName) : undefined);
    ret.addPropertyResult('enableCloudwatchLogsExports', 'EnableCloudwatchLogsExports', properties.EnableCloudwatchLogsExports != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EnableCloudwatchLogsExports) : undefined);
    ret.addPropertyResult('enableHttpEndpoint', 'EnableHttpEndpoint', properties.EnableHttpEndpoint != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableHttpEndpoint) : undefined);
    ret.addPropertyResult('enableIamDatabaseAuthentication', 'EnableIAMDatabaseAuthentication', properties.EnableIAMDatabaseAuthentication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableIAMDatabaseAuthentication) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineMode', 'EngineMode', properties.EngineMode != null ? cfn_parse.FromCloudFormation.getString(properties.EngineMode) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('globalClusterIdentifier', 'GlobalClusterIdentifier', properties.GlobalClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.GlobalClusterIdentifier) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('manageMasterUserPassword', 'ManageMasterUserPassword', properties.ManageMasterUserPassword != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ManageMasterUserPassword) : undefined);
    ret.addPropertyResult('masterUsername', 'MasterUsername', properties.MasterUsername != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUsername) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addPropertyResult('masterUserSecret', 'MasterUserSecret', properties.MasterUserSecret != null ? CfnDBClusterMasterUserSecretPropertyFromCloudFormation(properties.MasterUserSecret) : undefined);
    ret.addPropertyResult('monitoringInterval', 'MonitoringInterval', properties.MonitoringInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.MonitoringInterval) : undefined);
    ret.addPropertyResult('monitoringRoleArn', 'MonitoringRoleArn', properties.MonitoringRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringRoleArn) : undefined);
    ret.addPropertyResult('networkType', 'NetworkType', properties.NetworkType != null ? cfn_parse.FromCloudFormation.getString(properties.NetworkType) : undefined);
    ret.addPropertyResult('performanceInsightsEnabled', 'PerformanceInsightsEnabled', properties.PerformanceInsightsEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PerformanceInsightsEnabled) : undefined);
    ret.addPropertyResult('performanceInsightsKmsKeyId', 'PerformanceInsightsKmsKeyId', properties.PerformanceInsightsKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.PerformanceInsightsKmsKeyId) : undefined);
    ret.addPropertyResult('performanceInsightsRetentionPeriod', 'PerformanceInsightsRetentionPeriod', properties.PerformanceInsightsRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.PerformanceInsightsRetentionPeriod) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('replicationSourceIdentifier', 'ReplicationSourceIdentifier', properties.ReplicationSourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationSourceIdentifier) : undefined);
    ret.addPropertyResult('restoreType', 'RestoreType', properties.RestoreType != null ? cfn_parse.FromCloudFormation.getString(properties.RestoreType) : undefined);
    ret.addPropertyResult('scalingConfiguration', 'ScalingConfiguration', properties.ScalingConfiguration != null ? CfnDBClusterScalingConfigurationPropertyFromCloudFormation(properties.ScalingConfiguration) : undefined);
    ret.addPropertyResult('serverlessV2ScalingConfiguration', 'ServerlessV2ScalingConfiguration', properties.ServerlessV2ScalingConfiguration != null ? CfnDBClusterServerlessV2ScalingConfigurationPropertyFromCloudFormation(properties.ServerlessV2ScalingConfiguration) : undefined);
    ret.addPropertyResult('snapshotIdentifier', 'SnapshotIdentifier', properties.SnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SnapshotIdentifier) : undefined);
    ret.addPropertyResult('sourceDbClusterIdentifier', 'SourceDBClusterIdentifier', properties.SourceDBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBClusterIdentifier) : undefined);
    ret.addPropertyResult('sourceRegion', 'SourceRegion', properties.SourceRegion != null ? cfn_parse.FromCloudFormation.getString(properties.SourceRegion) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addPropertyResult('storageType', 'StorageType', properties.StorageType != null ? cfn_parse.FromCloudFormation.getString(properties.StorageType) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('useLatestRestorableTime', 'UseLatestRestorableTime', properties.UseLatestRestorableTime != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseLatestRestorableTime) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`
 *
 * The `AWS::RDS::DBCluster` resource creates an Amazon Aurora DB cluster or Multi-AZ DB cluster.
 *
 * For more information about creating an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide* .
 *
 * For more information about creating a Multi-AZ DB cluster, see [Creating a Multi-AZ DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html) in the *Amazon RDS User Guide* .
 *
 * > You can only create this resource in AWS Regions where Amazon Aurora or Multi-AZ DB clusters are supported.
 *
 * *Updating DB clusters*
 *
 * When properties labeled " *Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement) " are updated, AWS CloudFormation first creates a replacement DB cluster, then changes references from other dependent resources to point to the replacement DB cluster, and finally deletes the old DB cluster.
 *
 * > We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB cluster. To preserve your data, perform the following procedure:
 * >
 * > - Deactivate any applications that are using the DB cluster so that there's no activity on the DB instance.
 * > - Create a snapshot of the DB cluster. For more information, see [Creating a DB Cluster Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CreateSnapshotCluster.html) .
 * > - If you want to restore your DB cluster using a DB cluster snapshot, modify the updated template with your DB cluster changes and add the `SnapshotIdentifier` property with the ID of the DB cluster snapshot that you want to use.
 * >
 * > After you restore a DB cluster with a `SnapshotIdentifier` property, you must specify the same `SnapshotIdentifier` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the DB cluster snapshot again, and the data in the database is not changed. However, if you don't specify the `SnapshotIdentifier` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified `SnapshotIdentifier` property, and the original DB cluster is deleted.
 * > - Update the stack.
 *
 * Currently, when you are updating the stack for an Aurora Serverless DB cluster, you can't include changes to any other properties when you specify one of the following properties: `PreferredBackupWindow` , `PreferredMaintenanceWindow` , and `Port` . This limitation doesn't apply to provisioned DB clusters.
 *
 * For more information about updating other properties of this resource, see `[ModifyDBCluster](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBCluster.html)` . For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * *Deleting DB clusters*
 *
 * The default `DeletionPolicy` for `AWS::RDS::DBCluster` resources is `Snapshot` . For more information about how AWS CloudFormation deletes resources, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .
 *
 * @cloudformationResource AWS::RDS::DBCluster
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
class CfnDBCluster extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDBCluster.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBCluster);
            }
            throw error;
        }
        this.attrDbClusterArn = cdk.Token.asString(this.getAtt('DBClusterArn'));
        this.attrDbClusterResourceId = cdk.Token.asString(this.getAtt('DBClusterResourceId'));
        this.attrEndpointAddress = cdk.Token.asString(this.getAtt('Endpoint.Address'));
        this.attrEndpointPort = cdk.Token.asString(this.getAtt('Endpoint.Port'));
        this.attrMasterUserSecretSecretArn = cdk.Token.asString(this.getAtt('MasterUserSecret.SecretArn'));
        this.attrReadEndpointAddress = cdk.Token.asString(this.getAtt('ReadEndpoint.Address'));
        this.allocatedStorage = props.allocatedStorage;
        this.associatedRoles = props.associatedRoles;
        this.autoMinorVersionUpgrade = props.autoMinorVersionUpgrade;
        this.availabilityZones = props.availabilityZones;
        this.backtrackWindow = props.backtrackWindow;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.copyTagsToSnapshot = props.copyTagsToSnapshot;
        this.databaseName = props.databaseName;
        this.dbClusterIdentifier = props.dbClusterIdentifier;
        this.dbClusterInstanceClass = props.dbClusterInstanceClass;
        this.dbClusterParameterGroupName = props.dbClusterParameterGroupName;
        this.dbInstanceParameterGroupName = props.dbInstanceParameterGroupName;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.dbSystemId = props.dbSystemId;
        this.deletionProtection = props.deletionProtection;
        this.domain = props.domain;
        this.domainIamRoleName = props.domainIamRoleName;
        this.enableCloudwatchLogsExports = props.enableCloudwatchLogsExports;
        this.enableHttpEndpoint = props.enableHttpEndpoint;
        this.enableIamDatabaseAuthentication = props.enableIamDatabaseAuthentication;
        this.engine = props.engine;
        this.engineMode = props.engineMode;
        this.engineVersion = props.engineVersion;
        this.globalClusterIdentifier = props.globalClusterIdentifier;
        this.iops = props.iops;
        this.kmsKeyId = props.kmsKeyId;
        this.manageMasterUserPassword = props.manageMasterUserPassword;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.masterUserSecret = props.masterUserSecret;
        this.monitoringInterval = props.monitoringInterval;
        this.monitoringRoleArn = props.monitoringRoleArn;
        this.networkType = props.networkType;
        this.performanceInsightsEnabled = props.performanceInsightsEnabled;
        this.performanceInsightsKmsKeyId = props.performanceInsightsKmsKeyId;
        this.performanceInsightsRetentionPeriod = props.performanceInsightsRetentionPeriod;
        this.port = props.port;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.publiclyAccessible = props.publiclyAccessible;
        this.replicationSourceIdentifier = props.replicationSourceIdentifier;
        this.restoreType = props.restoreType;
        this.scalingConfiguration = props.scalingConfiguration;
        this.serverlessV2ScalingConfiguration = props.serverlessV2ScalingConfiguration;
        this.snapshotIdentifier = props.snapshotIdentifier;
        this.sourceDbClusterIdentifier = props.sourceDbClusterIdentifier;
        this.sourceRegion = props.sourceRegion;
        this.storageEncrypted = props.storageEncrypted;
        this.storageType = props.storageType;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBCluster", props.tags, { tagPropertyName: 'tags' });
        this.useLatestRestorableTime = props.useLatestRestorableTime;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::RDS::DBCluster\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBClusterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBCluster(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBCluster.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allocatedStorage: this.allocatedStorage,
            associatedRoles: this.associatedRoles,
            autoMinorVersionUpgrade: this.autoMinorVersionUpgrade,
            availabilityZones: this.availabilityZones,
            backtrackWindow: this.backtrackWindow,
            backupRetentionPeriod: this.backupRetentionPeriod,
            copyTagsToSnapshot: this.copyTagsToSnapshot,
            databaseName: this.databaseName,
            dbClusterIdentifier: this.dbClusterIdentifier,
            dbClusterInstanceClass: this.dbClusterInstanceClass,
            dbClusterParameterGroupName: this.dbClusterParameterGroupName,
            dbInstanceParameterGroupName: this.dbInstanceParameterGroupName,
            dbSubnetGroupName: this.dbSubnetGroupName,
            dbSystemId: this.dbSystemId,
            deletionProtection: this.deletionProtection,
            domain: this.domain,
            domainIamRoleName: this.domainIamRoleName,
            enableCloudwatchLogsExports: this.enableCloudwatchLogsExports,
            enableHttpEndpoint: this.enableHttpEndpoint,
            enableIamDatabaseAuthentication: this.enableIamDatabaseAuthentication,
            engine: this.engine,
            engineMode: this.engineMode,
            engineVersion: this.engineVersion,
            globalClusterIdentifier: this.globalClusterIdentifier,
            iops: this.iops,
            kmsKeyId: this.kmsKeyId,
            manageMasterUserPassword: this.manageMasterUserPassword,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            masterUserSecret: this.masterUserSecret,
            monitoringInterval: this.monitoringInterval,
            monitoringRoleArn: this.monitoringRoleArn,
            networkType: this.networkType,
            performanceInsightsEnabled: this.performanceInsightsEnabled,
            performanceInsightsKmsKeyId: this.performanceInsightsKmsKeyId,
            performanceInsightsRetentionPeriod: this.performanceInsightsRetentionPeriod,
            port: this.port,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            publiclyAccessible: this.publiclyAccessible,
            replicationSourceIdentifier: this.replicationSourceIdentifier,
            restoreType: this.restoreType,
            scalingConfiguration: this.scalingConfiguration,
            serverlessV2ScalingConfiguration: this.serverlessV2ScalingConfiguration,
            snapshotIdentifier: this.snapshotIdentifier,
            sourceDbClusterIdentifier: this.sourceDbClusterIdentifier,
            sourceRegion: this.sourceRegion,
            storageEncrypted: this.storageEncrypted,
            storageType: this.storageType,
            tags: this.tags.renderTags(),
            useLatestRestorableTime: this.useLatestRestorableTime,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBClusterPropsToCloudFormation(props);
    }
}
exports.CfnDBCluster = CfnDBCluster;
_a = JSII_RTTI_SYMBOL_1;
CfnDBCluster[_a] = { fqn: "monocdk.aws_rds.CfnDBCluster", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBCluster.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBCluster";
/**
 * Determine whether the given properties match those of a `DBClusterRoleProperty`
 *
 * @param properties - the TypeScript properties of a `DBClusterRoleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_DBClusterRolePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('featureName', cdk.validateString)(properties.featureName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "DBClusterRoleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.DBClusterRole` resource
 *
 * @param properties - the TypeScript properties of a `DBClusterRoleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.DBClusterRole` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterDBClusterRolePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_DBClusterRolePropertyValidator(properties).assertSuccess();
    return {
        FeatureName: cdk.stringToCloudFormation(properties.featureName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDBClusterDBClusterRolePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('featureName', 'FeatureName', properties.FeatureName != null ? cfn_parse.FromCloudFormation.getString(properties.FeatureName) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_EndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('address', cdk.validateString)(properties.address));
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    return errors.wrap('supplied properties not correct for "EndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.Endpoint` resource
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.Endpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_EndpointPropertyValidator(properties).assertSuccess();
    return {
        Address: cdk.stringToCloudFormation(properties.address),
        Port: cdk.stringToCloudFormation(properties.port),
    };
}
// @ts-ignore TS6133
function CfnDBClusterEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('address', 'Address', properties.Address != null ? cfn_parse.FromCloudFormation.getString(properties.Address) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MasterUserSecretProperty`
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_MasterUserSecretPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    return errors.wrap('supplied properties not correct for "MasterUserSecretProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.MasterUserSecret` resource
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.MasterUserSecret` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterMasterUserSecretPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_MasterUserSecretPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
    };
}
// @ts-ignore TS6133
function CfnDBClusterMasterUserSecretPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ReadEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `ReadEndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_ReadEndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('address', cdk.validateString)(properties.address));
    return errors.wrap('supplied properties not correct for "ReadEndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ReadEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `ReadEndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ReadEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterReadEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_ReadEndpointPropertyValidator(properties).assertSuccess();
    return {
        Address: cdk.stringToCloudFormation(properties.address),
    };
}
// @ts-ignore TS6133
function CfnDBClusterReadEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('address', 'Address', properties.Address != null ? cfn_parse.FromCloudFormation.getString(properties.Address) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ScalingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_ScalingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoPause', cdk.validateBoolean)(properties.autoPause));
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.validateNumber)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.validateNumber)(properties.minCapacity));
    errors.collect(cdk.propertyValidator('secondsBeforeTimeout', cdk.validateNumber)(properties.secondsBeforeTimeout));
    errors.collect(cdk.propertyValidator('secondsUntilAutoPause', cdk.validateNumber)(properties.secondsUntilAutoPause));
    errors.collect(cdk.propertyValidator('timeoutAction', cdk.validateString)(properties.timeoutAction));
    return errors.wrap('supplied properties not correct for "ScalingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ScalingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ScalingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ScalingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterScalingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_ScalingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AutoPause: cdk.booleanToCloudFormation(properties.autoPause),
        MaxCapacity: cdk.numberToCloudFormation(properties.maxCapacity),
        MinCapacity: cdk.numberToCloudFormation(properties.minCapacity),
        SecondsBeforeTimeout: cdk.numberToCloudFormation(properties.secondsBeforeTimeout),
        SecondsUntilAutoPause: cdk.numberToCloudFormation(properties.secondsUntilAutoPause),
        TimeoutAction: cdk.stringToCloudFormation(properties.timeoutAction),
    };
}
// @ts-ignore TS6133
function CfnDBClusterScalingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoPause', 'AutoPause', properties.AutoPause != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoPause) : undefined);
    ret.addPropertyResult('maxCapacity', 'MaxCapacity', properties.MaxCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity) : undefined);
    ret.addPropertyResult('minCapacity', 'MinCapacity', properties.MinCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinCapacity) : undefined);
    ret.addPropertyResult('secondsBeforeTimeout', 'SecondsBeforeTimeout', properties.SecondsBeforeTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.SecondsBeforeTimeout) : undefined);
    ret.addPropertyResult('secondsUntilAutoPause', 'SecondsUntilAutoPause', properties.SecondsUntilAutoPause != null ? cfn_parse.FromCloudFormation.getNumber(properties.SecondsUntilAutoPause) : undefined);
    ret.addPropertyResult('timeoutAction', 'TimeoutAction', properties.TimeoutAction != null ? cfn_parse.FromCloudFormation.getString(properties.TimeoutAction) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServerlessV2ScalingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ServerlessV2ScalingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_ServerlessV2ScalingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.validateNumber)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.validateNumber)(properties.minCapacity));
    return errors.wrap('supplied properties not correct for "ServerlessV2ScalingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ServerlessV2ScalingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ServerlessV2ScalingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ServerlessV2ScalingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterServerlessV2ScalingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_ServerlessV2ScalingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        MaxCapacity: cdk.numberToCloudFormation(properties.maxCapacity),
        MinCapacity: cdk.numberToCloudFormation(properties.minCapacity),
    };
}
// @ts-ignore TS6133
function CfnDBClusterServerlessV2ScalingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxCapacity', 'MaxCapacity', properties.MaxCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity) : undefined);
    ret.addPropertyResult('minCapacity', 'MinCapacity', properties.MinCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBClusterParameterGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterParameterGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBClusterParameterGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbClusterParameterGroupName', cdk.validateString)(properties.dbClusterParameterGroupName));
    errors.collect(cdk.propertyValidator('description', cdk.requiredValidator)(properties.description));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('family', cdk.requiredValidator)(properties.family));
    errors.collect(cdk.propertyValidator('family', cdk.validateString)(properties.family));
    errors.collect(cdk.propertyValidator('parameters', cdk.requiredValidator)(properties.parameters));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBClusterParameterGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBClusterParameterGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterParameterGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBClusterParameterGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterParameterGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBClusterParameterGroupPropsValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        Family: cdk.stringToCloudFormation(properties.family),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        DBClusterParameterGroupName: cdk.stringToCloudFormation(properties.dbClusterParameterGroupName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBClusterParameterGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', cfn_parse.FromCloudFormation.getString(properties.Description));
    ret.addPropertyResult('family', 'Family', cfn_parse.FromCloudFormation.getString(properties.Family));
    ret.addPropertyResult('parameters', 'Parameters', cfn_parse.FromCloudFormation.getAny(properties.Parameters));
    ret.addPropertyResult('dbClusterParameterGroupName', 'DBClusterParameterGroupName', properties.DBClusterParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterParameterGroupName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBClusterParameterGroup`
 *
 * The `AWS::RDS::DBClusterParameterGroup` resource creates a new Amazon RDS DB cluster parameter group.
 *
 * For information about configuring parameters for Amazon Aurora DB clusters, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide* .
 *
 * > If you apply a parameter group to a DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
 * >
 * > If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
 *
 * @cloudformationResource AWS::RDS::DBClusterParameterGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 */
class CfnDBClusterParameterGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBClusterParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBClusterParameterGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'description', this);
        cdk.requireProperty(props, 'family', this);
        cdk.requireProperty(props, 'parameters', this);
        this.description = props.description;
        this.family = props.family;
        this.parameters = props.parameters;
        this.dbClusterParameterGroupName = props.dbClusterParameterGroupName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBClusterParameterGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBClusterParameterGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBClusterParameterGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            description: this.description,
            family: this.family,
            parameters: this.parameters,
            dbClusterParameterGroupName: this.dbClusterParameterGroupName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBClusterParameterGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBClusterParameterGroup = CfnDBClusterParameterGroup;
_b = JSII_RTTI_SYMBOL_1;
CfnDBClusterParameterGroup[_b] = { fqn: "monocdk.aws_rds.CfnDBClusterParameterGroup", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBClusterParameterGroup";
/**
 * Determine whether the given properties match those of a `CfnDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function CfnDBInstancePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allocatedStorage', cdk.validateString)(properties.allocatedStorage));
    errors.collect(cdk.propertyValidator('allowMajorVersionUpgrade', cdk.validateBoolean)(properties.allowMajorVersionUpgrade));
    errors.collect(cdk.propertyValidator('associatedRoles', cdk.listValidator(CfnDBInstance_DBInstanceRolePropertyValidator))(properties.associatedRoles));
    errors.collect(cdk.propertyValidator('autoMinorVersionUpgrade', cdk.validateBoolean)(properties.autoMinorVersionUpgrade));
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('backupRetentionPeriod', cdk.validateNumber)(properties.backupRetentionPeriod));
    errors.collect(cdk.propertyValidator('caCertificateIdentifier', cdk.validateString)(properties.caCertificateIdentifier));
    errors.collect(cdk.propertyValidator('certificateDetails', CfnDBInstance_CertificateDetailsPropertyValidator)(properties.certificateDetails));
    errors.collect(cdk.propertyValidator('certificateRotationRestart', cdk.validateBoolean)(properties.certificateRotationRestart));
    errors.collect(cdk.propertyValidator('characterSetName', cdk.validateString)(properties.characterSetName));
    errors.collect(cdk.propertyValidator('copyTagsToSnapshot', cdk.validateBoolean)(properties.copyTagsToSnapshot));
    errors.collect(cdk.propertyValidator('customIamInstanceProfile', cdk.validateString)(properties.customIamInstanceProfile));
    errors.collect(cdk.propertyValidator('dbClusterIdentifier', cdk.validateString)(properties.dbClusterIdentifier));
    errors.collect(cdk.propertyValidator('dbClusterSnapshotIdentifier', cdk.validateString)(properties.dbClusterSnapshotIdentifier));
    errors.collect(cdk.propertyValidator('dbInstanceClass', cdk.validateString)(properties.dbInstanceClass));
    errors.collect(cdk.propertyValidator('dbInstanceIdentifier', cdk.validateString)(properties.dbInstanceIdentifier));
    errors.collect(cdk.propertyValidator('dbName', cdk.validateString)(properties.dbName));
    errors.collect(cdk.propertyValidator('dbParameterGroupName', cdk.validateString)(properties.dbParameterGroupName));
    errors.collect(cdk.propertyValidator('dbSecurityGroups', cdk.listValidator(cdk.validateString))(properties.dbSecurityGroups));
    errors.collect(cdk.propertyValidator('dbSnapshotIdentifier', cdk.validateString)(properties.dbSnapshotIdentifier));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('deleteAutomatedBackups', cdk.validateBoolean)(properties.deleteAutomatedBackups));
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('domainIamRoleName', cdk.validateString)(properties.domainIamRoleName));
    errors.collect(cdk.propertyValidator('enableCloudwatchLogsExports', cdk.listValidator(cdk.validateString))(properties.enableCloudwatchLogsExports));
    errors.collect(cdk.propertyValidator('enableIamDatabaseAuthentication', cdk.validateBoolean)(properties.enableIamDatabaseAuthentication));
    errors.collect(cdk.propertyValidator('enablePerformanceInsights', cdk.validateBoolean)(properties.enablePerformanceInsights));
    errors.collect(cdk.propertyValidator('endpoint', CfnDBInstance_EndpointPropertyValidator)(properties.endpoint));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('licenseModel', cdk.validateString)(properties.licenseModel));
    errors.collect(cdk.propertyValidator('manageMasterUserPassword', cdk.validateBoolean)(properties.manageMasterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    errors.collect(cdk.propertyValidator('masterUserSecret', CfnDBInstance_MasterUserSecretPropertyValidator)(properties.masterUserSecret));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.validateString)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('maxAllocatedStorage', cdk.validateNumber)(properties.maxAllocatedStorage));
    errors.collect(cdk.propertyValidator('monitoringInterval', cdk.validateNumber)(properties.monitoringInterval));
    errors.collect(cdk.propertyValidator('monitoringRoleArn', cdk.validateString)(properties.monitoringRoleArn));
    errors.collect(cdk.propertyValidator('multiAz', cdk.validateBoolean)(properties.multiAz));
    errors.collect(cdk.propertyValidator('ncharCharacterSetName', cdk.validateString)(properties.ncharCharacterSetName));
    errors.collect(cdk.propertyValidator('networkType', cdk.validateString)(properties.networkType));
    errors.collect(cdk.propertyValidator('optionGroupName', cdk.validateString)(properties.optionGroupName));
    errors.collect(cdk.propertyValidator('performanceInsightsKmsKeyId', cdk.validateString)(properties.performanceInsightsKmsKeyId));
    errors.collect(cdk.propertyValidator('performanceInsightsRetentionPeriod', cdk.validateNumber)(properties.performanceInsightsRetentionPeriod));
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('processorFeatures', cdk.listValidator(CfnDBInstance_ProcessorFeaturePropertyValidator))(properties.processorFeatures));
    errors.collect(cdk.propertyValidator('promotionTier', cdk.validateNumber)(properties.promotionTier));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('replicaMode', cdk.validateString)(properties.replicaMode));
    errors.collect(cdk.propertyValidator('restoreTime', cdk.validateString)(properties.restoreTime));
    errors.collect(cdk.propertyValidator('sourceDbInstanceAutomatedBackupsArn', cdk.validateString)(properties.sourceDbInstanceAutomatedBackupsArn));
    errors.collect(cdk.propertyValidator('sourceDbInstanceIdentifier', cdk.validateString)(properties.sourceDbInstanceIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbiResourceId', cdk.validateString)(properties.sourceDbiResourceId));
    errors.collect(cdk.propertyValidator('sourceRegion', cdk.validateString)(properties.sourceRegion));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    errors.collect(cdk.propertyValidator('storageThroughput', cdk.validateNumber)(properties.storageThroughput));
    errors.collect(cdk.propertyValidator('storageType', cdk.validateString)(properties.storageType));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('timezone', cdk.validateString)(properties.timezone));
    errors.collect(cdk.propertyValidator('useDefaultProcessorFeatures', cdk.validateBoolean)(properties.useDefaultProcessorFeatures));
    errors.collect(cdk.propertyValidator('useLatestRestorableTime', cdk.validateBoolean)(properties.useLatestRestorableTime));
    errors.collect(cdk.propertyValidator('vpcSecurityGroups', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroups));
    return errors.wrap('supplied properties not correct for "CfnDBInstanceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBInstanceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance` resource.
 */
// @ts-ignore TS6133
function cfnDBInstancePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstancePropsValidator(properties).assertSuccess();
    return {
        AllocatedStorage: cdk.stringToCloudFormation(properties.allocatedStorage),
        AllowMajorVersionUpgrade: cdk.booleanToCloudFormation(properties.allowMajorVersionUpgrade),
        AssociatedRoles: cdk.listMapper(cfnDBInstanceDBInstanceRolePropertyToCloudFormation)(properties.associatedRoles),
        AutoMinorVersionUpgrade: cdk.booleanToCloudFormation(properties.autoMinorVersionUpgrade),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        BackupRetentionPeriod: cdk.numberToCloudFormation(properties.backupRetentionPeriod),
        CACertificateIdentifier: cdk.stringToCloudFormation(properties.caCertificateIdentifier),
        CertificateDetails: cfnDBInstanceCertificateDetailsPropertyToCloudFormation(properties.certificateDetails),
        CertificateRotationRestart: cdk.booleanToCloudFormation(properties.certificateRotationRestart),
        CharacterSetName: cdk.stringToCloudFormation(properties.characterSetName),
        CopyTagsToSnapshot: cdk.booleanToCloudFormation(properties.copyTagsToSnapshot),
        CustomIAMInstanceProfile: cdk.stringToCloudFormation(properties.customIamInstanceProfile),
        DBClusterIdentifier: cdk.stringToCloudFormation(properties.dbClusterIdentifier),
        DBClusterSnapshotIdentifier: cdk.stringToCloudFormation(properties.dbClusterSnapshotIdentifier),
        DBInstanceClass: cdk.stringToCloudFormation(properties.dbInstanceClass),
        DBInstanceIdentifier: cdk.stringToCloudFormation(properties.dbInstanceIdentifier),
        DBName: cdk.stringToCloudFormation(properties.dbName),
        DBParameterGroupName: cdk.stringToCloudFormation(properties.dbParameterGroupName),
        DBSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbSecurityGroups),
        DBSnapshotIdentifier: cdk.stringToCloudFormation(properties.dbSnapshotIdentifier),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        DeleteAutomatedBackups: cdk.booleanToCloudFormation(properties.deleteAutomatedBackups),
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Domain: cdk.stringToCloudFormation(properties.domain),
        DomainIAMRoleName: cdk.stringToCloudFormation(properties.domainIamRoleName),
        EnableCloudwatchLogsExports: cdk.listMapper(cdk.stringToCloudFormation)(properties.enableCloudwatchLogsExports),
        EnableIAMDatabaseAuthentication: cdk.booleanToCloudFormation(properties.enableIamDatabaseAuthentication),
        EnablePerformanceInsights: cdk.booleanToCloudFormation(properties.enablePerformanceInsights),
        Endpoint: cfnDBInstanceEndpointPropertyToCloudFormation(properties.endpoint),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        Iops: cdk.numberToCloudFormation(properties.iops),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        LicenseModel: cdk.stringToCloudFormation(properties.licenseModel),
        ManageMasterUserPassword: cdk.booleanToCloudFormation(properties.manageMasterUserPassword),
        MasterUsername: cdk.stringToCloudFormation(properties.masterUsername),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
        MasterUserSecret: cfnDBInstanceMasterUserSecretPropertyToCloudFormation(properties.masterUserSecret),
        MaxAllocatedStorage: cdk.numberToCloudFormation(properties.maxAllocatedStorage),
        MonitoringInterval: cdk.numberToCloudFormation(properties.monitoringInterval),
        MonitoringRoleArn: cdk.stringToCloudFormation(properties.monitoringRoleArn),
        MultiAZ: cdk.booleanToCloudFormation(properties.multiAz),
        NcharCharacterSetName: cdk.stringToCloudFormation(properties.ncharCharacterSetName),
        NetworkType: cdk.stringToCloudFormation(properties.networkType),
        OptionGroupName: cdk.stringToCloudFormation(properties.optionGroupName),
        PerformanceInsightsKMSKeyId: cdk.stringToCloudFormation(properties.performanceInsightsKmsKeyId),
        PerformanceInsightsRetentionPeriod: cdk.numberToCloudFormation(properties.performanceInsightsRetentionPeriod),
        Port: cdk.stringToCloudFormation(properties.port),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        ProcessorFeatures: cdk.listMapper(cfnDBInstanceProcessorFeaturePropertyToCloudFormation)(properties.processorFeatures),
        PromotionTier: cdk.numberToCloudFormation(properties.promotionTier),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        ReplicaMode: cdk.stringToCloudFormation(properties.replicaMode),
        RestoreTime: cdk.stringToCloudFormation(properties.restoreTime),
        SourceDBInstanceAutomatedBackupsArn: cdk.stringToCloudFormation(properties.sourceDbInstanceAutomatedBackupsArn),
        SourceDBInstanceIdentifier: cdk.stringToCloudFormation(properties.sourceDbInstanceIdentifier),
        SourceDbiResourceId: cdk.stringToCloudFormation(properties.sourceDbiResourceId),
        SourceRegion: cdk.stringToCloudFormation(properties.sourceRegion),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
        StorageThroughput: cdk.numberToCloudFormation(properties.storageThroughput),
        StorageType: cdk.stringToCloudFormation(properties.storageType),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Timezone: cdk.stringToCloudFormation(properties.timezone),
        UseDefaultProcessorFeatures: cdk.booleanToCloudFormation(properties.useDefaultProcessorFeatures),
        UseLatestRestorableTime: cdk.booleanToCloudFormation(properties.useLatestRestorableTime),
        VPCSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroups),
    };
}
// @ts-ignore TS6133
function CfnDBInstancePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allocatedStorage', 'AllocatedStorage', properties.AllocatedStorage != null ? cfn_parse.FromCloudFormation.getString(properties.AllocatedStorage) : undefined);
    ret.addPropertyResult('allowMajorVersionUpgrade', 'AllowMajorVersionUpgrade', properties.AllowMajorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowMajorVersionUpgrade) : undefined);
    ret.addPropertyResult('associatedRoles', 'AssociatedRoles', properties.AssociatedRoles != null ? cfn_parse.FromCloudFormation.getArray(CfnDBInstanceDBInstanceRolePropertyFromCloudFormation)(properties.AssociatedRoles) : undefined);
    ret.addPropertyResult('autoMinorVersionUpgrade', 'AutoMinorVersionUpgrade', properties.AutoMinorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoMinorVersionUpgrade) : undefined);
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('backupRetentionPeriod', 'BackupRetentionPeriod', properties.BackupRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionPeriod) : undefined);
    ret.addPropertyResult('caCertificateIdentifier', 'CACertificateIdentifier', properties.CACertificateIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CACertificateIdentifier) : undefined);
    ret.addPropertyResult('certificateDetails', 'CertificateDetails', properties.CertificateDetails != null ? CfnDBInstanceCertificateDetailsPropertyFromCloudFormation(properties.CertificateDetails) : undefined);
    ret.addPropertyResult('certificateRotationRestart', 'CertificateRotationRestart', properties.CertificateRotationRestart != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CertificateRotationRestart) : undefined);
    ret.addPropertyResult('characterSetName', 'CharacterSetName', properties.CharacterSetName != null ? cfn_parse.FromCloudFormation.getString(properties.CharacterSetName) : undefined);
    ret.addPropertyResult('copyTagsToSnapshot', 'CopyTagsToSnapshot', properties.CopyTagsToSnapshot != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshot) : undefined);
    ret.addPropertyResult('customIamInstanceProfile', 'CustomIAMInstanceProfile', properties.CustomIAMInstanceProfile != null ? cfn_parse.FromCloudFormation.getString(properties.CustomIAMInstanceProfile) : undefined);
    ret.addPropertyResult('dbClusterIdentifier', 'DBClusterIdentifier', properties.DBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterIdentifier) : undefined);
    ret.addPropertyResult('dbClusterSnapshotIdentifier', 'DBClusterSnapshotIdentifier', properties.DBClusterSnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterSnapshotIdentifier) : undefined);
    ret.addPropertyResult('dbInstanceClass', 'DBInstanceClass', properties.DBInstanceClass != null ? cfn_parse.FromCloudFormation.getString(properties.DBInstanceClass) : undefined);
    ret.addPropertyResult('dbInstanceIdentifier', 'DBInstanceIdentifier', properties.DBInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBInstanceIdentifier) : undefined);
    ret.addPropertyResult('dbName', 'DBName', properties.DBName != null ? cfn_parse.FromCloudFormation.getString(properties.DBName) : undefined);
    ret.addPropertyResult('dbParameterGroupName', 'DBParameterGroupName', properties.DBParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBParameterGroupName) : undefined);
    ret.addPropertyResult('dbSecurityGroups', 'DBSecurityGroups', properties.DBSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBSecurityGroups) : undefined);
    ret.addPropertyResult('dbSnapshotIdentifier', 'DBSnapshotIdentifier', properties.DBSnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBSnapshotIdentifier) : undefined);
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('deleteAutomatedBackups', 'DeleteAutomatedBackups', properties.DeleteAutomatedBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAutomatedBackups) : undefined);
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('domainIamRoleName', 'DomainIAMRoleName', properties.DomainIAMRoleName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainIAMRoleName) : undefined);
    ret.addPropertyResult('enableCloudwatchLogsExports', 'EnableCloudwatchLogsExports', properties.EnableCloudwatchLogsExports != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EnableCloudwatchLogsExports) : undefined);
    ret.addPropertyResult('enableIamDatabaseAuthentication', 'EnableIAMDatabaseAuthentication', properties.EnableIAMDatabaseAuthentication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableIAMDatabaseAuthentication) : undefined);
    ret.addPropertyResult('enablePerformanceInsights', 'EnablePerformanceInsights', properties.EnablePerformanceInsights != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnablePerformanceInsights) : undefined);
    ret.addPropertyResult('endpoint', 'Endpoint', properties.Endpoint != null ? CfnDBInstanceEndpointPropertyFromCloudFormation(properties.Endpoint) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('licenseModel', 'LicenseModel', properties.LicenseModel != null ? cfn_parse.FromCloudFormation.getString(properties.LicenseModel) : undefined);
    ret.addPropertyResult('manageMasterUserPassword', 'ManageMasterUserPassword', properties.ManageMasterUserPassword != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ManageMasterUserPassword) : undefined);
    ret.addPropertyResult('masterUsername', 'MasterUsername', properties.MasterUsername != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUsername) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addPropertyResult('masterUserSecret', 'MasterUserSecret', properties.MasterUserSecret != null ? CfnDBInstanceMasterUserSecretPropertyFromCloudFormation(properties.MasterUserSecret) : undefined);
    ret.addPropertyResult('maxAllocatedStorage', 'MaxAllocatedStorage', properties.MaxAllocatedStorage != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxAllocatedStorage) : undefined);
    ret.addPropertyResult('monitoringInterval', 'MonitoringInterval', properties.MonitoringInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.MonitoringInterval) : undefined);
    ret.addPropertyResult('monitoringRoleArn', 'MonitoringRoleArn', properties.MonitoringRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringRoleArn) : undefined);
    ret.addPropertyResult('multiAz', 'MultiAZ', properties.MultiAZ != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiAZ) : undefined);
    ret.addPropertyResult('ncharCharacterSetName', 'NcharCharacterSetName', properties.NcharCharacterSetName != null ? cfn_parse.FromCloudFormation.getString(properties.NcharCharacterSetName) : undefined);
    ret.addPropertyResult('networkType', 'NetworkType', properties.NetworkType != null ? cfn_parse.FromCloudFormation.getString(properties.NetworkType) : undefined);
    ret.addPropertyResult('optionGroupName', 'OptionGroupName', properties.OptionGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.OptionGroupName) : undefined);
    ret.addPropertyResult('performanceInsightsKmsKeyId', 'PerformanceInsightsKMSKeyId', properties.PerformanceInsightsKMSKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.PerformanceInsightsKMSKeyId) : undefined);
    ret.addPropertyResult('performanceInsightsRetentionPeriod', 'PerformanceInsightsRetentionPeriod', properties.PerformanceInsightsRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.PerformanceInsightsRetentionPeriod) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('processorFeatures', 'ProcessorFeatures', properties.ProcessorFeatures != null ? cfn_parse.FromCloudFormation.getArray(CfnDBInstanceProcessorFeaturePropertyFromCloudFormation)(properties.ProcessorFeatures) : undefined);
    ret.addPropertyResult('promotionTier', 'PromotionTier', properties.PromotionTier != null ? cfn_parse.FromCloudFormation.getNumber(properties.PromotionTier) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('replicaMode', 'ReplicaMode', properties.ReplicaMode != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicaMode) : undefined);
    ret.addPropertyResult('restoreTime', 'RestoreTime', properties.RestoreTime != null ? cfn_parse.FromCloudFormation.getString(properties.RestoreTime) : undefined);
    ret.addPropertyResult('sourceDbInstanceAutomatedBackupsArn', 'SourceDBInstanceAutomatedBackupsArn', properties.SourceDBInstanceAutomatedBackupsArn != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBInstanceAutomatedBackupsArn) : undefined);
    ret.addPropertyResult('sourceDbInstanceIdentifier', 'SourceDBInstanceIdentifier', properties.SourceDBInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBInstanceIdentifier) : undefined);
    ret.addPropertyResult('sourceDbiResourceId', 'SourceDbiResourceId', properties.SourceDbiResourceId != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDbiResourceId) : undefined);
    ret.addPropertyResult('sourceRegion', 'SourceRegion', properties.SourceRegion != null ? cfn_parse.FromCloudFormation.getString(properties.SourceRegion) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addPropertyResult('storageThroughput', 'StorageThroughput', properties.StorageThroughput != null ? cfn_parse.FromCloudFormation.getNumber(properties.StorageThroughput) : undefined);
    ret.addPropertyResult('storageType', 'StorageType', properties.StorageType != null ? cfn_parse.FromCloudFormation.getString(properties.StorageType) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('timezone', 'Timezone', properties.Timezone != null ? cfn_parse.FromCloudFormation.getString(properties.Timezone) : undefined);
    ret.addPropertyResult('useDefaultProcessorFeatures', 'UseDefaultProcessorFeatures', properties.UseDefaultProcessorFeatures != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseDefaultProcessorFeatures) : undefined);
    ret.addPropertyResult('useLatestRestorableTime', 'UseLatestRestorableTime', properties.UseLatestRestorableTime != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseLatestRestorableTime) : undefined);
    ret.addPropertyResult('vpcSecurityGroups', 'VPCSecurityGroups', properties.VPCSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VPCSecurityGroups) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`
 *
 * The `AWS::RDS::DBInstance` resource creates an Amazon DB instance. The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster.
 *
 * For more information about creating an RDS DB instance, see [Creating an Amazon RDS DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html) in the *Amazon RDS User Guide* .
 *
 * For more information about creating a DB instance in an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide* .
 *
 * If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
 *
 * > If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see [Prevent Updates to Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html) .
 *
 * *Updating DB instances*
 *
 * When properties labeled " *Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement) " are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
 *
 * > We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
 * >
 * > - Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.
 * > - Create a snapshot of the DB instance. For more information, see [Creating a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html) .
 * > - If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the `DBSnapshotIdentifier` property with the ID of the DB snapshot that you want to use.
 * >
 * > After you restore a DB instance with a `DBSnapshotIdentifier` property, you must specify the same `DBSnapshotIdentifier` property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the `DBSnapshotIdentifier` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified `DBSnapshotIdentifier` property, and the original DB instance is deleted.
 * > - Update the stack.
 *
 * For more information about updating other properties of this resource, see `[ModifyDBInstance](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBInstance.html)` . For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * *Deleting DB instances*
 *
 * For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to *retain* the DB instance, to *delete* the DB instance, or to *create a snapshot* of the DB instance. The default AWS CloudFormation behavior depends on the `DBClusterIdentifier` property:
 *
 * - For `AWS::RDS::DBInstance` resources that don't specify the `DBClusterIdentifier` property, AWS CloudFormation saves a snapshot of the DB instance.
 * - For `AWS::RDS::DBInstance` resources that do specify the `DBClusterIdentifier` property, AWS CloudFormation deletes the DB instance.
 *
 * For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .
 *
 * @cloudformationResource AWS::RDS::DBInstance
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html
 */
class CfnDBInstance extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDBInstance.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBInstance);
            }
            throw error;
        }
        this.attrCertificateDetailsCaIdentifier = cdk.Token.asString(this.getAtt('CertificateDetails.CAIdentifier'));
        this.attrCertificateDetailsValidTill = cdk.Token.asString(this.getAtt('CertificateDetails.ValidTill'));
        this.attrDbInstanceArn = cdk.Token.asString(this.getAtt('DBInstanceArn'));
        this.attrDbSystemId = cdk.Token.asString(this.getAtt('DBSystemId'));
        this.attrDbiResourceId = cdk.Token.asString(this.getAtt('DbiResourceId'));
        this.attrEndpointAddress = cdk.Token.asString(this.getAtt('Endpoint.Address'));
        this.attrEndpointHostedZoneId = cdk.Token.asString(this.getAtt('Endpoint.HostedZoneId'));
        this.attrEndpointPort = cdk.Token.asString(this.getAtt('Endpoint.Port'));
        this.attrMasterUserSecretSecretArn = cdk.Token.asString(this.getAtt('MasterUserSecret.SecretArn'));
        this.allocatedStorage = props.allocatedStorage;
        this.allowMajorVersionUpgrade = props.allowMajorVersionUpgrade;
        this.associatedRoles = props.associatedRoles;
        this.autoMinorVersionUpgrade = props.autoMinorVersionUpgrade;
        this.availabilityZone = props.availabilityZone;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.caCertificateIdentifier = props.caCertificateIdentifier;
        this.certificateDetails = props.certificateDetails;
        this.certificateRotationRestart = props.certificateRotationRestart;
        this.characterSetName = props.characterSetName;
        this.copyTagsToSnapshot = props.copyTagsToSnapshot;
        this.customIamInstanceProfile = props.customIamInstanceProfile;
        this.dbClusterIdentifier = props.dbClusterIdentifier;
        this.dbClusterSnapshotIdentifier = props.dbClusterSnapshotIdentifier;
        this.dbInstanceClass = props.dbInstanceClass;
        this.dbInstanceIdentifier = props.dbInstanceIdentifier;
        this.dbName = props.dbName;
        this.dbParameterGroupName = props.dbParameterGroupName;
        this.dbSecurityGroups = props.dbSecurityGroups;
        this.dbSnapshotIdentifier = props.dbSnapshotIdentifier;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.deleteAutomatedBackups = props.deleteAutomatedBackups;
        this.deletionProtection = props.deletionProtection;
        this.domain = props.domain;
        this.domainIamRoleName = props.domainIamRoleName;
        this.enableCloudwatchLogsExports = props.enableCloudwatchLogsExports;
        this.enableIamDatabaseAuthentication = props.enableIamDatabaseAuthentication;
        this.enablePerformanceInsights = props.enablePerformanceInsights;
        this.endpoint = props.endpoint;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.iops = props.iops;
        this.kmsKeyId = props.kmsKeyId;
        this.licenseModel = props.licenseModel;
        this.manageMasterUserPassword = props.manageMasterUserPassword;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.masterUserSecret = props.masterUserSecret;
        this.maxAllocatedStorage = props.maxAllocatedStorage;
        this.monitoringInterval = props.monitoringInterval;
        this.monitoringRoleArn = props.monitoringRoleArn;
        this.multiAz = props.multiAz;
        this.ncharCharacterSetName = props.ncharCharacterSetName;
        this.networkType = props.networkType;
        this.optionGroupName = props.optionGroupName;
        this.performanceInsightsKmsKeyId = props.performanceInsightsKmsKeyId;
        this.performanceInsightsRetentionPeriod = props.performanceInsightsRetentionPeriod;
        this.port = props.port;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.processorFeatures = props.processorFeatures;
        this.promotionTier = props.promotionTier;
        this.publiclyAccessible = props.publiclyAccessible;
        this.replicaMode = props.replicaMode;
        this.restoreTime = props.restoreTime;
        this.sourceDbInstanceAutomatedBackupsArn = props.sourceDbInstanceAutomatedBackupsArn;
        this.sourceDbInstanceIdentifier = props.sourceDbInstanceIdentifier;
        this.sourceDbiResourceId = props.sourceDbiResourceId;
        this.sourceRegion = props.sourceRegion;
        this.storageEncrypted = props.storageEncrypted;
        this.storageThroughput = props.storageThroughput;
        this.storageType = props.storageType;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBInstance", props.tags, { tagPropertyName: 'tags' });
        this.timezone = props.timezone;
        this.useDefaultProcessorFeatures = props.useDefaultProcessorFeatures;
        this.useLatestRestorableTime = props.useLatestRestorableTime;
        this.vpcSecurityGroups = props.vpcSecurityGroups;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::RDS::DBInstance\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBInstancePropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBInstance(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBInstance.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allocatedStorage: this.allocatedStorage,
            allowMajorVersionUpgrade: this.allowMajorVersionUpgrade,
            associatedRoles: this.associatedRoles,
            autoMinorVersionUpgrade: this.autoMinorVersionUpgrade,
            availabilityZone: this.availabilityZone,
            backupRetentionPeriod: this.backupRetentionPeriod,
            caCertificateIdentifier: this.caCertificateIdentifier,
            certificateDetails: this.certificateDetails,
            certificateRotationRestart: this.certificateRotationRestart,
            characterSetName: this.characterSetName,
            copyTagsToSnapshot: this.copyTagsToSnapshot,
            customIamInstanceProfile: this.customIamInstanceProfile,
            dbClusterIdentifier: this.dbClusterIdentifier,
            dbClusterSnapshotIdentifier: this.dbClusterSnapshotIdentifier,
            dbInstanceClass: this.dbInstanceClass,
            dbInstanceIdentifier: this.dbInstanceIdentifier,
            dbName: this.dbName,
            dbParameterGroupName: this.dbParameterGroupName,
            dbSecurityGroups: this.dbSecurityGroups,
            dbSnapshotIdentifier: this.dbSnapshotIdentifier,
            dbSubnetGroupName: this.dbSubnetGroupName,
            deleteAutomatedBackups: this.deleteAutomatedBackups,
            deletionProtection: this.deletionProtection,
            domain: this.domain,
            domainIamRoleName: this.domainIamRoleName,
            enableCloudwatchLogsExports: this.enableCloudwatchLogsExports,
            enableIamDatabaseAuthentication: this.enableIamDatabaseAuthentication,
            enablePerformanceInsights: this.enablePerformanceInsights,
            endpoint: this.endpoint,
            engine: this.engine,
            engineVersion: this.engineVersion,
            iops: this.iops,
            kmsKeyId: this.kmsKeyId,
            licenseModel: this.licenseModel,
            manageMasterUserPassword: this.manageMasterUserPassword,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            masterUserSecret: this.masterUserSecret,
            maxAllocatedStorage: this.maxAllocatedStorage,
            monitoringInterval: this.monitoringInterval,
            monitoringRoleArn: this.monitoringRoleArn,
            multiAz: this.multiAz,
            ncharCharacterSetName: this.ncharCharacterSetName,
            networkType: this.networkType,
            optionGroupName: this.optionGroupName,
            performanceInsightsKmsKeyId: this.performanceInsightsKmsKeyId,
            performanceInsightsRetentionPeriod: this.performanceInsightsRetentionPeriod,
            port: this.port,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            processorFeatures: this.processorFeatures,
            promotionTier: this.promotionTier,
            publiclyAccessible: this.publiclyAccessible,
            replicaMode: this.replicaMode,
            restoreTime: this.restoreTime,
            sourceDbInstanceAutomatedBackupsArn: this.sourceDbInstanceAutomatedBackupsArn,
            sourceDbInstanceIdentifier: this.sourceDbInstanceIdentifier,
            sourceDbiResourceId: this.sourceDbiResourceId,
            sourceRegion: this.sourceRegion,
            storageEncrypted: this.storageEncrypted,
            storageThroughput: this.storageThroughput,
            storageType: this.storageType,
            tags: this.tags.renderTags(),
            timezone: this.timezone,
            useDefaultProcessorFeatures: this.useDefaultProcessorFeatures,
            useLatestRestorableTime: this.useLatestRestorableTime,
            vpcSecurityGroups: this.vpcSecurityGroups,
        };
    }
    renderProperties(props) {
        return cfnDBInstancePropsToCloudFormation(props);
    }
}
exports.CfnDBInstance = CfnDBInstance;
_c = JSII_RTTI_SYMBOL_1;
CfnDBInstance[_c] = { fqn: "monocdk.aws_rds.CfnDBInstance", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBInstance.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBInstance";
/**
 * Determine whether the given properties match those of a `CertificateDetailsProperty`
 *
 * @param properties - the TypeScript properties of a `CertificateDetailsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_CertificateDetailsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('caIdentifier', cdk.validateString)(properties.caIdentifier));
    errors.collect(cdk.propertyValidator('validTill', cdk.validateString)(properties.validTill));
    return errors.wrap('supplied properties not correct for "CertificateDetailsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.CertificateDetails` resource
 *
 * @param properties - the TypeScript properties of a `CertificateDetailsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.CertificateDetails` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceCertificateDetailsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_CertificateDetailsPropertyValidator(properties).assertSuccess();
    return {
        CAIdentifier: cdk.stringToCloudFormation(properties.caIdentifier),
        ValidTill: cdk.stringToCloudFormation(properties.validTill),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceCertificateDetailsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('caIdentifier', 'CAIdentifier', properties.CAIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CAIdentifier) : undefined);
    ret.addPropertyResult('validTill', 'ValidTill', properties.ValidTill != null ? cfn_parse.FromCloudFormation.getString(properties.ValidTill) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DBInstanceRoleProperty`
 *
 * @param properties - the TypeScript properties of a `DBInstanceRoleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_DBInstanceRolePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('featureName', cdk.requiredValidator)(properties.featureName));
    errors.collect(cdk.propertyValidator('featureName', cdk.validateString)(properties.featureName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "DBInstanceRoleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.DBInstanceRole` resource
 *
 * @param properties - the TypeScript properties of a `DBInstanceRoleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.DBInstanceRole` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceDBInstanceRolePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_DBInstanceRolePropertyValidator(properties).assertSuccess();
    return {
        FeatureName: cdk.stringToCloudFormation(properties.featureName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceDBInstanceRolePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('featureName', 'FeatureName', cfn_parse.FromCloudFormation.getString(properties.FeatureName));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_EndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('address', cdk.validateString)(properties.address));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    return errors.wrap('supplied properties not correct for "EndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.Endpoint` resource
 *
 * @param properties - the TypeScript properties of a `EndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.Endpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_EndpointPropertyValidator(properties).assertSuccess();
    return {
        Address: cdk.stringToCloudFormation(properties.address),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        Port: cdk.stringToCloudFormation(properties.port),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('address', 'Address', properties.Address != null ? cfn_parse.FromCloudFormation.getString(properties.Address) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MasterUserSecretProperty`
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_MasterUserSecretPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    return errors.wrap('supplied properties not correct for "MasterUserSecretProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.MasterUserSecret` resource
 *
 * @param properties - the TypeScript properties of a `MasterUserSecretProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.MasterUserSecret` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceMasterUserSecretPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_MasterUserSecretPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceMasterUserSecretPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProcessorFeatureProperty`
 *
 * @param properties - the TypeScript properties of a `ProcessorFeatureProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_ProcessorFeaturePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ProcessorFeatureProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.ProcessorFeature` resource
 *
 * @param properties - the TypeScript properties of a `ProcessorFeatureProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.ProcessorFeature` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceProcessorFeaturePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_ProcessorFeaturePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceProcessorFeaturePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBParameterGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBParameterGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBParameterGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbParameterGroupName', cdk.validateString)(properties.dbParameterGroupName));
    errors.collect(cdk.propertyValidator('description', cdk.requiredValidator)(properties.description));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('family', cdk.requiredValidator)(properties.family));
    errors.collect(cdk.propertyValidator('family', cdk.validateString)(properties.family));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBParameterGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBParameterGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBParameterGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBParameterGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBParameterGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBParameterGroupPropsValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        Family: cdk.stringToCloudFormation(properties.family),
        DBParameterGroupName: cdk.stringToCloudFormation(properties.dbParameterGroupName),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBParameterGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', cfn_parse.FromCloudFormation.getString(properties.Description));
    ret.addPropertyResult('family', 'Family', cfn_parse.FromCloudFormation.getString(properties.Family));
    ret.addPropertyResult('dbParameterGroupName', 'DBParameterGroupName', properties.DBParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBParameterGroupName) : undefined);
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getAny(properties.Parameters) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBParameterGroup`
 *
 * The `AWS::RDS::DBParameterGroup` resource creates a custom parameter group for an RDS database family.
 *
 * This type can be declared in a template and referenced in the `DBParameterGroupName` property of an `[AWS::RDS::DBInstance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html)` resource.
 *
 * For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide* .
 *
 * For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide* .
 *
 * > Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.
 *
 * @cloudformationResource AWS::RDS::DBParameterGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbparametergroup.html
 */
class CfnDBParameterGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBParameterGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'description', this);
        cdk.requireProperty(props, 'family', this);
        this.attrDbParameterGroupName = cdk.Token.asString(this.getAtt('DBParameterGroupName'));
        this.description = props.description;
        this.family = props.family;
        this.dbParameterGroupName = props.dbParameterGroupName;
        this.parameters = props.parameters;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBParameterGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBParameterGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBParameterGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            description: this.description,
            family: this.family,
            dbParameterGroupName: this.dbParameterGroupName,
            parameters: this.parameters,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBParameterGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBParameterGroup = CfnDBParameterGroup;
_d = JSII_RTTI_SYMBOL_1;
CfnDBParameterGroup[_d] = { fqn: "monocdk.aws_rds.CfnDBParameterGroup", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBParameterGroup";
/**
 * Determine whether the given properties match those of a `CfnDBProxyProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('auth', cdk.requiredValidator)(properties.auth));
    errors.collect(cdk.propertyValidator('auth', cdk.listValidator(CfnDBProxy_AuthFormatPropertyValidator))(properties.auth));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('debugLogging', cdk.validateBoolean)(properties.debugLogging));
    errors.collect(cdk.propertyValidator('engineFamily', cdk.requiredValidator)(properties.engineFamily));
    errors.collect(cdk.propertyValidator('engineFamily', cdk.validateString)(properties.engineFamily));
    errors.collect(cdk.propertyValidator('idleClientTimeout', cdk.validateNumber)(properties.idleClientTimeout));
    errors.collect(cdk.propertyValidator('requireTls', cdk.validateBoolean)(properties.requireTls));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnDBProxy_TagFormatPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.requiredValidator)(properties.vpcSubnetIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.listValidator(cdk.validateString))(properties.vpcSubnetIds));
    return errors.wrap('supplied properties not correct for "CfnDBProxyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyPropsValidator(properties).assertSuccess();
    return {
        Auth: cdk.listMapper(cfnDBProxyAuthFormatPropertyToCloudFormation)(properties.auth),
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        EngineFamily: cdk.stringToCloudFormation(properties.engineFamily),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        VpcSubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnetIds),
        DebugLogging: cdk.booleanToCloudFormation(properties.debugLogging),
        IdleClientTimeout: cdk.numberToCloudFormation(properties.idleClientTimeout),
        RequireTLS: cdk.booleanToCloudFormation(properties.requireTls),
        Tags: cdk.listMapper(cfnDBProxyTagFormatPropertyToCloudFormation)(properties.tags),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBProxyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('auth', 'Auth', cfn_parse.FromCloudFormation.getArray(CfnDBProxyAuthFormatPropertyFromCloudFormation)(properties.Auth));
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('engineFamily', 'EngineFamily', cfn_parse.FromCloudFormation.getString(properties.EngineFamily));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('vpcSubnetIds', 'VpcSubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnetIds));
    ret.addPropertyResult('debugLogging', 'DebugLogging', properties.DebugLogging != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DebugLogging) : undefined);
    ret.addPropertyResult('idleClientTimeout', 'IdleClientTimeout', properties.IdleClientTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.IdleClientTimeout) : undefined);
    ret.addPropertyResult('requireTls', 'RequireTLS', properties.RequireTLS != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireTLS) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnDBProxyTagFormatPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`
 *
 * The `AWS::RDS::DBProxy` resource creates or updates a DB proxy.
 *
 * For information about RDS Proxy for Amazon RDS, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html) in the *Amazon RDS User Guide* .
 *
 * For information about RDS Proxy for Amazon Aurora, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html) in the *Amazon Aurora User Guide* .
 *
 * > Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * >
 * > For information about limitations that apply to RDS Proxy for Amazon RDS, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon RDS User Guide* .
 * >
 * > For information about that apply to RDS Proxy for Amazon Aurora, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBProxy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 */
class CfnDBProxy extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBProxy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBProxyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBProxy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'auth', this);
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'engineFamily', this);
        cdk.requireProperty(props, 'roleArn', this);
        cdk.requireProperty(props, 'vpcSubnetIds', this);
        this.attrDbProxyArn = cdk.Token.asString(this.getAtt('DBProxyArn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.attrVpcId = cdk.Token.asString(this.getAtt('VpcId'));
        this.auth = props.auth;
        this.dbProxyName = props.dbProxyName;
        this.engineFamily = props.engineFamily;
        this.roleArn = props.roleArn;
        this.vpcSubnetIds = props.vpcSubnetIds;
        this.debugLogging = props.debugLogging;
        this.idleClientTimeout = props.idleClientTimeout;
        this.requireTls = props.requireTls;
        this.tags = props.tags;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            auth: this.auth,
            dbProxyName: this.dbProxyName,
            engineFamily: this.engineFamily,
            roleArn: this.roleArn,
            vpcSubnetIds: this.vpcSubnetIds,
            debugLogging: this.debugLogging,
            idleClientTimeout: this.idleClientTimeout,
            requireTls: this.requireTls,
            tags: this.tags,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBProxyPropsToCloudFormation(props);
    }
}
exports.CfnDBProxy = CfnDBProxy;
_e = JSII_RTTI_SYMBOL_1;
CfnDBProxy[_e] = { fqn: "monocdk.aws_rds.CfnDBProxy", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxy.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxy";
/**
 * Determine whether the given properties match those of a `AuthFormatProperty`
 *
 * @param properties - the TypeScript properties of a `AuthFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxy_AuthFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authScheme', cdk.validateString)(properties.authScheme));
    errors.collect(cdk.propertyValidator('clientPasswordAuthType', cdk.validateString)(properties.clientPasswordAuthType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('iamAuth', cdk.validateString)(properties.iamAuth));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    errors.collect(cdk.propertyValidator('userName', cdk.validateString)(properties.userName));
    return errors.wrap('supplied properties not correct for "AuthFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy.AuthFormat` resource
 *
 * @param properties - the TypeScript properties of a `AuthFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy.AuthFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyAuthFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxy_AuthFormatPropertyValidator(properties).assertSuccess();
    return {
        AuthScheme: cdk.stringToCloudFormation(properties.authScheme),
        ClientPasswordAuthType: cdk.stringToCloudFormation(properties.clientPasswordAuthType),
        Description: cdk.stringToCloudFormation(properties.description),
        IAMAuth: cdk.stringToCloudFormation(properties.iamAuth),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
        UserName: cdk.stringToCloudFormation(properties.userName),
    };
}
// @ts-ignore TS6133
function CfnDBProxyAuthFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authScheme', 'AuthScheme', properties.AuthScheme != null ? cfn_parse.FromCloudFormation.getString(properties.AuthScheme) : undefined);
    ret.addPropertyResult('clientPasswordAuthType', 'ClientPasswordAuthType', properties.ClientPasswordAuthType != null ? cfn_parse.FromCloudFormation.getString(properties.ClientPasswordAuthType) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('iamAuth', 'IAMAuth', properties.IAMAuth != null ? cfn_parse.FromCloudFormation.getString(properties.IAMAuth) : undefined);
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addPropertyResult('userName', 'UserName', properties.UserName != null ? cfn_parse.FromCloudFormation.getString(properties.UserName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TagFormatProperty`
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxy_TagFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy.TagFormat` resource
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy.TagFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTagFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxy_TagFormatPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTagFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBProxyEndpointProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyEndpointProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyEndpointPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbProxyEndpointName', cdk.requiredValidator)(properties.dbProxyEndpointName));
    errors.collect(cdk.propertyValidator('dbProxyEndpointName', cdk.validateString)(properties.dbProxyEndpointName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnDBProxyEndpoint_TagFormatPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('targetRole', cdk.validateString)(properties.targetRole));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.requiredValidator)(properties.vpcSubnetIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.listValidator(cdk.validateString))(properties.vpcSubnetIds));
    return errors.wrap('supplied properties not correct for "CfnDBProxyEndpointProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyEndpointProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyEndpointPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyEndpointPropsValidator(properties).assertSuccess();
    return {
        DBProxyEndpointName: cdk.stringToCloudFormation(properties.dbProxyEndpointName),
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        VpcSubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnetIds),
        Tags: cdk.listMapper(cfnDBProxyEndpointTagFormatPropertyToCloudFormation)(properties.tags),
        TargetRole: cdk.stringToCloudFormation(properties.targetRole),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBProxyEndpointPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbProxyEndpointName', 'DBProxyEndpointName', cfn_parse.FromCloudFormation.getString(properties.DBProxyEndpointName));
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('vpcSubnetIds', 'VpcSubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnetIds));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnDBProxyEndpointTagFormatPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('targetRole', 'TargetRole', properties.TargetRole != null ? cfn_parse.FromCloudFormation.getString(properties.TargetRole) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxyEndpoint`
 *
 * The `AWS::RDS::DBProxyEndpoint` resource creates or updates a DB proxy endpoint. You can use custom proxy endpoints to access a proxy through a different VPC than the proxy's default VPC.
 *
 * For more information about RDS Proxy, see [AWS::RDS::DBProxy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html) .
 *
 * @cloudformationResource AWS::RDS::DBProxyEndpoint
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html
 */
class CfnDBProxyEndpoint extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBProxyEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBProxyEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBProxyEndpoint);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbProxyEndpointName', this);
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'vpcSubnetIds', this);
        this.attrDbProxyEndpointArn = cdk.Token.asString(this.getAtt('DBProxyEndpointArn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.attrIsDefault = this.getAtt('IsDefault');
        this.attrVpcId = cdk.Token.asString(this.getAtt('VpcId'));
        this.dbProxyEndpointName = props.dbProxyEndpointName;
        this.dbProxyName = props.dbProxyName;
        this.vpcSubnetIds = props.vpcSubnetIds;
        this.tags = props.tags;
        this.targetRole = props.targetRole;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyEndpointPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxyEndpoint(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbProxyEndpointName: this.dbProxyEndpointName,
            dbProxyName: this.dbProxyName,
            vpcSubnetIds: this.vpcSubnetIds,
            tags: this.tags,
            targetRole: this.targetRole,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBProxyEndpointPropsToCloudFormation(props);
    }
}
exports.CfnDBProxyEndpoint = CfnDBProxyEndpoint;
_f = JSII_RTTI_SYMBOL_1;
CfnDBProxyEndpoint[_f] = { fqn: "monocdk.aws_rds.CfnDBProxyEndpoint", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyEndpoint";
/**
 * Determine whether the given properties match those of a `TagFormatProperty`
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyEndpoint_TagFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint.TagFormat` resource
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint.TagFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyEndpointTagFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyEndpoint_TagFormatPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBProxyEndpointTagFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBProxyTargetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyTargetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyTargetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('connectionPoolConfigurationInfo', CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator)(properties.connectionPoolConfigurationInfo));
    errors.collect(cdk.propertyValidator('dbClusterIdentifiers', cdk.listValidator(cdk.validateString))(properties.dbClusterIdentifiers));
    errors.collect(cdk.propertyValidator('dbInstanceIdentifiers', cdk.listValidator(cdk.validateString))(properties.dbInstanceIdentifiers));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('targetGroupName', cdk.requiredValidator)(properties.targetGroupName));
    errors.collect(cdk.propertyValidator('targetGroupName', cdk.validateString)(properties.targetGroupName));
    return errors.wrap('supplied properties not correct for "CfnDBProxyTargetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyTargetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTargetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyTargetGroupPropsValidator(properties).assertSuccess();
    return {
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        TargetGroupName: cdk.stringToCloudFormation(properties.targetGroupName),
        ConnectionPoolConfigurationInfo: cfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyToCloudFormation(properties.connectionPoolConfigurationInfo),
        DBClusterIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbClusterIdentifiers),
        DBInstanceIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbInstanceIdentifiers),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTargetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('targetGroupName', 'TargetGroupName', cfn_parse.FromCloudFormation.getString(properties.TargetGroupName));
    ret.addPropertyResult('connectionPoolConfigurationInfo', 'ConnectionPoolConfigurationInfo', properties.ConnectionPoolConfigurationInfo != null ? CfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyFromCloudFormation(properties.ConnectionPoolConfigurationInfo) : undefined);
    ret.addPropertyResult('dbClusterIdentifiers', 'DBClusterIdentifiers', properties.DBClusterIdentifiers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBClusterIdentifiers) : undefined);
    ret.addPropertyResult('dbInstanceIdentifiers', 'DBInstanceIdentifiers', properties.DBInstanceIdentifiers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBInstanceIdentifiers) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`
 *
 * The `AWS::RDS::DBProxyTargetGroup` resource represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.
 *
 * This data type is used as a response element in the `DescribeDBProxyTargetGroups` action.
 *
 * For information about RDS Proxy for Amazon RDS, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html) in the *Amazon RDS User Guide* .
 *
 * For information about RDS Proxy for Amazon Aurora, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html) in the *Amazon Aurora User Guide* .
 *
 * For a sample template that creates a DB proxy and registers a DB instance, see [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#aws-resource-rds-dbproxy--examples) in AWS::RDS::DBProxy.
 *
 * > Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * >
 * > For information about limitations that apply to RDS Proxy for Amazon RDS, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon RDS User Guide* .
 * >
 * > For information about that apply to RDS Proxy for Amazon Aurora, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBProxyTargetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 */
class CfnDBProxyTargetGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBProxyTargetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBProxyTargetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBProxyTargetGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'targetGroupName', this);
        this.attrTargetGroupArn = cdk.Token.asString(this.getAtt('TargetGroupArn'));
        this.dbProxyName = props.dbProxyName;
        this.targetGroupName = props.targetGroupName;
        this.connectionPoolConfigurationInfo = props.connectionPoolConfigurationInfo;
        this.dbClusterIdentifiers = props.dbClusterIdentifiers;
        this.dbInstanceIdentifiers = props.dbInstanceIdentifiers;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyTargetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxyTargetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbProxyName: this.dbProxyName,
            targetGroupName: this.targetGroupName,
            connectionPoolConfigurationInfo: this.connectionPoolConfigurationInfo,
            dbClusterIdentifiers: this.dbClusterIdentifiers,
            dbInstanceIdentifiers: this.dbInstanceIdentifiers,
        };
    }
    renderProperties(props) {
        return cfnDBProxyTargetGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBProxyTargetGroup = CfnDBProxyTargetGroup;
_g = JSII_RTTI_SYMBOL_1;
CfnDBProxyTargetGroup[_g] = { fqn: "monocdk.aws_rds.CfnDBProxyTargetGroup", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyTargetGroup";
/**
 * Determine whether the given properties match those of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @param properties - the TypeScript properties of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('connectionBorrowTimeout', cdk.validateNumber)(properties.connectionBorrowTimeout));
    errors.collect(cdk.propertyValidator('initQuery', cdk.validateString)(properties.initQuery));
    errors.collect(cdk.propertyValidator('maxConnectionsPercent', cdk.validateNumber)(properties.maxConnectionsPercent));
    errors.collect(cdk.propertyValidator('maxIdleConnectionsPercent', cdk.validateNumber)(properties.maxIdleConnectionsPercent));
    errors.collect(cdk.propertyValidator('sessionPinningFilters', cdk.listValidator(cdk.validateString))(properties.sessionPinningFilters));
    return errors.wrap('supplied properties not correct for "ConnectionPoolConfigurationInfoFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat` resource
 *
 * @param properties - the TypeScript properties of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator(properties).assertSuccess();
    return {
        ConnectionBorrowTimeout: cdk.numberToCloudFormation(properties.connectionBorrowTimeout),
        InitQuery: cdk.stringToCloudFormation(properties.initQuery),
        MaxConnectionsPercent: cdk.numberToCloudFormation(properties.maxConnectionsPercent),
        MaxIdleConnectionsPercent: cdk.numberToCloudFormation(properties.maxIdleConnectionsPercent),
        SessionPinningFilters: cdk.listMapper(cdk.stringToCloudFormation)(properties.sessionPinningFilters),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('connectionBorrowTimeout', 'ConnectionBorrowTimeout', properties.ConnectionBorrowTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.ConnectionBorrowTimeout) : undefined);
    ret.addPropertyResult('initQuery', 'InitQuery', properties.InitQuery != null ? cfn_parse.FromCloudFormation.getString(properties.InitQuery) : undefined);
    ret.addPropertyResult('maxConnectionsPercent', 'MaxConnectionsPercent', properties.MaxConnectionsPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxConnectionsPercent) : undefined);
    ret.addPropertyResult('maxIdleConnectionsPercent', 'MaxIdleConnectionsPercent', properties.MaxIdleConnectionsPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxIdleConnectionsPercent) : undefined);
    ret.addPropertyResult('sessionPinningFilters', 'SessionPinningFilters', properties.SessionPinningFilters != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SessionPinningFilters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBSecurityGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSecurityGroupIngress', cdk.requiredValidator)(properties.dbSecurityGroupIngress));
    errors.collect(cdk.propertyValidator('dbSecurityGroupIngress', cdk.listValidator(CfnDBSecurityGroup_IngressPropertyValidator))(properties.dbSecurityGroupIngress));
    errors.collect(cdk.propertyValidator('ec2VpcId', cdk.validateString)(properties.ec2VpcId));
    errors.collect(cdk.propertyValidator('groupDescription', cdk.requiredValidator)(properties.groupDescription));
    errors.collect(cdk.propertyValidator('groupDescription', cdk.validateString)(properties.groupDescription));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBSecurityGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroupPropsValidator(properties).assertSuccess();
    return {
        DBSecurityGroupIngress: cdk.listMapper(cfnDBSecurityGroupIngressPropertyToCloudFormation)(properties.dbSecurityGroupIngress),
        GroupDescription: cdk.stringToCloudFormation(properties.groupDescription),
        EC2VpcId: cdk.stringToCloudFormation(properties.ec2VpcId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupIngress', 'DBSecurityGroupIngress', cfn_parse.FromCloudFormation.getArray(CfnDBSecurityGroupIngressPropertyFromCloudFormation)(properties.DBSecurityGroupIngress));
    ret.addPropertyResult('groupDescription', 'GroupDescription', cfn_parse.FromCloudFormation.getString(properties.GroupDescription));
    ret.addPropertyResult('ec2VpcId', 'EC2VpcId', properties.EC2VpcId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2VpcId) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`
 *
 * The `AWS::RDS::DBSecurityGroup` resource creates or updates an Amazon RDS DB security group.
 *
 * > EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide* , the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](https://docs.aws.amazon.com/aws/ec2-classic-is-retiring-heres-how-to-prepare/) , and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
class CfnDBSecurityGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBSecurityGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBSecurityGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbSecurityGroupIngress', this);
        cdk.requireProperty(props, 'groupDescription', this);
        this.dbSecurityGroupIngress = props.dbSecurityGroupIngress;
        this.groupDescription = props.groupDescription;
        this.ec2VpcId = props.ec2VpcId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBSecurityGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSecurityGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSecurityGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSecurityGroupIngress: this.dbSecurityGroupIngress,
            groupDescription: this.groupDescription,
            ec2VpcId: this.ec2VpcId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBSecurityGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBSecurityGroup = CfnDBSecurityGroup;
_h = JSII_RTTI_SYMBOL_1;
CfnDBSecurityGroup[_h] = { fqn: "monocdk.aws_rds.CfnDBSecurityGroup", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroup";
/**
 * Determine whether the given properties match those of a `IngressProperty`
 *
 * @param properties - the TypeScript properties of a `IngressProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroup_IngressPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrip', cdk.validateString)(properties.cidrip));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupId', cdk.validateString)(properties.ec2SecurityGroupId));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupName', cdk.validateString)(properties.ec2SecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupOwnerId', cdk.validateString)(properties.ec2SecurityGroupOwnerId));
    return errors.wrap('supplied properties not correct for "IngressProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup.Ingress` resource
 *
 * @param properties - the TypeScript properties of a `IngressProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup.Ingress` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupIngressPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroup_IngressPropertyValidator(properties).assertSuccess();
    return {
        CIDRIP: cdk.stringToCloudFormation(properties.cidrip),
        EC2SecurityGroupId: cdk.stringToCloudFormation(properties.ec2SecurityGroupId),
        EC2SecurityGroupName: cdk.stringToCloudFormation(properties.ec2SecurityGroupName),
        EC2SecurityGroupOwnerId: cdk.stringToCloudFormation(properties.ec2SecurityGroupOwnerId),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupIngressPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cidrip', 'CIDRIP', properties.CIDRIP != null ? cfn_parse.FromCloudFormation.getString(properties.CIDRIP) : undefined);
    ret.addPropertyResult('ec2SecurityGroupId', 'EC2SecurityGroupId', properties.EC2SecurityGroupId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupId) : undefined);
    ret.addPropertyResult('ec2SecurityGroupName', 'EC2SecurityGroupName', properties.EC2SecurityGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupName) : undefined);
    ret.addPropertyResult('ec2SecurityGroupOwnerId', 'EC2SecurityGroupOwnerId', properties.EC2SecurityGroupOwnerId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupOwnerId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBSecurityGroupIngressProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupIngressProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroupIngressPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrip', cdk.validateString)(properties.cidrip));
    errors.collect(cdk.propertyValidator('dbSecurityGroupName', cdk.requiredValidator)(properties.dbSecurityGroupName));
    errors.collect(cdk.propertyValidator('dbSecurityGroupName', cdk.validateString)(properties.dbSecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupId', cdk.validateString)(properties.ec2SecurityGroupId));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupName', cdk.validateString)(properties.ec2SecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupOwnerId', cdk.validateString)(properties.ec2SecurityGroupOwnerId));
    return errors.wrap('supplied properties not correct for "CfnDBSecurityGroupIngressProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroupIngress` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupIngressProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroupIngress` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupIngressPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroupIngressPropsValidator(properties).assertSuccess();
    return {
        DBSecurityGroupName: cdk.stringToCloudFormation(properties.dbSecurityGroupName),
        CIDRIP: cdk.stringToCloudFormation(properties.cidrip),
        EC2SecurityGroupId: cdk.stringToCloudFormation(properties.ec2SecurityGroupId),
        EC2SecurityGroupName: cdk.stringToCloudFormation(properties.ec2SecurityGroupName),
        EC2SecurityGroupOwnerId: cdk.stringToCloudFormation(properties.ec2SecurityGroupOwnerId),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupIngressPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupName', 'DBSecurityGroupName', cfn_parse.FromCloudFormation.getString(properties.DBSecurityGroupName));
    ret.addPropertyResult('cidrip', 'CIDRIP', properties.CIDRIP != null ? cfn_parse.FromCloudFormation.getString(properties.CIDRIP) : undefined);
    ret.addPropertyResult('ec2SecurityGroupId', 'EC2SecurityGroupId', properties.EC2SecurityGroupId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupId) : undefined);
    ret.addPropertyResult('ec2SecurityGroupName', 'EC2SecurityGroupName', properties.EC2SecurityGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupName) : undefined);
    ret.addPropertyResult('ec2SecurityGroupOwnerId', 'EC2SecurityGroupOwnerId', properties.EC2SecurityGroupOwnerId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupOwnerId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroupIngress`
 *
 * The `AWS::RDS::DBSecurityGroupIngress` resource enables ingress to a DB security group using one of two forms of authorization. First, you can add EC2 or VPC security groups to the DB security group if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the Internet.
 *
 * This type supports updates. For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * For details about the settings for DB security group ingress, see [AuthorizeDBSecurityGroupIngress](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AuthorizeDBSecurityGroupIngress.html) .
 *
 * > EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see [Migrate from EC2-Classic to a VPC](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html) in the *Amazon EC2 User Guide* , the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare](https://docs.aws.amazon.com/aws/ec2-classic-is-retiring-heres-how-to-prepare/) , and [Moving a DB instance not in a VPC into a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroupIngress
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 */
class CfnDBSecurityGroupIngress extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBSecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBSecurityGroupIngressProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBSecurityGroupIngress);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbSecurityGroupName', this);
        this.dbSecurityGroupName = props.dbSecurityGroupName;
        this.cidrip = props.cidrip;
        this.ec2SecurityGroupId = props.ec2SecurityGroupId;
        this.ec2SecurityGroupName = props.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = props.ec2SecurityGroupOwnerId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSecurityGroupIngressPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSecurityGroupIngress(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSecurityGroupName: this.dbSecurityGroupName,
            cidrip: this.cidrip,
            ec2SecurityGroupId: this.ec2SecurityGroupId,
            ec2SecurityGroupName: this.ec2SecurityGroupName,
            ec2SecurityGroupOwnerId: this.ec2SecurityGroupOwnerId,
        };
    }
    renderProperties(props) {
        return cfnDBSecurityGroupIngressPropsToCloudFormation(props);
    }
}
exports.CfnDBSecurityGroupIngress = CfnDBSecurityGroupIngress;
_j = JSII_RTTI_SYMBOL_1;
CfnDBSecurityGroupIngress[_j] = { fqn: "monocdk.aws_rds.CfnDBSecurityGroupIngress", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroupIngress";
/**
 * Determine whether the given properties match those of a `CfnDBSubnetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSubnetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSubnetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSubnetGroupDescription', cdk.requiredValidator)(properties.dbSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('dbSubnetGroupDescription', cdk.validateString)(properties.dbSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBSubnetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSubnetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSubnetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSubnetGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBSubnetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSubnetGroupPropsValidator(properties).assertSuccess();
    return {
        DBSubnetGroupDescription: cdk.stringToCloudFormation(properties.dbSubnetGroupDescription),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBSubnetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSubnetGroupDescription', 'DBSubnetGroupDescription', cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupDescription));
    ret.addPropertyResult('subnetIds', 'SubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds));
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSubnetGroup`
 *
 * The `AWS::RDS::DBSubnetGroup` resource creates a database subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
 *
 * For more information, see [Working with DB subnet groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBSubnetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnetgroup.html
 */
class CfnDBSubnetGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBSubnetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDBSubnetGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dbSubnetGroupDescription', this);
        cdk.requireProperty(props, 'subnetIds', this);
        this.dbSubnetGroupDescription = props.dbSubnetGroupDescription;
        this.subnetIds = props.subnetIds;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBSubnetGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSubnetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSubnetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSubnetGroupDescription: this.dbSubnetGroupDescription,
            subnetIds: this.subnetIds,
            dbSubnetGroupName: this.dbSubnetGroupName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBSubnetGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBSubnetGroup = CfnDBSubnetGroup;
_k = JSII_RTTI_SYMBOL_1;
CfnDBSubnetGroup[_k] = { fqn: "monocdk.aws_rds.CfnDBSubnetGroup", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSubnetGroup";
/**
 * Determine whether the given properties match those of a `CfnEventSubscriptionProps`
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the result of the validation.
 */
function CfnEventSubscriptionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('eventCategories', cdk.listValidator(cdk.validateString))(properties.eventCategories));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('sourceIds', cdk.listValidator(cdk.validateString))(properties.sourceIds));
    errors.collect(cdk.propertyValidator('sourceType', cdk.validateString)(properties.sourceType));
    errors.collect(cdk.propertyValidator('subscriptionName', cdk.validateString)(properties.subscriptionName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnEventSubscriptionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::EventSubscription` resource
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::EventSubscription` resource.
 */
// @ts-ignore TS6133
function cfnEventSubscriptionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventSubscriptionPropsValidator(properties).assertSuccess();
    return {
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EventCategories: cdk.listMapper(cdk.stringToCloudFormation)(properties.eventCategories),
        SourceIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceIds),
        SourceType: cdk.stringToCloudFormation(properties.sourceType),
        SubscriptionName: cdk.stringToCloudFormation(properties.subscriptionName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnEventSubscriptionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('eventCategories', 'EventCategories', properties.EventCategories != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EventCategories) : undefined);
    ret.addPropertyResult('sourceIds', 'SourceIds', properties.SourceIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SourceIds) : undefined);
    ret.addPropertyResult('sourceType', 'SourceType', properties.SourceType != null ? cfn_parse.FromCloudFormation.getString(properties.SourceType) : undefined);
    ret.addPropertyResult('subscriptionName', 'SubscriptionName', properties.SubscriptionName != null ? cfn_parse.FromCloudFormation.getString(properties.SubscriptionName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::EventSubscription`
 *
 * The `AWS::RDS::EventSubscription` resource allows you to receive notifications for Amazon Relational Database Service events through the Amazon Simple Notification Service (Amazon SNS). For more information, see [Using Amazon RDS Event Notification](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::EventSubscription
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 */
class CfnEventSubscription extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEventSubscription.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnEventSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEventSubscription);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsTopicArn = props.snsTopicArn;
        this.enabled = props.enabled;
        this.eventCategories = props.eventCategories;
        this.sourceIds = props.sourceIds;
        this.sourceType = props.sourceType;
        this.subscriptionName = props.subscriptionName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::EventSubscription", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEventSubscriptionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEventSubscription(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEventSubscription.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsTopicArn: this.snsTopicArn,
            enabled: this.enabled,
            eventCategories: this.eventCategories,
            sourceIds: this.sourceIds,
            sourceType: this.sourceType,
            subscriptionName: this.subscriptionName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnEventSubscriptionPropsToCloudFormation(props);
    }
}
exports.CfnEventSubscription = CfnEventSubscription;
_l = JSII_RTTI_SYMBOL_1;
CfnEventSubscription[_l] = { fqn: "monocdk.aws_rds.CfnEventSubscription", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEventSubscription.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::EventSubscription";
/**
 * Determine whether the given properties match those of a `CfnGlobalClusterProps`
 *
 * @param properties - the TypeScript properties of a `CfnGlobalClusterProps`
 *
 * @returns the result of the validation.
 */
function CfnGlobalClusterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('globalClusterIdentifier', cdk.validateString)(properties.globalClusterIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbClusterIdentifier', cdk.validateString)(properties.sourceDbClusterIdentifier));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    return errors.wrap('supplied properties not correct for "CfnGlobalClusterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::GlobalCluster` resource
 *
 * @param properties - the TypeScript properties of a `CfnGlobalClusterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::GlobalCluster` resource.
 */
// @ts-ignore TS6133
function cfnGlobalClusterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalClusterPropsValidator(properties).assertSuccess();
    return {
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        GlobalClusterIdentifier: cdk.stringToCloudFormation(properties.globalClusterIdentifier),
        SourceDBClusterIdentifier: cdk.stringToCloudFormation(properties.sourceDbClusterIdentifier),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
    };
}
// @ts-ignore TS6133
function CfnGlobalClusterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('globalClusterIdentifier', 'GlobalClusterIdentifier', properties.GlobalClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.GlobalClusterIdentifier) : undefined);
    ret.addPropertyResult('sourceDbClusterIdentifier', 'SourceDBClusterIdentifier', properties.SourceDBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBClusterIdentifier) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::GlobalCluster`
 *
 * The `AWS::RDS::GlobalCluster` resource creates or updates an Amazon Aurora global database spread across multiple AWS Regions.
 *
 * The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
 *
 * You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster to it.
 *
 * For information about Aurora global databases, see [Working with Amazon Aurora Global Databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::GlobalCluster
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html
 */
class CfnGlobalCluster extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::GlobalCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnGlobalClusterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnGlobalCluster);
            }
            throw error;
        }
        this.deletionProtection = props.deletionProtection;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.globalClusterIdentifier = props.globalClusterIdentifier;
        this.sourceDbClusterIdentifier = props.sourceDbClusterIdentifier;
        this.storageEncrypted = props.storageEncrypted;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGlobalClusterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnGlobalCluster(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            deletionProtection: this.deletionProtection,
            engine: this.engine,
            engineVersion: this.engineVersion,
            globalClusterIdentifier: this.globalClusterIdentifier,
            sourceDbClusterIdentifier: this.sourceDbClusterIdentifier,
            storageEncrypted: this.storageEncrypted,
        };
    }
    renderProperties(props) {
        return cfnGlobalClusterPropsToCloudFormation(props);
    }
}
exports.CfnGlobalCluster = CfnGlobalCluster;
_m = JSII_RTTI_SYMBOL_1;
CfnGlobalCluster[_m] = { fqn: "monocdk.aws_rds.CfnGlobalCluster", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::GlobalCluster";
/**
 * Determine whether the given properties match those of a `CfnOptionGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnOptionGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('engineName', cdk.requiredValidator)(properties.engineName));
    errors.collect(cdk.propertyValidator('engineName', cdk.validateString)(properties.engineName));
    errors.collect(cdk.propertyValidator('majorEngineVersion', cdk.requiredValidator)(properties.majorEngineVersion));
    errors.collect(cdk.propertyValidator('majorEngineVersion', cdk.validateString)(properties.majorEngineVersion));
    errors.collect(cdk.propertyValidator('optionConfigurations', cdk.listValidator(CfnOptionGroup_OptionConfigurationPropertyValidator))(properties.optionConfigurations));
    errors.collect(cdk.propertyValidator('optionGroupDescription', cdk.requiredValidator)(properties.optionGroupDescription));
    errors.collect(cdk.propertyValidator('optionGroupDescription', cdk.validateString)(properties.optionGroupDescription));
    errors.collect(cdk.propertyValidator('optionGroupName', cdk.validateString)(properties.optionGroupName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnOptionGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnOptionGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroupPropsValidator(properties).assertSuccess();
    return {
        EngineName: cdk.stringToCloudFormation(properties.engineName),
        MajorEngineVersion: cdk.stringToCloudFormation(properties.majorEngineVersion),
        OptionGroupDescription: cdk.stringToCloudFormation(properties.optionGroupDescription),
        OptionConfigurations: cdk.listMapper(cfnOptionGroupOptionConfigurationPropertyToCloudFormation)(properties.optionConfigurations),
        OptionGroupName: cdk.stringToCloudFormation(properties.optionGroupName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('engineName', 'EngineName', cfn_parse.FromCloudFormation.getString(properties.EngineName));
    ret.addPropertyResult('majorEngineVersion', 'MajorEngineVersion', cfn_parse.FromCloudFormation.getString(properties.MajorEngineVersion));
    ret.addPropertyResult('optionGroupDescription', 'OptionGroupDescription', cfn_parse.FromCloudFormation.getString(properties.OptionGroupDescription));
    ret.addPropertyResult('optionConfigurations', 'OptionConfigurations', properties.OptionConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnOptionGroupOptionConfigurationPropertyFromCloudFormation)(properties.OptionConfigurations) : undefined);
    ret.addPropertyResult('optionGroupName', 'OptionGroupName', properties.OptionGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.OptionGroupName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`
 *
 * The `AWS::RDS::OptionGroup` resource creates or updates an option group, to enable and configure features that are specific to a particular DB engine.
 *
 * @cloudformationResource AWS::RDS::OptionGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
class CfnOptionGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::OptionGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnOptionGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rds_CfnOptionGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnOptionGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'engineName', this);
        cdk.requireProperty(props, 'majorEngineVersion', this);
        cdk.requireProperty(props, 'optionGroupDescription', this);
        this.engineName = props.engineName;
        this.majorEngineVersion = props.majorEngineVersion;
        this.optionGroupDescription = props.optionGroupDescription;
        this.optionConfigurations = props.optionConfigurations;
        this.optionGroupName = props.optionGroupName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::OptionGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnOptionGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnOptionGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnOptionGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            engineName: this.engineName,
            majorEngineVersion: this.majorEngineVersion,
            optionGroupDescription: this.optionGroupDescription,
            optionConfigurations: this.optionConfigurations,
            optionGroupName: this.optionGroupName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnOptionGroupPropsToCloudFormation(props);
    }
}
exports.CfnOptionGroup = CfnOptionGroup;
_o = JSII_RTTI_SYMBOL_1;
CfnOptionGroup[_o] = { fqn: "monocdk.aws_rds.CfnOptionGroup", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnOptionGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::OptionGroup";
/**
 * Determine whether the given properties match those of a `OptionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OptionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroup_OptionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSecurityGroupMemberships', cdk.listValidator(cdk.validateString))(properties.dbSecurityGroupMemberships));
    errors.collect(cdk.propertyValidator('optionName', cdk.requiredValidator)(properties.optionName));
    errors.collect(cdk.propertyValidator('optionName', cdk.validateString)(properties.optionName));
    errors.collect(cdk.propertyValidator('optionSettings', cdk.listValidator(CfnOptionGroup_OptionSettingPropertyValidator))(properties.optionSettings));
    errors.collect(cdk.propertyValidator('optionVersion', cdk.validateString)(properties.optionVersion));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupMemberships', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupMemberships));
    return errors.wrap('supplied properties not correct for "OptionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OptionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupOptionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroup_OptionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DBSecurityGroupMemberships: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbSecurityGroupMemberships),
        OptionName: cdk.stringToCloudFormation(properties.optionName),
        OptionSettings: cdk.listMapper(cfnOptionGroupOptionSettingPropertyToCloudFormation)(properties.optionSettings),
        OptionVersion: cdk.stringToCloudFormation(properties.optionVersion),
        Port: cdk.numberToCloudFormation(properties.port),
        VpcSecurityGroupMemberships: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupMemberships),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupOptionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupMemberships', 'DBSecurityGroupMemberships', properties.DBSecurityGroupMemberships != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBSecurityGroupMemberships) : undefined);
    ret.addPropertyResult('optionName', 'OptionName', cfn_parse.FromCloudFormation.getString(properties.OptionName));
    ret.addPropertyResult('optionSettings', 'OptionSettings', properties.OptionSettings != null ? cfn_parse.FromCloudFormation.getArray(CfnOptionGroupOptionSettingPropertyFromCloudFormation)(properties.OptionSettings) : undefined);
    ret.addPropertyResult('optionVersion', 'OptionVersion', properties.OptionVersion != null ? cfn_parse.FromCloudFormation.getString(properties.OptionVersion) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('vpcSecurityGroupMemberships', 'VpcSecurityGroupMemberships', properties.VpcSecurityGroupMemberships != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupMemberships) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OptionSettingProperty`
 *
 * @param properties - the TypeScript properties of a `OptionSettingProperty`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroup_OptionSettingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "OptionSettingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionSetting` resource
 *
 * @param properties - the TypeScript properties of a `OptionSettingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionSetting` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupOptionSettingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroup_OptionSettingPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupOptionSettingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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