"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined through the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigateway_IDomainName(domainName);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiGatewayDomain);
            }
            throw error;
        }
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayDomain[_a] = { fqn: "monocdk.aws_route53_targets.ApiGatewayDomain", version: "1.191.0" };
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigateway_RestApiBase(api);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiGateway);
            }
            throw error;
        }
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
_b = JSII_RTTI_SYMBOL_1;
ApiGateway[_b] = { fqn: "monocdk.aws_route53_targets.ApiGateway", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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