"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAcceleratorTarget = exports.GlobalAcceleratorDomainTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a Global Accelerator domain name as an alias record target.
 */
class GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator domain name.
     */
    constructor(acceleratorDomainName) {
        this.acceleratorDomainName = acceleratorDomainName;
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            hostedZoneId: GlobalAcceleratorTarget.GLOBAL_ACCELERATOR_ZONE_ID,
            dnsName: this.acceleratorDomainName,
        };
    }
}
exports.GlobalAcceleratorDomainTarget = GlobalAcceleratorDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorDomainTarget[_a] = { fqn: "monocdk.aws_route53_targets.GlobalAcceleratorDomainTarget", version: "1.191.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 * Ref: https://docs.aws.amazon.com/general/latest/gr/global_accelerator.html
 */
GlobalAcceleratorDomainTarget.GLOBAL_ACCELERATOR_ZONE_ID = 'Z2BJ6XQ5FK7U4H';
/**
 * Use a Global Accelerator instance domain name as an alias record target.
 */
class GlobalAcceleratorTarget extends GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator instance.
     */
    constructor(accelerator) {
        super(accelerator.dnsName);
        try {
            jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_IAccelerator(accelerator);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GlobalAcceleratorTarget);
            }
            throw error;
        }
    }
}
exports.GlobalAcceleratorTarget = GlobalAcceleratorTarget;
_b = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorTarget[_b] = { fqn: "monocdk.aws_route53_targets.GlobalAcceleratorTarget", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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