"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAppMonitor = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-01-31T17:42:59.435Z","fingerprint":"V8kHvlr7kQq9XDKwrKq5eXF7RPW8jsN/TnP++r4xUYM="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAppMonitorProps`
 *
 * @param properties - the TypeScript properties of a `CfnAppMonitorProps`
 *
 * @returns the result of the validation.
 */
function CfnAppMonitorPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appMonitorConfiguration', CfnAppMonitor_AppMonitorConfigurationPropertyValidator)(properties.appMonitorConfiguration));
    errors.collect(cdk.propertyValidator('customEvents', CfnAppMonitor_CustomEventsPropertyValidator)(properties.customEvents));
    errors.collect(cdk.propertyValidator('cwLogEnabled', cdk.validateBoolean)(properties.cwLogEnabled));
    errors.collect(cdk.propertyValidator('domain', cdk.requiredValidator)(properties.domain));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnAppMonitorProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RUM::AppMonitor` resource
 *
 * @param properties - the TypeScript properties of a `CfnAppMonitorProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RUM::AppMonitor` resource.
 */
// @ts-ignore TS6133
function cfnAppMonitorPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppMonitorPropsValidator(properties).assertSuccess();
    return {
        Domain: cdk.stringToCloudFormation(properties.domain),
        Name: cdk.stringToCloudFormation(properties.name),
        AppMonitorConfiguration: cfnAppMonitorAppMonitorConfigurationPropertyToCloudFormation(properties.appMonitorConfiguration),
        CustomEvents: cfnAppMonitorCustomEventsPropertyToCloudFormation(properties.customEvents),
        CwLogEnabled: cdk.booleanToCloudFormation(properties.cwLogEnabled),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAppMonitorPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('domain', 'Domain', cfn_parse.FromCloudFormation.getString(properties.Domain));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('appMonitorConfiguration', 'AppMonitorConfiguration', properties.AppMonitorConfiguration != null ? CfnAppMonitorAppMonitorConfigurationPropertyFromCloudFormation(properties.AppMonitorConfiguration) : undefined);
    ret.addPropertyResult('customEvents', 'CustomEvents', properties.CustomEvents != null ? CfnAppMonitorCustomEventsPropertyFromCloudFormation(properties.CustomEvents) : undefined);
    ret.addPropertyResult('cwLogEnabled', 'CwLogEnabled', properties.CwLogEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CwLogEnabled) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RUM::AppMonitor`
 *
 * Creates a CloudWatch RUM app monitor, which you can use to collect telemetry data from your application and send it to CloudWatch RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
 *
 * After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see [How do I find a code snippet that I've already generated?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
 *
 * @cloudformationResource AWS::RUM::AppMonitor
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html
 */
class CfnAppMonitor extends cdk.CfnResource {
    /**
     * Create a new `AWS::RUM::AppMonitor`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAppMonitor.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_rum_CfnAppMonitorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAppMonitor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'domain', this);
        cdk.requireProperty(props, 'name', this);
        this.domain = props.domain;
        this.name = props.name;
        this.appMonitorConfiguration = props.appMonitorConfiguration;
        this.customEvents = props.customEvents;
        this.cwLogEnabled = props.cwLogEnabled;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RUM::AppMonitor", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAppMonitorPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAppMonitor(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAppMonitor.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            domain: this.domain,
            name: this.name,
            appMonitorConfiguration: this.appMonitorConfiguration,
            customEvents: this.customEvents,
            cwLogEnabled: this.cwLogEnabled,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAppMonitorPropsToCloudFormation(props);
    }
}
exports.CfnAppMonitor = CfnAppMonitor;
_a = JSII_RTTI_SYMBOL_1;
CfnAppMonitor[_a] = { fqn: "monocdk.aws_rum.CfnAppMonitor", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAppMonitor.CFN_RESOURCE_TYPE_NAME = "AWS::RUM::AppMonitor";
/**
 * Determine whether the given properties match those of a `AppMonitorConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AppMonitorConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppMonitor_AppMonitorConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowCookies', cdk.validateBoolean)(properties.allowCookies));
    errors.collect(cdk.propertyValidator('enableXRay', cdk.validateBoolean)(properties.enableXRay));
    errors.collect(cdk.propertyValidator('excludedPages', cdk.listValidator(cdk.validateString))(properties.excludedPages));
    errors.collect(cdk.propertyValidator('favoritePages', cdk.listValidator(cdk.validateString))(properties.favoritePages));
    errors.collect(cdk.propertyValidator('guestRoleArn', cdk.validateString)(properties.guestRoleArn));
    errors.collect(cdk.propertyValidator('identityPoolId', cdk.validateString)(properties.identityPoolId));
    errors.collect(cdk.propertyValidator('includedPages', cdk.listValidator(cdk.validateString))(properties.includedPages));
    errors.collect(cdk.propertyValidator('metricDestinations', cdk.listValidator(CfnAppMonitor_MetricDestinationPropertyValidator))(properties.metricDestinations));
    errors.collect(cdk.propertyValidator('sessionSampleRate', cdk.validateNumber)(properties.sessionSampleRate));
    errors.collect(cdk.propertyValidator('telemetries', cdk.listValidator(cdk.validateString))(properties.telemetries));
    return errors.wrap('supplied properties not correct for "AppMonitorConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.AppMonitorConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AppMonitorConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.AppMonitorConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAppMonitorAppMonitorConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppMonitor_AppMonitorConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AllowCookies: cdk.booleanToCloudFormation(properties.allowCookies),
        EnableXRay: cdk.booleanToCloudFormation(properties.enableXRay),
        ExcludedPages: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludedPages),
        FavoritePages: cdk.listMapper(cdk.stringToCloudFormation)(properties.favoritePages),
        GuestRoleArn: cdk.stringToCloudFormation(properties.guestRoleArn),
        IdentityPoolId: cdk.stringToCloudFormation(properties.identityPoolId),
        IncludedPages: cdk.listMapper(cdk.stringToCloudFormation)(properties.includedPages),
        MetricDestinations: cdk.listMapper(cfnAppMonitorMetricDestinationPropertyToCloudFormation)(properties.metricDestinations),
        SessionSampleRate: cdk.numberToCloudFormation(properties.sessionSampleRate),
        Telemetries: cdk.listMapper(cdk.stringToCloudFormation)(properties.telemetries),
    };
}
// @ts-ignore TS6133
function CfnAppMonitorAppMonitorConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowCookies', 'AllowCookies', properties.AllowCookies != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowCookies) : undefined);
    ret.addPropertyResult('enableXRay', 'EnableXRay', properties.EnableXRay != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableXRay) : undefined);
    ret.addPropertyResult('excludedPages', 'ExcludedPages', properties.ExcludedPages != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludedPages) : undefined);
    ret.addPropertyResult('favoritePages', 'FavoritePages', properties.FavoritePages != null ? cfn_parse.FromCloudFormation.getStringArray(properties.FavoritePages) : undefined);
    ret.addPropertyResult('guestRoleArn', 'GuestRoleArn', properties.GuestRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.GuestRoleArn) : undefined);
    ret.addPropertyResult('identityPoolId', 'IdentityPoolId', properties.IdentityPoolId != null ? cfn_parse.FromCloudFormation.getString(properties.IdentityPoolId) : undefined);
    ret.addPropertyResult('includedPages', 'IncludedPages', properties.IncludedPages != null ? cfn_parse.FromCloudFormation.getStringArray(properties.IncludedPages) : undefined);
    ret.addPropertyResult('metricDestinations', 'MetricDestinations', properties.MetricDestinations != null ? cfn_parse.FromCloudFormation.getArray(CfnAppMonitorMetricDestinationPropertyFromCloudFormation)(properties.MetricDestinations) : undefined);
    ret.addPropertyResult('sessionSampleRate', 'SessionSampleRate', properties.SessionSampleRate != null ? cfn_parse.FromCloudFormation.getNumber(properties.SessionSampleRate) : undefined);
    ret.addPropertyResult('telemetries', 'Telemetries', properties.Telemetries != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Telemetries) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomEventsProperty`
 *
 * @param properties - the TypeScript properties of a `CustomEventsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppMonitor_CustomEventsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "CustomEventsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.CustomEvents` resource
 *
 * @param properties - the TypeScript properties of a `CustomEventsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.CustomEvents` resource.
 */
// @ts-ignore TS6133
function cfnAppMonitorCustomEventsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppMonitor_CustomEventsPropertyValidator(properties).assertSuccess();
    return {
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnAppMonitorCustomEventsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('status', 'Status', properties.Status != null ? cfn_parse.FromCloudFormation.getString(properties.Status) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `MetricDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppMonitor_MetricDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dimensionKeys', cdk.hashValidator(cdk.validateString))(properties.dimensionKeys));
    errors.collect(cdk.propertyValidator('eventPattern', cdk.validateString)(properties.eventPattern));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('unitLabel', cdk.validateString)(properties.unitLabel));
    errors.collect(cdk.propertyValidator('valueKey', cdk.validateString)(properties.valueKey));
    return errors.wrap('supplied properties not correct for "MetricDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.MetricDefinition` resource
 *
 * @param properties - the TypeScript properties of a `MetricDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.MetricDefinition` resource.
 */
// @ts-ignore TS6133
function cfnAppMonitorMetricDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppMonitor_MetricDefinitionPropertyValidator(properties).assertSuccess();
    return {
        DimensionKeys: cdk.hashMapper(cdk.stringToCloudFormation)(properties.dimensionKeys),
        EventPattern: cdk.stringToCloudFormation(properties.eventPattern),
        Name: cdk.stringToCloudFormation(properties.name),
        UnitLabel: cdk.stringToCloudFormation(properties.unitLabel),
        ValueKey: cdk.stringToCloudFormation(properties.valueKey),
    };
}
// @ts-ignore TS6133
function CfnAppMonitorMetricDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dimensionKeys', 'DimensionKeys', properties.DimensionKeys != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.DimensionKeys) : undefined);
    ret.addPropertyResult('eventPattern', 'EventPattern', properties.EventPattern != null ? cfn_parse.FromCloudFormation.getString(properties.EventPattern) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('unitLabel', 'UnitLabel', properties.UnitLabel != null ? cfn_parse.FromCloudFormation.getString(properties.UnitLabel) : undefined);
    ret.addPropertyResult('valueKey', 'ValueKey', properties.ValueKey != null ? cfn_parse.FromCloudFormation.getString(properties.ValueKey) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `MetricDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppMonitor_MetricDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('destination', cdk.requiredValidator)(properties.destination));
    errors.collect(cdk.propertyValidator('destination', cdk.validateString)(properties.destination));
    errors.collect(cdk.propertyValidator('destinationArn', cdk.validateString)(properties.destinationArn));
    errors.collect(cdk.propertyValidator('iamRoleArn', cdk.validateString)(properties.iamRoleArn));
    errors.collect(cdk.propertyValidator('metricDefinitions', cdk.listValidator(CfnAppMonitor_MetricDefinitionPropertyValidator))(properties.metricDefinitions));
    return errors.wrap('supplied properties not correct for "MetricDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.MetricDestination` resource
 *
 * @param properties - the TypeScript properties of a `MetricDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.MetricDestination` resource.
 */
// @ts-ignore TS6133
function cfnAppMonitorMetricDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppMonitor_MetricDestinationPropertyValidator(properties).assertSuccess();
    return {
        Destination: cdk.stringToCloudFormation(properties.destination),
        DestinationArn: cdk.stringToCloudFormation(properties.destinationArn),
        IamRoleArn: cdk.stringToCloudFormation(properties.iamRoleArn),
        MetricDefinitions: cdk.listMapper(cfnAppMonitorMetricDefinitionPropertyToCloudFormation)(properties.metricDefinitions),
    };
}
// @ts-ignore TS6133
function CfnAppMonitorMetricDestinationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('destination', 'Destination', cfn_parse.FromCloudFormation.getString(properties.Destination));
    ret.addPropertyResult('destinationArn', 'DestinationArn', properties.DestinationArn != null ? cfn_parse.FromCloudFormation.getString(properties.DestinationArn) : undefined);
    ret.addPropertyResult('iamRoleArn', 'IamRoleArn', properties.IamRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.IamRoleArn) : undefined);
    ret.addPropertyResult('metricDefinitions', 'MetricDefinitions', properties.MetricDefinitions != null ? cfn_parse.FromCloudFormation.getArray(CfnAppMonitorMetricDefinitionPropertyFromCloudFormation)(properties.MetricDefinitions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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