"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam");
const cdk = require("../../core");
const secretsmanager = require("../lib");
class SecretsManagerStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const role = new iam.Role(this, 'TestRole', { assumedBy: new iam.AccountRootPrincipal() });
        /// !show
        // Default secret
        const secret = new secretsmanager.Secret(this, 'Secret');
        secret.grantRead(role);
        const user = new iam.User(this, 'User', {
            password: secret.secretValue,
        });
        // Templated secret
        const templatedSecret = new secretsmanager.Secret(this, 'TemplatedSecret', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({ username: 'user' }),
                generateStringKey: 'password',
            },
        });
        new iam.User(this, 'OtherUser', {
            // 'userName' is not actually a secret, so it's okay to use `unsafeUnwrap` to convert
            // the `SecretValue` into a 'string'.
            userName: templatedSecret.secretValueFromJson('username').unsafeUnwrap(),
            password: templatedSecret.secretValueFromJson('password'),
        });
        // Secret with predefined value
        const accessKey = new iam.AccessKey(this, 'AccessKey', { user });
        new secretsmanager.Secret(this, 'PredefinedSecret', {
            secretStringValue: accessKey.secretAccessKey,
        });
    }
}
const app = new cdk.App();
new SecretsManagerStack(app, 'Integ-SecretsManager-Secret');
app.synth();
//# sourceMappingURL=data:application/json;base64,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