"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagOptions = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const util_1 = require("./private/util");
const validation_1 = require("./private/validation");
const servicecatalog_generated_1 = require("./servicecatalog.generated");
/**
 * Defines a set of TagOptions, which are a list of key-value pairs managed in AWS Service Catalog.
 * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
 * See https://docs.aws.amazon.com/servicecatalog/latest/adminguide/tagoptions.html
 *
 * @resource AWS::ServiceCatalog::TagOption
 */
class TagOptions extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_servicecatalog_TagOptionsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TagOptions);
            }
            throw error;
        }
        this._cfnTagOptions = this.createUnderlyingTagOptions(props.allowedValuesForTags);
    }
    createUnderlyingTagOptions(allowedValuesForTags) {
        if (Object.keys(allowedValuesForTags).length === 0) {
            throw new Error(`No tag option keys or values were provided for resource ${this.node.path}`);
        }
        var tagOptions = [];
        for (const [tagKey, tagValues] of Object.entries(allowedValuesForTags)) {
            validation_1.InputValidator.validateLength(this.node.addr, 'TagOption key', 1, 128, tagKey);
            const uniqueTagValues = new Set(tagValues);
            if (uniqueTagValues.size === 0) {
                throw new Error(`No tag option values were provided for tag option key ${tagKey} for resource ${this.node.path}`);
            }
            uniqueTagValues.forEach((tagValue) => {
                validation_1.InputValidator.validateLength(this.node.addr, 'TagOption value', 1, 256, tagValue);
                const tagOptionIdentifier = util_1.hashValues(tagKey, tagValue);
                const tagOption = new servicecatalog_generated_1.CfnTagOption(this, tagOptionIdentifier, {
                    key: tagKey,
                    value: tagValue,
                    active: true,
                });
                tagOptions.push(tagOption);
            });
        }
        return tagOptions;
    }
}
exports.TagOptions = TagOptions;
_a = JSII_RTTI_SYMBOL_1;
TagOptions[_a] = { fqn: "monocdk.aws_servicecatalog.TagOptions", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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