"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../../aws-ec2");
const elbv2 = require("../../aws-elasticloadbalancingv2");
const cdk = require("../../core");
const servicediscovery = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-servicediscovery-integ');
const vpc = new ec2.Vpc(stack, 'Vpc', { maxAzs: 2 });
const namespace = new servicediscovery.PrivateDnsNamespace(stack, 'Namespace', {
    name: 'boobar.com',
    vpc,
});
const service = namespace.createService('Service', {
    dnsRecordType: servicediscovery.DnsRecordType.A_AAAA,
    dnsTtl: cdk.Duration.seconds(30),
    loadBalancer: true,
});
const loadbalancer = new elbv2.ApplicationLoadBalancer(stack, 'LB', { vpc, internetFacing: true });
service.registerLoadBalancer('Loadbalancer', loadbalancer);
app.synth();
//# sourceMappingURL=data:application/json;base64,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