"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("../../core");
const ssm = require("../lib");
class CreatingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        new ssm.StringParameter(this, 'String', {
            parameterName: '/My/Public/Parameter',
            stringValue: 'abcdef',
        });
    }
}
class UsingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        // Parameter that contains version number, will be used to pass
        // version value from token.
        const parameterVersion = new cdk.CfnParameter(this, 'MyParameterVersion', {
            type: 'Number',
            default: 1,
        }).valueAsNumber;
        /// !show
        // Retrieve the latest value of the non-secret parameter
        // with name "/My/String/Parameter".
        const stringValue = ssm.StringParameter.fromStringParameterAttributes(this, 'MyValue', {
            parameterName: '/My/Public/Parameter',
        }).stringValue;
        const stringValueVersionFromToken = ssm.StringParameter.fromStringParameterAttributes(this, 'MyValueVersionFromToken', {
            parameterName: '/My/Public/Parameter',
            // parameter version from token
            version: parameterVersion,
        }).stringValue;
        // Retrieve a specific version of the secret (SecureString) parameter.
        // 'version' is always required.
        const secretValue = ssm.StringParameter.fromSecureStringParameterAttributes(this, 'MySecureValue', {
            parameterName: '/My/Secret/Parameter',
            version: 5,
        });
        const secretValueVersionFromToken = ssm.StringParameter.fromSecureStringParameterAttributes(this, 'MySecureValueVersionFromToken', {
            parameterName: '/My/Secret/Parameter',
            // parameter version from token
            version: parameterVersion,
        });
        /// !hide
        new cdk.CfnResource(this, 'Dummy', { type: 'AWS::SNS::Topic' });
        new cdk.CfnOutput(this, 'TheValue', { value: stringValue });
        new cdk.CfnOutput(this, 'TheValueVersionFromToken', { value: stringValueVersionFromToken });
        // Cannot be provisioned so cannot be actually used
        Array.isArray(secretValue);
        Array.isArray(secretValueVersionFromToken);
    }
}
const app = new cdk.App();
const creating = new CreatingStack(app, 'sspms-creating');
const using = new UsingStack(app, 'sspms-using');
using.addDependency(creating);
app.synth();
//# sourceMappingURL=data:application/json;base64,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