"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayRestApiEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core");
const base_1 = require("./base");
/**
 * Call REST API endpoint as a Task
 *
 * Be aware that the header values must be arrays. When passing the Task Token
 * in the headers field `WAIT_FOR_TASK_TOKEN` integration, use
 * `JsonPath.array()` to wrap the token in an array:
 *
 * ```ts
 * import * as apigateway from '@aws-cdk/aws-apigateway';
 * declare const api: apigateway.RestApi;
 *
 * new tasks.CallApiGatewayRestApiEndpoint(this, 'Endpoint', {
 *   api,
 *   stageName: 'Stage',
 *   method: tasks.HttpMethod.PUT,
 *   integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
 *   headers: sfn.TaskInput.fromObject({
 *     TaskToken: sfn.JsonPath.array(sfn.JsonPath.taskToken),
 *   }),
 * });
 * ```
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 */
class CallApiGatewayRestApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_stepfunctions_tasks_CallApiGatewayRestApiEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CallApiGatewayRestApiEndpoint);
            }
            throw error;
        }
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = props.api.arnForExecuteApi(props.method, props.apiPath, props.stageName);
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = cdk.Stack.of(this.props.api);
        return `${this.props.api.restApiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
}
exports.CallApiGatewayRestApiEndpoint = CallApiGatewayRestApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayRestApiEndpoint[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.CallApiGatewayRestApiEndpoint", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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