"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeActivity = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @deprecated use `StepFunctionsInvokeActivity`
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("monocdk.aws_stepfunctions_tasks.InvokeActivity", "use `StepFunctionsInvokeActivity`");
            jsiiDeprecationWarnings.monocdk_aws_stepfunctions_IActivity(activity);
            jsiiDeprecationWarnings.monocdk_aws_stepfunctions_tasks_InvokeActivityProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InvokeActivity);
            }
            throw error;
        }
    }
    bind(_task) {
        try {
            jsiiDeprecationWarnings.print("monocdk.aws_stepfunctions_tasks.InvokeActivity#bind", "use `StepFunctionsInvokeActivity`");
            jsiiDeprecationWarnings.monocdk_aws_stepfunctions_Task(_task);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
exports.InvokeActivity = InvokeActivity;
_a = JSII_RTTI_SYMBOL_1;
InvokeActivity[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.InvokeActivity", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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