"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeFunction = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../../aws-iam");
/**
 * A Step Functions Task to invoke a Lambda function.
 *
 * The Lambda function Arn is defined as Resource in the state machine definition.
 *
 * OUTPUT: the output of this task is the return value of the Lambda Function.
 *
 * @deprecated Use `LambdaInvoke`
 */
class InvokeFunction {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("monocdk.aws_stepfunctions_tasks.InvokeFunction", "Use `LambdaInvoke`");
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(lambdaFunction);
            jsiiDeprecationWarnings.monocdk_aws_stepfunctions_tasks_InvokeFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InvokeFunction);
            }
            throw error;
        }
    }
    bind(_task) {
        try {
            jsiiDeprecationWarnings.print("monocdk.aws_stepfunctions_tasks.InvokeFunction#bind", "Use `LambdaInvoke`");
            jsiiDeprecationWarnings.monocdk_aws_stepfunctions_Task(_task);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            resourceArn: this.lambdaFunction.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: this.lambdaFunction.resourceArnsForGrantInvoke,
                    actions: ['lambda:InvokeFunction'],
                })],
            metricPrefixSingular: 'LambdaFunction',
            metricPrefixPlural: 'LambdaFunctions',
            metricDimensions: { LambdaFunctionArn: this.lambdaFunction.functionArn },
            parameters: this.props.payload,
        };
    }
}
exports.InvokeFunction = InvokeFunction;
_a = JSII_RTTI_SYMBOL_1;
InvokeFunction[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.InvokeFunction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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