"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("../../../aws-lambda");
const core_1 = require("../../../core");
const consts = require("./runtime/consts");
const util_1 = require("./util");
const waiter_state_machine_1 = require("./waiter-state-machine");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main",
// eslint-disable-next-line
const core_2 = require("../../../core");
const RUNTIME_HANDLER_PATH = path.join(__dirname, 'runtime');
const FRAMEWORK_HANDLER_TIMEOUT = core_1.Duration.minutes(15); // keep it simple for now
/**
 * Defines an AWS CloudFormation custom resource provider.
 */
class Provider extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_custom_resources_ProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Provider);
            }
            throw error;
        }
        if (!props.isCompleteHandler && (props.queryInterval || props.totalTimeout)) {
            throw new Error('"queryInterval" and "totalTimeout" can only be configured if "isCompleteHandler" is specified. '
                + 'Otherwise, they have no meaning');
        }
        this.onEventHandler = props.onEventHandler;
        this.isCompleteHandler = props.isCompleteHandler;
        this.logRetention = props.logRetention;
        this.vpc = props.vpc;
        this.vpcSubnets = props.vpcSubnets;
        this.securityGroups = props.securityGroups;
        this.role = props.role;
        const onEventFunction = this.createFunction(consts.FRAMEWORK_ON_EVENT_HANDLER_NAME, props.providerFunctionName);
        if (this.isCompleteHandler) {
            const isCompleteFunction = this.createFunction(consts.FRAMEWORK_IS_COMPLETE_HANDLER_NAME);
            const timeoutFunction = this.createFunction(consts.FRAMEWORK_ON_TIMEOUT_HANDLER_NAME);
            const retry = util_1.calculateRetryPolicy(props);
            const waiterStateMachine = new waiter_state_machine_1.WaiterStateMachine(this, 'waiter-state-machine', {
                isCompleteHandler: isCompleteFunction,
                timeoutHandler: timeoutFunction,
                backoffRate: retry.backoffRate,
                interval: retry.interval,
                maxAttempts: retry.maxAttempts,
            });
            // the on-event entrypoint is going to start the execution of the waiter
            onEventFunction.addEnvironment(consts.WAITER_STATE_MACHINE_ARN_ENV, waiterStateMachine.stateMachineArn);
            waiterStateMachine.grantStartExecution(onEventFunction);
        }
        this.entrypoint = onEventFunction;
        this.serviceToken = this.entrypoint.functionArn;
    }
    /**
     * Called by `CustomResource` which uses this provider.
     * @deprecated use `provider.serviceToken` instead
     */
    bind(_scope) {
        try {
            jsiiDeprecationWarnings.print("monocdk.custom_resources.Provider#bind", "use `provider.serviceToken` instead");
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            serviceToken: this.entrypoint.functionArn,
        };
    }
    createFunction(entrypoint, name) {
        const fn = new lambda.Function(this, `framework-${entrypoint}`, {
            code: lambda.Code.fromAsset(RUNTIME_HANDLER_PATH, {
                exclude: ['*.ts'],
            }),
            description: `AWS CDK resource provider framework - ${entrypoint} (${this.node.path})`.slice(0, 256),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: `framework.${entrypoint}`,
            timeout: FRAMEWORK_HANDLER_TIMEOUT,
            logRetention: this.logRetention,
            vpc: this.vpc,
            vpcSubnets: this.vpcSubnets,
            securityGroups: this.securityGroups,
            role: this.role,
            functionName: name,
        });
        fn.addEnvironment(consts.USER_ON_EVENT_FUNCTION_ARN_ENV, this.onEventHandler.functionArn);
        this.onEventHandler.grantInvoke(fn);
        if (this.isCompleteHandler) {
            fn.addEnvironment(consts.USER_IS_COMPLETE_FUNCTION_ARN_ENV, this.isCompleteHandler.functionArn);
            this.isCompleteHandler.grantInvoke(fn);
        }
        return fn;
    }
}
exports.Provider = Provider;
_a = JSII_RTTI_SYMBOL_1;
Provider[_a] = { fqn: "monocdk.custom_resources.Provider", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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