import { Stack } from '../../../../core';
import { Construct, IConstruct } from 'constructs';
import { ExpectedResult, ActualResult } from '../common';
import { IAwsApiCall, LambdaInvokeFunctionProps } from '../sdk';
import { IDeployAssert } from '../types';
import { Construct as CoreConstruct } from '../../../../core';
/**
 * Options for DeployAssert
 */
export interface DeployAssertProps {
}
/**
 * Construct that allows for registering a list of assertions
 * that should be performed on a construct
 */
export declare class DeployAssert extends CoreConstruct implements IDeployAssert {
    /**
     * Returns whether the construct is a DeployAssert construct
     */
    static isDeployAssert(x: any): x is DeployAssert;
    /**
     * Finds a DeployAssert construct in the given scope
     */
    static of(construct: IConstruct): DeployAssert;
    scope: Stack;
    constructor(scope: Construct);
    awsApiCall(service: string, api: string, parameters?: any): IAwsApiCall;
    invokeFunction(props: LambdaInvokeFunctionProps): IAwsApiCall;
    expect(id: string, expected: ExpectedResult, actual: ActualResult): void;
}
