"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSet = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A set of files traveling through the deployment pipeline
 *
 * Individual steps in the pipeline produce or consume
 * `FileSet`s.
 */
class FileSet {
    constructor(
    /** Human-readable descriptor for this file set (does not need to be unique) */
    id, producer) {
        this.id = id;
        /**
         * The primary output of a file set producer
         *
         * The primary output of a FileSet is itself.
         */
        this.primaryOutput = this;
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_Step(producer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FileSet);
            }
            throw error;
        }
        this._producer = producer;
    }
    /**
     * The Step that produces this FileSet
     */
    get producer() {
        if (!this._producer) {
            throw new Error(`FileSet '${this.id}' doesn\'t have a producer; call 'fileSet.producedBy()'`);
        }
        return this._producer;
    }
    /**
     * Mark the given Step as the producer for this FileSet
     *
     * This method can only be called once.
     */
    producedBy(producer) {
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_Step(producer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.producedBy);
            }
            throw error;
        }
        if (this._producer) {
            throw new Error(`FileSet '${this.id}' already has a producer (${this._producer}) while setting producer: ${producer}`);
        }
        this._producer = producer;
    }
    /**
     * Return a string representation of this FileSet
     */
    toString() {
        return `FileSet(${this.id})`;
    }
}
exports.FileSet = FileSet;
_a = JSII_RTTI_SYMBOL_1;
FileSet[_a] = { fqn: "monocdk.pipelines.FileSet", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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