"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildStep = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../aws-codebuild");
const blueprint_1 = require("../blueprint");
const buildspecs_1 = require("./private/buildspecs");
const outputs_1 = require("./private/outputs");
/**
 * Run a script as a CodeBuild Project
 *
 * The BuildSpec must be available inline--it cannot reference a file
 * on disk. If your current build instructions are in a file like
 * `buildspec.yml` in your repository, extract them to a script
 * (say, `build.sh`) and invoke that script as part of the build:
 *
 * ```ts
 * new pipelines.CodeBuildStep('Synth', {
 *   commands: ['./build.sh'],
 * });
 * ```
 */
class CodeBuildStep extends blueprint_1.ShellStep {
    constructor(id, props) {
        super(id, props);
        this.exportedVariables = new Set();
        this.exportedVarsRendered = false;
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_CodeBuildStepProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeBuildStep);
            }
            throw error;
        }
        this.projectName = props.projectName;
        this.buildEnvironment = props.buildEnvironment;
        this._partialBuildSpec = props.partialBuildSpec;
        this.vpc = props.vpc;
        this.subnetSelection = props.subnetSelection;
        this.role = props.role;
        this.actionRole = props.actionRole;
        this.rolePolicyStatements = props.rolePolicyStatements;
        this.securityGroups = props.securityGroups;
        this.timeout = props.timeout;
    }
    /**
     * CodeBuild Project generated for the pipeline
     *
     * Will only be available after the pipeline has been built.
     */
    get project() {
        if (!this._project) {
            throw new Error('Call pipeline.buildPipeline() before reading this property');
        }
        return this._project;
    }
    /**
     * The CodeBuild Project's principal
     */
    get grantPrincipal() {
        return this.project.grantPrincipal;
    }
    /**
     * Additional configuration that can only be configured via BuildSpec
     *
     * Contains exported variables
     *
     * @default - Contains the exported variables
     */
    get partialBuildSpec() {
        this.exportedVarsRendered = true;
        const varsBuildSpec = this.exportedVariables.size > 0 ? codebuild.BuildSpec.fromObject({
            version: '0.2',
            env: {
                'exported-variables': Array.from(this.exportedVariables),
            },
        }) : undefined;
        return buildspecs_1.mergeBuildSpecs(varsBuildSpec, this._partialBuildSpec);
    }
    /**
     * Reference a CodePipeline variable defined by the CodeBuildStep.
     *
     * The variable must be set in the shell of the CodeBuild step when
     * it finishes its `post_build` phase.
     *
     * @param variableName the name of the variable for reference.
     * @example
     * // Access the output of one CodeBuildStep in another CodeBuildStep
     * declare const pipeline: pipelines.CodePipeline;
     *
     * const step1 = new pipelines.CodeBuildStep('Step1', {
     *   commands: ['export MY_VAR=hello'],
     * });
     *
     * const step2 = new pipelines.CodeBuildStep('Step2', {
     *   env: {
     *     IMPORTED_VAR: step1.exportedVariable('MY_VAR'),
     *   },
     *   commands: ['echo $IMPORTED_VAR'],
     * });
     */
    exportedVariable(variableName) {
        if (this.exportedVarsRendered && !this.exportedVariables.has(variableName)) {
            throw new Error('exportVariable(): Pipeline has already been produced, cannot call this function anymore');
        }
        this.exportedVariables.add(variableName);
        return outputs_1.makeCodePipelineOutput(this, variableName);
    }
    /**
     * Set the internal project value
     *
     * @internal
     */
    _setProject(project) {
        this._project = project;
    }
}
exports.CodeBuildStep = CodeBuildStep;
_a = JSII_RTTI_SYMBOL_1;
CodeBuildStep[_a] = { fqn: "monocdk.pipelines.CodeBuildStep", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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