"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfirmPermissionsBroadening = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cpa = require("../../../aws-codepipeline-actions");
const constructs_1 = require("constructs");
const blueprint_1 = require("../blueprint");
const application_security_check_1 = require("../private/application-security-check");
/**
 * Pause the pipeline if a deployment would add IAM permissions or Security Group rules
 *
 * This step is only supported in CodePipeline pipelines.
 */
class ConfirmPermissionsBroadening extends blueprint_1.Step {
    constructor(id, props) {
        super(id);
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_PermissionsBroadeningCheckProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ConfirmPermissionsBroadening);
            }
            throw error;
        }
    }
    produceAction(stage, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.monocdk_pipelines_ProduceActionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.produceAction);
            }
            throw error;
        }
        const sec = this.getOrCreateSecCheck(options.pipeline);
        this.props.notificationTopic?.grantPublish(sec.cdkDiffProject);
        const variablesNamespace = constructs_1.Node.of(this.props.stage).addr;
        const approveActionName = `${options.actionName}.Confirm`;
        stage.addAction(new cpa.CodeBuildAction({
            runOrder: options.runOrder,
            actionName: `${options.actionName}.Check`,
            input: options.artifacts.toCodePipeline(options.pipeline.cloudAssemblyFileSet),
            project: sec.cdkDiffProject,
            variablesNamespace,
            environmentVariables: {
                STAGE_PATH: { value: constructs_1.Node.of(this.props.stage).path },
                STAGE_NAME: { value: stage.stageName },
                ACTION_NAME: { value: approveActionName },
                ...this.props.notificationTopic ? {
                    NOTIFICATION_ARN: { value: this.props.notificationTopic.topicArn },
                    NOTIFICATION_SUBJECT: { value: `Confirm permission broadening in ${this.props.stage.stageName}` },
                } : {},
            },
        }));
        stage.addAction(new cpa.ManualApprovalAction({
            actionName: approveActionName,
            runOrder: options.runOrder + 1,
            additionalInformation: `#{${variablesNamespace}.MESSAGE}`,
            externalEntityLink: `#{${variablesNamespace}.LINK}`,
        }));
        return { runOrdersConsumed: 2 };
    }
    getOrCreateSecCheck(pipeline) {
        const id = 'PipelinesSecurityCheck';
        const existing = constructs_1.Node.of(pipeline).tryFindChild(id);
        if (existing) {
            if (!(existing instanceof application_security_check_1.ApplicationSecurityCheck)) {
                throw new Error(`Expected '${constructs_1.Node.of(existing).path}' to be 'ApplicationSecurityCheck' but was '${existing}'`);
            }
            return existing;
        }
        return new application_security_check_1.ApplicationSecurityCheck(pipeline, id, {
            codePipeline: pipeline.pipeline,
        });
    }
}
exports.ConfirmPermissionsBroadening = ConfirmPermissionsBroadening;
_a = JSII_RTTI_SYMBOL_1;
ConfirmPermissionsBroadening[_a] = { fqn: "monocdk.pipelines.ConfirmPermissionsBroadening", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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