import { FileSet, StackAsset, StackDeployment, Step } from '../blueprint';
import { PipelineBase } from '../main/pipeline-base';
import { Graph, GraphNode } from './graph';
import { PipelineQueries } from './pipeline-queries';
export interface PipelineGraphProps {
    /**
     * Add a self-mutation step.
     *
     * @default false
     */
    readonly selfMutation?: boolean;
    /**
     * Publishes the template asset to S3.
     *
     * @default false
     */
    readonly publishTemplate?: boolean;
    /**
     * Whether to combine asset publishers for the same type into one step
     *
     * @default false
     */
    readonly singlePublisherPerAssetType?: boolean;
    /**
     * Add a "prepare" step for each stack which can be used to create the change
     * set. If this is disabled, only the "execute" step will be included.
     *
     * @default true
     */
    readonly prepareStep?: boolean;
}
/**
 * Logic to turn the deployment blueprint into a graph
 *
 * This code makes all the decisions on how to lay out the CodePipeline
 */
export declare class PipelineGraph {
    readonly pipeline: PipelineBase;
    /**
     * A Step object that may be used as the producer of FileSets that should not be represented in the graph
     */
    static readonly NO_STEP: Step;
    readonly graph: AGraph;
    readonly cloudAssemblyFileSet: FileSet;
    readonly queries: PipelineQueries;
    private readonly added;
    private readonly assetNodes;
    private readonly assetNodesByType;
    private readonly synthNode?;
    private readonly selfMutateNode?;
    private readonly stackOutputDependencies;
    private readonly publishTemplate;
    private readonly prepareStep;
    private readonly singlePublisher;
    private lastPreparationNode?;
    private _fileAssetCtr;
    private _dockerAssetCtr;
    constructor(pipeline: PipelineBase, props?: PipelineGraphProps);
    isSynthNode(node: AGraphNode): boolean;
    private addBuildStep;
    private addWave;
    private addStage;
    private addChangeSet;
    private addPrePost;
    private topLevelGraph;
    private addAndRecurse;
    private publishAsset;
    /**
     * Simplify the stack name by removing the `Stage-` prefix if it exists.
     */
    private simpleStackName;
}
declare type GraphAnnotation = {
    readonly type: 'group';
} | {
    readonly type: 'stack-group';
    readonly stack: StackDeployment;
} | {
    readonly type: 'publish-assets';
    readonly assets: StackAsset[];
} | {
    readonly type: 'step';
    readonly step: Step;
    isBuildStep?: boolean;
} | {
    readonly type: 'self-update';
} | {
    readonly type: 'prepare';
    readonly stack: StackDeployment;
} | {
    readonly type: 'execute';
    readonly stack: StackDeployment;
    readonly captureOutputs: boolean;
};
export declare type AGraphNode = GraphNode<GraphAnnotation>;
export declare type AGraph = Graph<GraphAnnotation>;
export {};
