"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.topoSort = exports.printDependencyMap = void 0;
function printDependencyMap(dependencies) {
    const lines = ['---'];
    for (const [k, vs] of dependencies.entries()) {
        lines.push(`${k} -> ${Array.from(vs)}`);
    }
    // eslint-disable-next-line no-console
    console.log(lines.join('\n'));
}
exports.printDependencyMap = printDependencyMap;
function topoSort(nodes, dependencies) {
    const remaining = new Set(nodes);
    const ret = [];
    while (remaining.size > 0) {
        // All elements with no more deps in the set can be ordered
        const selectable = Array.from(remaining.values()).filter(e => {
            if (!dependencies.has(e)) {
                throw new Error(`No key for ${e}`);
            }
            return dependencies.get(e).size === 0;
        });
        selectable.sort((a, b) => a.id < b.id ? -1 : b.id < a.id ? 1 : 0);
        // If we didn't make any progress, we got stuck
        if (selectable.length === 0) {
            const cycle = findCycle(dependencies);
            throw new Error(`Dependency cycle in graph: ${cycle.map(n => n.id).join(' => ')}`);
        }
        ret.push(selectable);
        for (const selected of selectable) {
            remaining.delete(selected);
            for (const depSet of dependencies.values()) {
                depSet.delete(selected);
            }
        }
    }
    return ret;
}
exports.topoSort = topoSort;
/**
 * Find cycles in a graph
 *
 * Not the fastest, but effective and should be rare
 */
function findCycle(deps) {
    for (const node of deps.keys()) {
        const cycle = recurse(node, [node]);
        if (cycle) {
            return cycle;
        }
    }
    throw new Error('No cycle found. Assertion failure!');
    function recurse(node, path) {
        for (const dep of deps.get(node) ?? []) {
            if (dep === path[0]) {
                return [...path, dep];
            }
            const cycle = recurse(dep, [...path, dep]);
            if (cycle) {
                return cycle;
            }
        }
        return undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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