"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeployCdkStackAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cpactions = require("../../../../aws-codepipeline-actions");
const iam = require("../../../../aws-iam");
const core_1 = require("../../../../core");
const cxapi = require("../../../../cx-api");
const constructs_1 = require("constructs");
const construct_internals_1 = require("../../private/construct-internals");
const fs_1 = require("../../private/fs");
/**
 * Action to deploy a CDK Stack
 *
 * Adds two CodePipeline Actions to the pipeline: one to create a ChangeSet
 * and one to execute it.
 *
 * You do not need to instantiate this action yourself -- it will automatically
 * be added by the pipeline when you add stack artifacts or entire stages.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class DeployCdkStackAction {
    constructor(props) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_pipelines_DeployCdkStackActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DeployCdkStackAction);
            }
            throw error;
        }
        if (props.output && !props.outputFileName) {
            throw new Error('If \'output\' is set, \'outputFileName\' is also required');
        }
        this.stackArtifactId = props.stackArtifactId;
        this.dependencyStackArtifactIds = props.dependencyStackArtifactIds ?? [];
        this.prepareRunOrder = props.prepareRunOrder ?? 1;
        this.executeRunOrder = props.executeRunOrder ?? this.prepareRunOrder + 1;
        this.stackName = props.stackName;
        const baseActionName = props.baseActionName ?? this.stackName;
        const changeSetName = props.changeSetName ?? 'PipelineChange';
        this.prepareChangeSetAction = new cpactions.CloudFormationCreateReplaceChangeSetAction({
            actionName: `${baseActionName}.Prepare`,
            changeSetName,
            runOrder: this.prepareRunOrder,
            stackName: this.stackName,
            templatePath: props.cloudAssemblyInput.atPath(props.templatePath),
            adminPermissions: false,
            role: props.actionRole,
            deploymentRole: props.cloudFormationExecutionRole,
            region: props.region,
            cfnCapabilities: [core_1.CfnCapabilities.NAMED_IAM, core_1.CfnCapabilities.AUTO_EXPAND],
            templateConfiguration: props.templateConfigurationPath ? props.cloudAssemblyInput.atPath(props.templateConfigurationPath) : undefined,
        });
        this.executeChangeSetAction = new cpactions.CloudFormationExecuteChangeSetAction({
            actionName: `${baseActionName}.Deploy`,
            changeSetName,
            runOrder: this.executeRunOrder,
            stackName: this.stackName,
            role: props.actionRole,
            region: props.region,
            outputFileName: props.outputFileName,
            output: props.output,
        });
    }
    /**
     * Construct a DeployCdkStackAction from a Stack artifact
     */
    static fromStackArtifact(scope, artifact, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#fromStackArtifact", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_cx_api_CloudFormationStackArtifact(artifact);
            jsiiDeprecationWarnings.monocdk_pipelines_CdkStackActionFromArtifactOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromStackArtifact);
            }
            throw error;
        }
        if (!artifact.assumeRoleArn) {
            throw new Error(`Stack '${artifact.stackName}' does not have deployment role information; use the 'DefaultStackSynthesizer' synthesizer, or set the '@aws-cdk/core:newStyleStackSynthesis' context key.`);
        }
        const artRegion = artifact.environment.region;
        const region = artRegion === core_1.Stack.of(scope).region || artRegion === cxapi.UNKNOWN_REGION ? undefined : artRegion;
        const artAccount = artifact.environment.account;
        const account = artAccount === core_1.Stack.of(scope).account || artAccount === cxapi.UNKNOWN_ACCOUNT ? undefined : artAccount;
        const actionRole = roleFromPlaceholderArn(scope, region, account, artifact.assumeRoleArn);
        const cloudFormationExecutionRole = roleFromPlaceholderArn(scope, region, account, artifact.cloudFormationExecutionRoleArn);
        // We need the path of the template relative to the root Cloud Assembly
        // It should be easier to get this, but for now it is what it is.
        const appAsmRoot = construct_internals_1.assemblyBuilderOf(construct_internals_1.appOf(scope)).outdir;
        const fullTemplatePath = path.join(artifact.assembly.directory, artifact.templateFile);
        let fullConfigPath;
        if (Object.keys(artifact.tags).length > 0) {
            fullConfigPath = `${fullTemplatePath}.config.json`;
            // Write the template configuration file (for parameters into CreateChangeSet call that
            // cannot be configured any other way). They must come from a file, and there's unfortunately
            // no better hook to write this file (`construct.onSynthesize()` would have been the prime candidate
            // but that is being deprecated--and DeployCdkStackAction isn't even a construct).
            writeTemplateConfiguration(fullConfigPath, {
                Tags: artifact.tags,
            });
        }
        return new DeployCdkStackAction({
            actionRole,
            cloudFormationExecutionRole,
            templatePath: fs_1.toPosixPath(path.relative(appAsmRoot, fullTemplatePath)),
            templateConfigurationPath: fullConfigPath ? fs_1.toPosixPath(path.relative(appAsmRoot, fullConfigPath)) : undefined,
            region,
            stackArtifactId: artifact.id,
            dependencyStackArtifactIds: artifact.dependencies.filter(isStackArtifact).map(s => s.id),
            stackName: options.stackName ?? artifact.stackName,
            ...options,
        });
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        stage.addAction(this.prepareChangeSetAction);
        return this.executeChangeSetAction.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
            jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onStateChange);
            }
            throw error;
        }
        return this.executeChangeSetAction.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.DeployCdkStackAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "actionProperties").get);
            }
            throw error;
        }
        return this.executeChangeSetAction.actionProperties;
    }
}
exports.DeployCdkStackAction = DeployCdkStackAction;
_a = JSII_RTTI_SYMBOL_1;
DeployCdkStackAction[_a] = { fqn: "monocdk.pipelines.DeployCdkStackAction", version: "1.191.0" };
function roleFromPlaceholderArn(scope, region, account, arn) {
    if (!arn) {
        return undefined;
    }
    // Use placeholdered arn as construct ID.
    const id = arn;
    // https://github.com/aws/aws-cdk/issues/7255
    let existingRole = constructs_1.Node.of(scope).tryFindChild(`ImmutableRole${id}`);
    if (existingRole) {
        return existingRole;
    }
    // For when #7255 is fixed.
    existingRole = constructs_1.Node.of(scope).tryFindChild(id);
    if (existingRole) {
        return existingRole;
    }
    const arnToImport = cxapi.EnvironmentPlaceholders.replace(arn, {
        region: region ?? core_1.Aws.REGION,
        accountId: account ?? core_1.Aws.ACCOUNT_ID,
        partition: core_1.Aws.PARTITION,
    });
    return iam.Role.fromRoleArn(scope, id, arnToImport, { mutable: false, addGrantsToResources: true });
}
function isStackArtifact(a) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return a instanceof cxapi.CloudFormationStackArtifact;
    return a.constructor.name === 'CloudFormationStackArtifact';
}
/**
 * Write template configuration to the given file
 */
function writeTemplateConfiguration(filename, config) {
    fs.writeFileSync(filename, JSON.stringify(config, undefined, 2), { encoding: 'utf-8' });
}
//# sourceMappingURL=data:application/json;base64,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