import * as codebuild from '../../../../aws-codebuild';
import * as codepipeline from '../../../../aws-codepipeline';
import * as ec2 from '../../../../aws-ec2';
import * as events from '../../../../aws-events';
import * as iam from '../../../../aws-iam';
import { IDependable } from '../../../../core';
import { Construct } from 'constructs';
import { AssetType } from '../../blueprint/asset-type';
import { Construct as CoreConstruct } from '../../../../core';
/**
 * Props for a PublishAssetsAction
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface PublishAssetsActionProps {
    /**
     * Name of publishing action
     */
    readonly actionName: string;
    /**
     * The CodePipeline artifact that holds the Cloud Assembly.
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * AssetType we're publishing
     */
    readonly assetType: AssetType;
    /**
     * Version of CDK CLI to 'npm install'.
     *
     * @default - Latest version
     */
    readonly cdkCliVersion?: string;
    /**
     * Name of the CodeBuild project
     *
     * @default - Automatically generated
     */
    readonly projectName?: string;
    /**
     * Role to use for CodePipeline and CodeBuild to build and publish the assets.
     *
     * @default - Automatically generated
     */
    readonly role?: iam.IRole;
    /**
     * Any Dependable construct that the CodeBuild project needs to take a dependency on.
     *
     * @default - none
     */
    readonly dependable?: IDependable;
    /**
     * The VPC where to execute the PublishAssetsAction.
     *
     * @default - No VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Custom BuildSpec that is merged with generated one
     *
     * @default - none
     */
    readonly buildSpec?: codebuild.BuildSpec;
    /**
     * Use a file buildspec written to the cloud assembly instead of an inline buildspec.
     * This prevents size limitation errors as inline specs have a max length of 25600 characters
     *
     * @default false
     */
    readonly createBuildspecFile?: boolean;
    /**
     * Additional commands to run before installing cdk-assert
     * Use this to setup proxies or npm mirrors
     *
     * @default -
     */
    readonly preInstallCommands?: string[];
}
/**
 * Action to publish an asset in the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to prepare and publish the asset.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline when you add stacks that use assets.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export declare class PublishAssetsAction extends CoreConstruct implements codepipeline.IAction {
    private readonly props;
    private readonly action;
    private readonly commands;
    private readonly buildSpec;
    constructor(scope: Construct, id: string, props: PublishAssetsActionProps);
    private getBuildSpecFileName;
    private _onSynth;
    /**
     * Add a single publishing command
     *
     * Manifest path should be relative to the root Cloud Assembly.
     */
    addPublishCommand(relativeManifestPath: string, assetSelector: string): void;
    /**
     * Exists to implement IAction
     */
    bind(scope: CoreConstruct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * Exists to implement IAction
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * Exists to implement IAction
     */
    get actionProperties(): codepipeline.ActionProperties;
}
