"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublishAssetsAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const codebuild = require("../../../../aws-codebuild");
const codepipeline_actions = require("../../../../aws-codepipeline-actions");
const core_1 = require("../../../../core");
const asset_type_1 = require("../../blueprint/asset-type");
const fs_1 = require("../../private/fs");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../../core");
/**
 * Action to publish an asset in the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to prepare and publish the asset.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline when you add stacks that use assets.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class PublishAssetsAction extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.commands = new Array();
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_pipelines_PublishAssetsActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PublishAssetsAction);
            }
            throw error;
        }
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const installCommand = `npm install -g cdk-assets${installSuffix}`;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                install: {
                    commands: props.preInstallCommands ? [...props.preInstallCommands, installCommand] : installCommand,
                },
                build: {
                    commands: core_1.Lazy.list({ produce: () => this.commands }),
                },
            },
        });
        this.buildSpec = props.buildSpec ? codebuild.mergeBuildSpecs(props.buildSpec, buildSpec) : buildSpec;
        const project = new codebuild.PipelineProject(this, 'Default', {
            projectName: this.props.projectName,
            environment: {
                buildImage: codebuild.LinuxBuildImage.STANDARD_5_0,
                privileged: (props.assetType === asset_type_1.AssetType.DOCKER_IMAGE) ? true : undefined,
            },
            vpc: props.vpc,
            subnetSelection: props.subnetSelection,
            buildSpec: props.createBuildspecFile ? codebuild.BuildSpec.fromSourceFilename(this.getBuildSpecFileName()) : this.buildSpec,
            role: props.role,
        });
        if (props.dependable) {
            project.node.addDependency(props.dependable);
        }
        this.action = new codepipeline_actions.CodeBuildAction({
            actionName: props.actionName,
            project,
            input: this.props.cloudAssemblyInput,
            role: props.role,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
        core_1.attachCustomSynthesis(this, {
            onSynthesize: this._onSynth.bind(this),
        });
    }
    getBuildSpecFileName() {
        return `buildspec-assets-${this.node.path.replace(new RegExp('/', 'g'), '-')}.yaml`;
    }
    _onSynth(session) {
        if (this.props.createBuildspecFile) {
            const specFile = path.join(session.outdir, this.getBuildSpecFileName());
            fs.writeFileSync(specFile, core_1.Stack.of(this).resolve(this.buildSpec.toBuildSpec()), { encoding: 'utf-8' });
        }
    }
    /**
     * Add a single publishing command
     *
     * Manifest path should be relative to the root Cloud Assembly.
     */
    addPublishCommand(relativeManifestPath, assetSelector) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#addPublishCommand", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPublishCommand);
            }
            throw error;
        }
        const command = `cdk-assets --path "${fs_1.toPosixPath(relativeManifestPath)}" --verbose publish "${assetSelector}"`;
        if (!this.commands.includes(command)) {
            this.commands.push(command);
        }
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return this.action.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
            jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onStateChange);
            }
            throw error;
        }
        return this.action.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.PublishAssetsAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "actionProperties").get);
            }
            throw error;
        }
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
exports.PublishAssetsAction = PublishAssetsAction;
_a = JSII_RTTI_SYMBOL_1;
PublishAssetsAction[_a] = { fqn: "monocdk.pipelines.PublishAssetsAction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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