import * as codebuild from '../../../aws-codebuild';
import * as codepipeline from '../../../aws-codepipeline';
import * as ec2 from '../../../aws-ec2';
import { CfnOutput, Stage } from '../../../core';
import { Construct } from 'constructs';
import { DockerCredential } from '../docker-credentials';
import { ApplicationSecurityCheck } from '../private/application-security-check';
import { AddStageOptions, BaseStageOptions, CdkStage, StackOutput } from './stage';
import { Construct as CoreConstruct } from '../../../core';
/**
 * Properties for a CdkPipeline
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface CdkPipelineProps {
    /**
     * The CodePipeline action used to retrieve the CDK app's source
     *
     * @default - Required unless `codePipeline` is given
     */
    readonly sourceAction?: codepipeline.IAction;
    /**
     * The CodePipeline action build and synthesis step of the CDK app
     *
     * @default - Required unless `codePipeline` or `sourceAction` is given
     */
    readonly synthAction?: codepipeline.IAction;
    /**
     * The artifact you have defined to be the artifact to hold the cloudAssemblyArtifact for the synth action
     */
    readonly cloudAssemblyArtifact: codepipeline.Artifact;
    /**
     * Existing CodePipeline to add deployment stages to
     *
     * Use this if you want more control over the CodePipeline that gets created.
     * You can choose to not pass this value, in which case a new CodePipeline is
     * created with default settings.
     *
     * If you pass an existing CodePipeline, it should have been created
     * with `restartExecutionOnUpdate: true`.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @default - A new CodePipeline is automatically generated
     */
    readonly codePipeline?: codepipeline.Pipeline;
    /**
     * Name of the pipeline
     *
     * Can only be set if `codePipeline` is not set.
     *
     * @default - A name is automatically generated
     */
    readonly pipelineName?: string;
    /**
     * Create KMS keys for cross-account deployments
     *
     * This controls whether the pipeline is enabled for cross-account deployments.
     *
     * Can only be set if `codePipeline` is not set.
     *
     * By default cross-account deployments are enabled, but this feature requires
     * that KMS Customer Master Keys are created which have a cost of $1/month.
     *
     * If you do not need cross-account deployments, you can set this to `false` to
     * not create those keys and save on that cost (the artifact bucket will be
     * encrypted with an AWS-managed key). However, cross-account deployments will
     * no longer be possible.
     *
     * @default true
     */
    readonly crossAccountKeys?: boolean;
    /**
     * Enables KMS key rotation for cross-account keys.
     *
     * Cannot be set if `crossAccountKeys` was set to `false`.
     *
     * Key rotation costs $1/month when enabled.
     *
     * @default - false (key rotation is disabled)
     */
    readonly enableKeyRotation?: boolean;
    /**
     * CDK CLI version to use in pipeline
     *
     * Some Actions in the pipeline will download and run a version of the CDK
     * CLI. Specify the version here.
     *
     * @default - Latest version
     */
    readonly cdkCliVersion?: string;
    /**
     * The VPC where to execute the CdkPipeline actions.
     *
     * @default - No VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Whether the pipeline will update itself
     *
     * This needs to be set to `true` to allow the pipeline to reconfigure
     * itself when assets or stages are being added to it, and `true` is the
     * recommended setting.
     *
     * You can temporarily set this to `false` while you are iterating
     * on the pipeline itself and prefer to deploy changes using `cdk deploy`.
     *
     * @default true
     */
    readonly selfMutating?: boolean;
    /**
     * Custom BuildSpec that is merged with generated one (for self-mutation stage)
     *
     * @default - none
     */
    readonly selfMutationBuildSpec?: codebuild.BuildSpec;
    /**
     * Whether this pipeline creates one asset upload action per asset type or one asset upload per asset
     *
     * @default false
     */
    readonly singlePublisherPerType?: boolean;
    /**
     * Additional commands to run before installing cdk-assets during the asset publishing step
     * Use this to setup proxies or npm mirrors
     *
     * @default -
     */
    readonly assetPreInstallCommands?: string[];
    /**
     * Custom BuildSpec that is merged with generated one (for asset publishing actions)
     *
     * @default - none
     */
    readonly assetBuildSpec?: codebuild.BuildSpec;
    /**
     * Whether the pipeline needs to build Docker images in the UpdatePipeline stage.
     *
     * If the UpdatePipeline stage tries to build a Docker image and this flag is not
     * set to `true`, the build step will run in non-privileged mode and consequently
     * will fail with a message like:
     *
     * > Cannot connect to the Docker daemon at unix:///var/run/docker.sock.
     * > Is the docker daemon running?
     *
     * This flag has an effect only if `selfMutating` is also `true`.
     *
     * @default - false
     */
    readonly supportDockerAssets?: boolean;
    /**
     * A list of credentials used to authenticate to Docker registries.
     *
     * Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
     *
     * @default []
     */
    readonly dockerCredentials?: DockerCredential[];
}
/**
 * A Pipeline to deploy CDK apps
 *
 * Defines an AWS CodePipeline-based Pipeline to deploy CDK applications.
 *
 * Automatically manages the following:
 *
 * - Stack dependency order.
 * - Asset publishing.
 * - Keeping the pipeline up-to-date as the CDK apps change.
 * - Using stack outputs later on in the pipeline.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export declare class CdkPipeline extends CoreConstruct {
    private readonly _pipeline;
    private readonly _assets;
    private readonly _stages;
    private readonly _outputArtifacts;
    private readonly _cloudAssemblyArtifact;
    private readonly _dockerCredentials;
    private _applicationSecurityCheck?;
    private readonly cliVersion?;
    constructor(scope: Construct, id: string, props: CdkPipelineProps);
    /**
     * The underlying CodePipeline object
     *
     * You can use this to add more Stages to the pipeline, or Actions
     * to Stages.
     */
    get codePipeline(): codepipeline.Pipeline;
    /**
     * Access one of the pipeline's stages by stage name
     *
     * You can use this to add more Actions to a stage.
     */
    stage(stageName: string): codepipeline.IStage;
    /**
     * Get a cached version of an Application Security Check, which consists of:
     *  - CodeBuild Project to check for security changes in a stage
     *  - Lambda Function that approves the manual approval if no security changes are detected
     *
     * @internal
     */
    _getApplicationSecurityCheck(): ApplicationSecurityCheck;
    /**
     * Add pipeline stage that will deploy the given application stage
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     */
    addApplicationStage(appStage: Stage, options?: AddStageOptions): CdkStage;
    /**
     * Add a new, empty stage to the pipeline
     *
     * Prefer to use `addApplicationStage` if you are intended to deploy a CDK
     * application, but you can use this method if you want to add other kinds of
     * Actions to a pipeline.
     */
    addStage(stageName: string, options?: BaseStageOptions): CdkStage;
    /**
     * Get the StackOutput object that holds this CfnOutput's value in this pipeline
     *
     * `StackOutput` can be used in validation actions later in the pipeline.
     */
    stackOutput(cfnOutput: CfnOutput): StackOutput;
    /**
     * Validate that we don't have any stacks violating dependency order in the pipeline
     *
     * Our own convenience methods will never generate a pipeline that does that (although
     * this is a nice verification), but a user can also add the stacks by hand.
     */
    protected validate(): string[];
    /**
     * Return all StackDeployActions in an ordered list
     */
    private get stackActions();
    private validateDeployOrder;
    private validateRequestedOutputs;
}
