"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShellScriptAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../../aws-codebuild");
const codepipeline = require("../../../../aws-codepipeline");
const codepipeline_actions = require("../../../../aws-codepipeline-actions");
/**
 * Validate a revision using shell commands
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class ShellScriptAction {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.ShellScriptAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_pipelines_ShellScriptActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ShellScriptAction);
            }
            throw error;
        }
        // A number of actionProperties get read before bind() is even called (so before we
        // have made the Project and can construct the actual CodeBuildAction)
        //
        // - actionName
        // - resource
        // - region
        // - category
        // - role
        // - owner
        this._actionProperties = {
            actionName: props.actionName,
            category: codepipeline.ActionCategory.BUILD,
            provider: 'CodeBuild',
            artifactBounds: { minInputs: 0, maxInputs: 5, minOutputs: 0, maxOutputs: 5 },
            inputs: [],
            outputs: [],
        };
        if (Object.keys(props.useOutputs ?? {}).length + (props.additionalArtifacts ?? []).length === 0) {
            throw new Error('You must supply either \'useOutputs\' or \'additionalArtifacts\', since a CodeBuild Action must always have at least one input artifact.');
        }
    }
    /**
     * The CodeBuild Project's principal
     */
    get grantPrincipal() {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.ShellScriptAction#grantPrincipal", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "grantPrincipal").get);
            }
            throw error;
        }
        return this.project.grantPrincipal;
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.ShellScriptAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "actionProperties").get);
            }
            throw error;
        }
        return this._actionProperties;
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.ShellScriptAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const inputs = new Array();
        inputs.push(...this.props.additionalArtifacts ?? []);
        const envVarCommands = new Array();
        const bashOptions = this.props.bashOptions ?? '-eu';
        if (bashOptions) {
            envVarCommands.push(`set ${bashOptions}`);
        }
        for (const [varName, output] of Object.entries(this.props.useOutputs ?? {})) {
            const outputArtifact = output.artifactFile;
            // Add the artifact to the list of inputs, if it's not in there already. Determine
            // the location where CodeBuild is going to stick it based on whether it's the first (primary)
            // input or an 'extra input', then parse.
            let artifactIndex = inputs.findIndex(a => a.artifactName === outputArtifact.artifact.artifactName);
            if (artifactIndex === -1) {
                artifactIndex = inputs.push(outputArtifact.artifact) - 1;
            }
            const dirEnv = artifactIndex === 0 ? 'CODEBUILD_SRC_DIR' : `CODEBUILD_SRC_DIR_${outputArtifact.artifact.artifactName}`;
            envVarCommands.push(`export ${varName}="$(node -pe 'require(process.env.${dirEnv} + "/${outputArtifact.fileName}")["${output.outputName}"]')"`);
        }
        this._project = new codebuild.PipelineProject(scope, 'Project', {
            environment: this.props.environment || { buildImage: codebuild.LinuxBuildImage.STANDARD_5_0 },
            vpc: this.props.vpc,
            securityGroups: this.props.securityGroups,
            subnetSelection: this.props.subnetSelection,
            buildSpec: codebuild.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    build: {
                        commands: [
                            ...envVarCommands,
                            ...this.props.commands,
                        ],
                    },
                },
            }),
        });
        for (const statement of this.props.rolePolicyStatements ?? []) {
            this._project.addToRolePolicy(statement);
        }
        this._action = new codepipeline_actions.CodeBuildAction({
            actionName: this.props.actionName,
            input: inputs[0],
            extraInputs: inputs.slice(1),
            runOrder: this.props.runOrder ?? 100,
            project: this._project,
            environmentVariables: this.props.environmentVariables,
        });
        // Replace the placeholder actionProperties at the last minute
        this._actionProperties = this._action.actionProperties;
        return this._action.bind(scope, stage, options);
    }
    /**
     * Project generated to run the shell script in
     */
    get project() {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.ShellScriptAction#project", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "project").get);
            }
            throw error;
        }
        if (!this._project) {
            throw new Error('Project becomes available after ShellScriptAction has been bound to a stage');
        }
        return this._project;
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.ShellScriptAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
            jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onStateChange);
            }
            throw error;
        }
        if (!this._action) {
            throw new Error('Need bind() first');
        }
        return this._action.onStateChange(name, target, options);
    }
}
exports.ShellScriptAction = ShellScriptAction;
_a = JSII_RTTI_SYMBOL_1;
ShellScriptAction[_a] = { fqn: "monocdk.pipelines.ShellScriptAction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2hlbGwtc2NyaXB0LWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNoZWxsLXNjcmlwdC1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsdURBQXVEO0FBQ3ZELDZEQUE2RDtBQUM3RCw2RUFBNkU7QUEwSDdFOzs7O0dBSUc7QUFDSCxNQUFhLGlCQUFpQjtJQU01QixZQUE2QixLQUE2QjtRQUE3QixVQUFLLEdBQUwsS0FBSyxDQUF3Qjs7Ozs7OzsrQ0FOL0MsaUJBQWlCOzs7O1FBTzFCLG1GQUFtRjtRQUNuRixzRUFBc0U7UUFDdEUsRUFBRTtRQUNGLGVBQWU7UUFDZixhQUFhO1FBQ2IsV0FBVztRQUNYLGFBQWE7UUFDYixTQUFTO1FBQ1QsVUFBVTtRQUNWLElBQUksQ0FBQyxpQkFBaUIsR0FBRztZQUN2QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsUUFBUSxFQUFFLFlBQVksQ0FBQyxjQUFjLENBQUMsS0FBSztZQUMzQyxRQUFRLEVBQUUsV0FBVztZQUNyQixjQUFjLEVBQUUsRUFBRSxTQUFTLEVBQUUsQ0FBQyxFQUFFLFNBQVMsRUFBRSxDQUFDLEVBQUUsVUFBVSxFQUFFLENBQUMsRUFBRSxVQUFVLEVBQUUsQ0FBQyxFQUFFO1lBQzVFLE1BQU0sRUFBRSxFQUFFO1lBQ1YsT0FBTyxFQUFFLEVBQUU7U0FDWixDQUFDO1FBRUYsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLElBQUksRUFBRSxDQUFDLENBQUMsTUFBTSxHQUFHLENBQUMsS0FBSyxDQUFDLG1CQUFtQixJQUFJLEVBQUUsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDL0YsTUFBTSxJQUFJLEtBQUssQ0FBQywwSUFBMEksQ0FBQyxDQUFDO1NBQzdKO0tBQ0Y7SUFFRDs7T0FFRztJQUNILElBQVcsY0FBYzs7Ozs7Ozs7OztRQUN2QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDO0tBQ3BDO0lBRUQ7O09BRUc7SUFDSCxJQUFXLGdCQUFnQjs7Ozs7Ozs7OztRQUN6QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztLQUMvQjtJQUVEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLEtBQWdCLEVBQUUsS0FBMEIsRUFBRSxPQUF1Qzs7Ozs7Ozs7Ozs7OztRQUMvRixNQUFNLE1BQU0sR0FBRyxJQUFJLEtBQUssRUFBeUIsQ0FBQztRQUNsRCxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsSUFBSSxFQUFFLENBQUMsQ0FBQztRQUVyRCxNQUFNLGNBQWMsR0FBRyxJQUFJLEtBQUssRUFBVSxDQUFDO1FBRTNDLE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxJQUFJLEtBQUssQ0FBQztRQUNwRCxJQUFJLFdBQVcsRUFBRTtZQUNmLGNBQWMsQ0FBQyxJQUFJLENBQUMsT0FBTyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1NBQzNDO1FBQ0QsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLElBQUksRUFBRSxDQUFDLEVBQUU7WUFDM0UsTUFBTSxjQUFjLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztZQUUzQyxrRkFBa0Y7WUFDbEYsOEZBQThGO1lBQzlGLHlDQUF5QztZQUN6QyxJQUFJLGFBQWEsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFlBQVksS0FBSyxjQUFjLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBQ25HLElBQUksYUFBYSxLQUFLLENBQUMsQ0FBQyxFQUFFO2dCQUN4QixhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDO2FBQzFEO1lBQ0QsTUFBTSxNQUFNLEdBQUcsYUFBYSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLHFCQUFxQixjQUFjLENBQUMsUUFBUSxDQUFDLFlBQVksRUFBRSxDQUFDO1lBQ3ZILGNBQWMsQ0FBQyxJQUFJLENBQUMsVUFBVSxPQUFPLHFDQUFxQyxNQUFNLFFBQVEsY0FBYyxDQUFDLFFBQVEsT0FBTyxNQUFNLENBQUMsVUFBVSxPQUFPLENBQUMsQ0FBQztTQUNqSjtRQUVELElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxTQUFTLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUU7WUFDOUQsV0FBVyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxJQUFJLEVBQUUsVUFBVSxFQUFFLFNBQVMsQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFO1lBQzdGLEdBQUcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUc7WUFDbkIsY0FBYyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYztZQUN6QyxlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlO1lBQzNDLFNBQVMsRUFBRSxTQUFTLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQztnQkFDeEMsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsTUFBTSxFQUFFO29CQUNOLEtBQUssRUFBRTt3QkFDTCxRQUFRLEVBQUU7NEJBQ1IsR0FBRyxjQUFjOzRCQUNqQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTt5QkFDdkI7cUJBQ0Y7aUJBQ0Y7YUFDRixDQUFDO1NBQ0gsQ0FBQyxDQUFDO1FBQ0gsS0FBSyxNQUFNLFNBQVMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLG9CQUFvQixJQUFJLEVBQUUsRUFBRTtZQUM3RCxJQUFJLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQyxTQUFTLENBQUMsQ0FBQztTQUMxQztRQUVELElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxvQkFBb0IsQ0FBQyxlQUFlLENBQUM7WUFDdEQsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVTtZQUNqQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztZQUNoQixXQUFXLEVBQUUsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7WUFDNUIsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxJQUFJLEdBQUc7WUFDcEMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3RCLG9CQUFvQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CO1NBQ3RELENBQUMsQ0FBQztRQUNILDhEQUE4RDtRQUM5RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztRQUV2RCxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDakQ7SUFFRDs7T0FFRztJQUNILElBQVcsT0FBTzs7Ozs7Ozs7OztRQUNoQixJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNsQixNQUFNLElBQUksS0FBSyxDQUFDLDZFQUE2RSxDQUFDLENBQUM7U0FDaEc7UUFDRCxPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7S0FDdEI7SUFFRDs7T0FFRztJQUNJLGFBQWEsQ0FBQyxJQUFZLEVBQUUsTUFBMkIsRUFBRSxPQUEwQjs7Ozs7Ozs7Ozs7O1FBQ3hGLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2pCLE1BQU0sSUFBSSxLQUFLLENBQUMsbUJBQW1CLENBQUMsQ0FBQztTQUN0QztRQUVELE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUMsQ0FBQztLQUMxRDs7QUE3SEgsOENBOEhDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY29kZWJ1aWxkIGZyb20gJy4uLy4uLy4uLy4uL2F3cy1jb2RlYnVpbGQnO1xuaW1wb3J0ICogYXMgY29kZXBpcGVsaW5lIGZyb20gJy4uLy4uLy4uLy4uL2F3cy1jb2RlcGlwZWxpbmUnO1xuaW1wb3J0ICogYXMgY29kZXBpcGVsaW5lX2FjdGlvbnMgZnJvbSAnLi4vLi4vLi4vLi4vYXdzLWNvZGVwaXBlbGluZS1hY3Rpb25zJztcbmltcG9ydCAqIGFzIGVjMiBmcm9tICcuLi8uLi8uLi8uLi9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGV2ZW50cyBmcm9tICcuLi8uLi8uLi8uLi9hd3MtZXZlbnRzJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICcuLi8uLi8uLi8uLi9hd3MtaWFtJztcblxuaW1wb3J0IHsgU3RhY2tPdXRwdXQgfSBmcm9tICcuLi9zdGFnZSc7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICcuLi8uLi8uLi8uLi9jb3JlJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBTaGVsbFNjcmlwdEFjdGlvblxuICpcbiAqIEBkZXByZWNhdGVkIFRoaXMgY2xhc3MgaXMgcGFydCBvZiB0aGUgb2xkIEFQSS4gVXNlIHRoZSBBUEkgYmFzZWQgb24gdGhlIGBDb2RlUGlwZWxpbmVgIGNsYXNzIGluc3RlYWRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTaGVsbFNjcmlwdEFjdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIE5hbWUgb2YgdGhlIHZhbGlkYXRpb24gYWN0aW9uIGluIHRoZSBwaXBlbGluZVxuICAgKi9cbiAgcmVhZG9ubHkgYWN0aW9uTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBTdGFjayBvdXRwdXRzIHRvIG1ha2UgYXZhaWxhYmxlIGFzIGVudmlyb25tZW50IHZhcmlhYmxlc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIG91dHB1dHMgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgdXNlT3V0cHV0cz86IFJlY29yZDxzdHJpbmcsIFN0YWNrT3V0cHV0PjtcblxuICAvKipcbiAgICogQ29tbWFuZHMgdG8gcnVuXG4gICAqL1xuICByZWFkb25seSBjb21tYW5kczogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEJhc2ggb3B0aW9ucyB0byBzZXQgYXQgdGhlIHN0YXJ0IG9mIHRoZSBzY3JpcHRcbiAgICpcbiAgICogQGRlZmF1bHQgJy1ldScgKGVycmV4aXQgYW5kIG5vdW5zZXQpXG4gICAqL1xuICByZWFkb25seSBiYXNoT3B0aW9ucz86IHN0cmluZztcblxuICAvKipcbiAgICogQWRkaXRpb25hbCBhcnRpZmFjdHMgdG8gdXNlIGFzIGlucHV0IGZvciB0aGUgQ29kZUJ1aWxkIHByb2plY3RcbiAgICpcbiAgICogWW91IGNhbiB1c2UgdGhlc2UgZmlsZXMgdG8gbG9hZCBtb3JlIGNvbXBsZXggdGVzdCBzZXRzIGludG8gdGhlXG4gICAqIHNoZWxsc2NyaXB0IGJ1aWxkIGVudmlyb25tZW50LlxuICAgKlxuICAgKiBUaGUgZmlsZXMgYXJ0aWZhY3QgZ2l2ZW4gaGVyZSB3aWxsIGJlIHVucGFja2VkIGludG8gdGhlIGN1cnJlbnRcbiAgICogd29ya2luZyBkaXJlY3RvcnksIHRoZSBvdGhlciBvbmVzIHdpbGwgYmUgdW5wYWNrZWQgaW50byBkaXJlY3Rvcmllc1xuICAgKiB3aGljaCBhcmUgYXZhaWxhYmxlIHRocm91Z2ggdGhlIGVudmlyb25tZW50IHZhcmlhYmxlc1xuICAgKiAkQ09ERUJVSUxEX1NSQ19ESVJfPGFydGlmYWN0TmFtZT4uXG4gICAqXG4gICAqIFRoZSBDb2RlQnVpbGQgam9iIG11c3QgaGF2ZSBhdCBsZWFzdCBvbmUgaW5wdXQgYXJ0aWZhY3QsIHNvIHlvdVxuICAgKiBtdXN0IHByb3ZpZGUgZWl0aGVyIGF0IGxlYXN0IG9uZSBhZGRpdGlvbmFsIGFydGlmYWN0IGhlcmUgb3Igb25lXG4gICAqIHN0YWNrIG91dHB1dCB1c2luZyBgdXNlT3V0cHV0YC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBhZGRpdGlvbmFsIGFydGlmYWN0c1xuICAgKi9cbiAgcmVhZG9ubHkgYWRkaXRpb25hbEFydGlmYWN0cz86IGNvZGVwaXBlbGluZS5BcnRpZmFjdFtdO1xuXG4gIC8qKlxuICAgKiBUaGUgQ29kZUJ1aWxkIGVudmlyb25tZW50IHdoZXJlIHNjcmlwdHMgYXJlIGV4ZWN1dGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCBMaW51eEJ1aWxkSW1hZ2UuU1RBTkRBUkRfNV8wXG4gICAqL1xuICByZWFkb25seSBlbnZpcm9ubWVudD86IGNvZGVidWlsZC5CdWlsZEVudmlyb25tZW50XG5cbiAgLyoqXG4gICAqIEVudmlyb25tZW50IHZhcmlhYmxlcyB0byBzZW5kIGludG8gYnVpbGRcbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBhZGRpdGlvbmFsIGVudmlyb25tZW50IHZhcmlhYmxlc1xuICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRWYXJpYWJsZXM/OiBSZWNvcmQ8c3RyaW5nLCBjb2RlYnVpbGQuQnVpbGRFbnZpcm9ubWVudFZhcmlhYmxlPjtcblxuICAvKipcbiAgICogUnVuT3JkZXIgZm9yIHRoaXMgYWN0aW9uXG4gICAqXG4gICAqIFVzZSB0aGlzIHRvIHNlcXVlbmNlIHRoZSBzaGVsbCBzY3JpcHQgYWZ0ZXIgdGhlIGRlcGxveW1lbnRzLlxuICAgKlxuICAgKiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyAxMDAgc28geW91IGRvbid0IGhhdmUgdG8gc3VwcGx5IHRoZSB2YWx1ZSBpZiB5b3UganVzdFxuICAgKiB3YW50IHRvIHJ1biB0aGlzIGFmdGVyIHRoZSBhcHBsaWNhdGlvbiBzdGFja3MgaGF2ZSBiZWVuIGRlcGxveWVkLCBhbmQgeW91XG4gICAqIGRvbid0IGhhdmUgbW9yZSB0aGFuIDEwMCBzdGFja3MuXG4gICAqXG4gICAqIEBkZWZhdWx0IDEwMFxuICAgKi9cbiAgcmVhZG9ubHkgcnVuT3JkZXI/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIEFkZGl0aW9uYWwgcG9saWN5IHN0YXRlbWVudHMgdG8gYWRkIHRvIHRoZSBleGVjdXRpb24gcm9sZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIHBvbGljeSBzdGF0ZW1lbnRzXG4gICAqL1xuICByZWFkb25seSByb2xlUG9saWN5U3RhdGVtZW50cz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXTtcblxuICAvKipcbiAgICogVGhlIFZQQyB3aGVyZSB0byBleGVjdXRlIHRoZSBzcGVjaWZpZWQgc2NyaXB0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIFZQQ1xuICAgKi9cbiAgcmVhZG9ubHkgdnBjPzogZWMyLklWcGM7XG5cbiAgLyoqXG4gICAqIFdoaWNoIHN1Ym5ldHMgdG8gdXNlLlxuICAgKlxuICAgKiBPbmx5IHVzZWQgaWYgJ3ZwYycgaXMgc3VwcGxpZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQWxsIHByaXZhdGUgc3VibmV0cy5cbiAgICovXG4gIHJlYWRvbmx5IHN1Ym5ldFNlbGVjdGlvbj86IGVjMi5TdWJuZXRTZWxlY3Rpb25cblxuICAvKipcbiAgICogV2hpY2ggc2VjdXJpdHkgZ3JvdXAgdG8gYXNzb2NpYXRlIHdpdGggdGhlIHNjcmlwdCdzIHByb2plY3QgbmV0d29yayBpbnRlcmZhY2VzLlxuICAgKiBJZiBubyBzZWN1cml0eSBncm91cCBpcyBpZGVudGlmaWVkLCBvbmUgd2lsbCBiZSBjcmVhdGVkIGF1dG9tYXRpY2FsbHkuXG4gICAqXG4gICAqIE9ubHkgdXNlZCBpZiAndnBjJyBpcyBzdXBwbGllZC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBTZWN1cml0eSBncm91cCB3aWxsIGJlIGF1dG9tYXRpY2FsbHkgY3JlYXRlZC5cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBzPzogZWMyLklTZWN1cml0eUdyb3VwW107XG59XG5cbi8qKlxuICogVmFsaWRhdGUgYSByZXZpc2lvbiB1c2luZyBzaGVsbCBjb21tYW5kc1xuICpcbiAqIEBkZXByZWNhdGVkIFRoaXMgY2xhc3MgaXMgcGFydCBvZiB0aGUgb2xkIEFQSS4gVXNlIHRoZSBBUEkgYmFzZWQgb24gdGhlIGBDb2RlUGlwZWxpbmVgIGNsYXNzIGluc3RlYWRcbiAqL1xuZXhwb3J0IGNsYXNzIFNoZWxsU2NyaXB0QWN0aW9uIGltcGxlbWVudHMgY29kZXBpcGVsaW5lLklBY3Rpb24sIGlhbS5JR3JhbnRhYmxlIHtcbiAgcHJpdmF0ZSBfcHJvamVjdD86IGNvZGVidWlsZC5JUHJvamVjdDtcblxuICBwcml2YXRlIF9hY3Rpb24/OiBjb2RlcGlwZWxpbmVfYWN0aW9ucy5Db2RlQnVpbGRBY3Rpb247XG4gIHByaXZhdGUgX2FjdGlvblByb3BlcnRpZXM6IGNvZGVwaXBlbGluZS5BY3Rpb25Qcm9wZXJ0aWVzO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFNoZWxsU2NyaXB0QWN0aW9uUHJvcHMpIHtcbiAgICAvLyBBIG51bWJlciBvZiBhY3Rpb25Qcm9wZXJ0aWVzIGdldCByZWFkIGJlZm9yZSBiaW5kKCkgaXMgZXZlbiBjYWxsZWQgKHNvIGJlZm9yZSB3ZVxuICAgIC8vIGhhdmUgbWFkZSB0aGUgUHJvamVjdCBhbmQgY2FuIGNvbnN0cnVjdCB0aGUgYWN0dWFsIENvZGVCdWlsZEFjdGlvbilcbiAgICAvL1xuICAgIC8vIC0gYWN0aW9uTmFtZVxuICAgIC8vIC0gcmVzb3VyY2VcbiAgICAvLyAtIHJlZ2lvblxuICAgIC8vIC0gY2F0ZWdvcnlcbiAgICAvLyAtIHJvbGVcbiAgICAvLyAtIG93bmVyXG4gICAgdGhpcy5fYWN0aW9uUHJvcGVydGllcyA9IHtcbiAgICAgIGFjdGlvbk5hbWU6IHByb3BzLmFjdGlvbk5hbWUsXG4gICAgICBjYXRlZ29yeTogY29kZXBpcGVsaW5lLkFjdGlvbkNhdGVnb3J5LkJVSUxELFxuICAgICAgcHJvdmlkZXI6ICdDb2RlQnVpbGQnLFxuICAgICAgYXJ0aWZhY3RCb3VuZHM6IHsgbWluSW5wdXRzOiAwLCBtYXhJbnB1dHM6IDUsIG1pbk91dHB1dHM6IDAsIG1heE91dHB1dHM6IDUgfSxcbiAgICAgIGlucHV0czogW10sXG4gICAgICBvdXRwdXRzOiBbXSxcbiAgICB9O1xuXG4gICAgaWYgKE9iamVjdC5rZXlzKHByb3BzLnVzZU91dHB1dHMgPz8ge30pLmxlbmd0aCArIChwcm9wcy5hZGRpdGlvbmFsQXJ0aWZhY3RzID8/IFtdKS5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignWW91IG11c3Qgc3VwcGx5IGVpdGhlciBcXCd1c2VPdXRwdXRzXFwnIG9yIFxcJ2FkZGl0aW9uYWxBcnRpZmFjdHNcXCcsIHNpbmNlIGEgQ29kZUJ1aWxkIEFjdGlvbiBtdXN0IGFsd2F5cyBoYXZlIGF0IGxlYXN0IG9uZSBpbnB1dCBhcnRpZmFjdC4nKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogVGhlIENvZGVCdWlsZCBQcm9qZWN0J3MgcHJpbmNpcGFsXG4gICAqL1xuICBwdWJsaWMgZ2V0IGdyYW50UHJpbmNpcGFsKCk6IGlhbS5JUHJpbmNpcGFsIHtcbiAgICByZXR1cm4gdGhpcy5wcm9qZWN0LmdyYW50UHJpbmNpcGFsO1xuICB9XG5cbiAgLyoqXG4gICAqIEV4aXN0cyB0byBpbXBsZW1lbnQgSUFjdGlvblxuICAgKi9cbiAgcHVibGljIGdldCBhY3Rpb25Qcm9wZXJ0aWVzKCk6IGNvZGVwaXBlbGluZS5BY3Rpb25Qcm9wZXJ0aWVzIHtcbiAgICByZXR1cm4gdGhpcy5fYWN0aW9uUHJvcGVydGllcztcbiAgfVxuXG4gIC8qKlxuICAgKiBFeGlzdHMgdG8gaW1wbGVtZW50IElBY3Rpb25cbiAgICovXG4gIHB1YmxpYyBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QsIHN0YWdlOiBjb2RlcGlwZWxpbmUuSVN0YWdlLCBvcHRpb25zOiBjb2RlcGlwZWxpbmUuQWN0aW9uQmluZE9wdGlvbnMpOiBjb2RlcGlwZWxpbmUuQWN0aW9uQ29uZmlnIHtcbiAgICBjb25zdCBpbnB1dHMgPSBuZXcgQXJyYXk8Y29kZXBpcGVsaW5lLkFydGlmYWN0PigpO1xuICAgIGlucHV0cy5wdXNoKC4uLnRoaXMucHJvcHMuYWRkaXRpb25hbEFydGlmYWN0cyA/PyBbXSk7XG5cbiAgICBjb25zdCBlbnZWYXJDb21tYW5kcyA9IG5ldyBBcnJheTxzdHJpbmc+KCk7XG5cbiAgICBjb25zdCBiYXNoT3B0aW9ucyA9IHRoaXMucHJvcHMuYmFzaE9wdGlvbnMgPz8gJy1ldSc7XG4gICAgaWYgKGJhc2hPcHRpb25zKSB7XG4gICAgICBlbnZWYXJDb21tYW5kcy5wdXNoKGBzZXQgJHtiYXNoT3B0aW9uc31gKTtcbiAgICB9XG4gICAgZm9yIChjb25zdCBbdmFyTmFtZSwgb3V0cHV0XSBvZiBPYmplY3QuZW50cmllcyh0aGlzLnByb3BzLnVzZU91dHB1dHMgPz8ge30pKSB7XG4gICAgICBjb25zdCBvdXRwdXRBcnRpZmFjdCA9IG91dHB1dC5hcnRpZmFjdEZpbGU7XG5cbiAgICAgIC8vIEFkZCB0aGUgYXJ0aWZhY3QgdG8gdGhlIGxpc3Qgb2YgaW5wdXRzLCBpZiBpdCdzIG5vdCBpbiB0aGVyZSBhbHJlYWR5LiBEZXRlcm1pbmVcbiAgICAgIC8vIHRoZSBsb2NhdGlvbiB3aGVyZSBDb2RlQnVpbGQgaXMgZ29pbmcgdG8gc3RpY2sgaXQgYmFzZWQgb24gd2hldGhlciBpdCdzIHRoZSBmaXJzdCAocHJpbWFyeSlcbiAgICAgIC8vIGlucHV0IG9yIGFuICdleHRyYSBpbnB1dCcsIHRoZW4gcGFyc2UuXG4gICAgICBsZXQgYXJ0aWZhY3RJbmRleCA9IGlucHV0cy5maW5kSW5kZXgoYSA9PiBhLmFydGlmYWN0TmFtZSA9PT0gb3V0cHV0QXJ0aWZhY3QuYXJ0aWZhY3QuYXJ0aWZhY3ROYW1lKTtcbiAgICAgIGlmIChhcnRpZmFjdEluZGV4ID09PSAtMSkge1xuICAgICAgICBhcnRpZmFjdEluZGV4ID0gaW5wdXRzLnB1c2gob3V0cHV0QXJ0aWZhY3QuYXJ0aWZhY3QpIC0gMTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IGRpckVudiA9IGFydGlmYWN0SW5kZXggPT09IDAgPyAnQ09ERUJVSUxEX1NSQ19ESVInIDogYENPREVCVUlMRF9TUkNfRElSXyR7b3V0cHV0QXJ0aWZhY3QuYXJ0aWZhY3QuYXJ0aWZhY3ROYW1lfWA7XG4gICAgICBlbnZWYXJDb21tYW5kcy5wdXNoKGBleHBvcnQgJHt2YXJOYW1lfT1cIiQobm9kZSAtcGUgJ3JlcXVpcmUocHJvY2Vzcy5lbnYuJHtkaXJFbnZ9ICsgXCIvJHtvdXRwdXRBcnRpZmFjdC5maWxlTmFtZX1cIilbXCIke291dHB1dC5vdXRwdXROYW1lfVwiXScpXCJgKTtcbiAgICB9XG5cbiAgICB0aGlzLl9wcm9qZWN0ID0gbmV3IGNvZGVidWlsZC5QaXBlbGluZVByb2plY3Qoc2NvcGUsICdQcm9qZWN0Jywge1xuICAgICAgZW52aXJvbm1lbnQ6IHRoaXMucHJvcHMuZW52aXJvbm1lbnQgfHwgeyBidWlsZEltYWdlOiBjb2RlYnVpbGQuTGludXhCdWlsZEltYWdlLlNUQU5EQVJEXzVfMCB9LFxuICAgICAgdnBjOiB0aGlzLnByb3BzLnZwYyxcbiAgICAgIHNlY3VyaXR5R3JvdXBzOiB0aGlzLnByb3BzLnNlY3VyaXR5R3JvdXBzLFxuICAgICAgc3VibmV0U2VsZWN0aW9uOiB0aGlzLnByb3BzLnN1Ym5ldFNlbGVjdGlvbixcbiAgICAgIGJ1aWxkU3BlYzogY29kZWJ1aWxkLkJ1aWxkU3BlYy5mcm9tT2JqZWN0KHtcbiAgICAgICAgdmVyc2lvbjogJzAuMicsXG4gICAgICAgIHBoYXNlczoge1xuICAgICAgICAgIGJ1aWxkOiB7XG4gICAgICAgICAgICBjb21tYW5kczogW1xuICAgICAgICAgICAgICAuLi5lbnZWYXJDb21tYW5kcyxcbiAgICAgICAgICAgICAgLi4udGhpcy5wcm9wcy5jb21tYW5kcyxcbiAgICAgICAgICAgIF0sXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH0pLFxuICAgIH0pO1xuICAgIGZvciAoY29uc3Qgc3RhdGVtZW50IG9mIHRoaXMucHJvcHMucm9sZVBvbGljeVN0YXRlbWVudHMgPz8gW10pIHtcbiAgICAgIHRoaXMuX3Byb2plY3QuYWRkVG9Sb2xlUG9saWN5KHN0YXRlbWVudCk7XG4gICAgfVxuXG4gICAgdGhpcy5fYWN0aW9uID0gbmV3IGNvZGVwaXBlbGluZV9hY3Rpb25zLkNvZGVCdWlsZEFjdGlvbih7XG4gICAgICBhY3Rpb25OYW1lOiB0aGlzLnByb3BzLmFjdGlvbk5hbWUsXG4gICAgICBpbnB1dDogaW5wdXRzWzBdLFxuICAgICAgZXh0cmFJbnB1dHM6IGlucHV0cy5zbGljZSgxKSxcbiAgICAgIHJ1bk9yZGVyOiB0aGlzLnByb3BzLnJ1bk9yZGVyID8/IDEwMCxcbiAgICAgIHByb2plY3Q6IHRoaXMuX3Byb2plY3QsXG4gICAgICBlbnZpcm9ubWVudFZhcmlhYmxlczogdGhpcy5wcm9wcy5lbnZpcm9ubWVudFZhcmlhYmxlcyxcbiAgICB9KTtcbiAgICAvLyBSZXBsYWNlIHRoZSBwbGFjZWhvbGRlciBhY3Rpb25Qcm9wZXJ0aWVzIGF0IHRoZSBsYXN0IG1pbnV0ZVxuICAgIHRoaXMuX2FjdGlvblByb3BlcnRpZXMgPSB0aGlzLl9hY3Rpb24uYWN0aW9uUHJvcGVydGllcztcblxuICAgIHJldHVybiB0aGlzLl9hY3Rpb24uYmluZChzY29wZSwgc3RhZ2UsIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIFByb2plY3QgZ2VuZXJhdGVkIHRvIHJ1biB0aGUgc2hlbGwgc2NyaXB0IGluXG4gICAqL1xuICBwdWJsaWMgZ2V0IHByb2plY3QoKTogY29kZWJ1aWxkLklQcm9qZWN0IHtcbiAgICBpZiAoIXRoaXMuX3Byb2plY3QpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignUHJvamVjdCBiZWNvbWVzIGF2YWlsYWJsZSBhZnRlciBTaGVsbFNjcmlwdEFjdGlvbiBoYXMgYmVlbiBib3VuZCB0byBhIHN0YWdlJyk7XG4gICAgfVxuICAgIHJldHVybiB0aGlzLl9wcm9qZWN0O1xuICB9XG5cbiAgLyoqXG4gICAqIEV4aXN0cyB0byBpbXBsZW1lbnQgSUFjdGlvblxuICAgKi9cbiAgcHVibGljIG9uU3RhdGVDaGFuZ2UobmFtZTogc3RyaW5nLCB0YXJnZXQ/OiBldmVudHMuSVJ1bGVUYXJnZXQsIG9wdGlvbnM/OiBldmVudHMuUnVsZVByb3BzKTogZXZlbnRzLlJ1bGUge1xuICAgIGlmICghdGhpcy5fYWN0aW9uKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ05lZWQgYmluZCgpIGZpcnN0Jyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuX2FjdGlvbi5vblN0YXRlQ2hhbmdlKG5hbWUsIHRhcmdldCwgb3B0aW9ucyk7XG4gIH1cbn1cbiJdfQ==