import * as iam from '../../../aws-iam';
import { PolicyStatement } from '../../../aws-iam';
import { Construct } from 'constructs';
/**
 * Role which will be reused across asset jobs
 *
 * Has some '*' resources to save IAM policy space, and will not
 * actually add policies that look like policies that were already added.
 */
export declare class AssetSingletonRole extends iam.Role {
    private _rejectDuplicates;
    constructor(scope: Construct, id: string, props: iam.RoleProps);
    addToPrincipalPolicy(statement: PolicyStatement): iam.AddToPrincipalPolicyResult;
}
