"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toPosixPath = void 0;
const path = require("path");
/**
 * Convert a file path on the current system to a file path that can be used on Linux
 *
 * Takes the current OS' file separator and replaces all of them with a '/'.
 *
 * Relevant if the current system is a Windows machine but is generating
 * commands for a Linux CodeBuild image.
 */
function toPosixPath(osPath, currentSep) {
    const regex = new RegExp(`\\${currentSep ?? path.sep}`, 'g');
    return osPath.replace(regex, '/');
}
exports.toPosixPath = toPosixPath;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFFN0I7Ozs7Ozs7R0FPRztBQUNILFNBQWdCLFdBQVcsQ0FBQyxNQUFjLEVBQUUsVUFBbUI7SUFDN0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQUMsS0FBSyxVQUFVLElBQUksSUFBSSxDQUFDLEdBQUcsRUFBRSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQzdELE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQUM7QUFDcEMsQ0FBQztBQUhELGtDQUdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcblxuLyoqXG4gKiBDb252ZXJ0IGEgZmlsZSBwYXRoIG9uIHRoZSBjdXJyZW50IHN5c3RlbSB0byBhIGZpbGUgcGF0aCB0aGF0IGNhbiBiZSB1c2VkIG9uIExpbnV4XG4gKlxuICogVGFrZXMgdGhlIGN1cnJlbnQgT1MnIGZpbGUgc2VwYXJhdG9yIGFuZCByZXBsYWNlcyBhbGwgb2YgdGhlbSB3aXRoIGEgJy8nLlxuICpcbiAqIFJlbGV2YW50IGlmIHRoZSBjdXJyZW50IHN5c3RlbSBpcyBhIFdpbmRvd3MgbWFjaGluZSBidXQgaXMgZ2VuZXJhdGluZ1xuICogY29tbWFuZHMgZm9yIGEgTGludXggQ29kZUJ1aWxkIGltYWdlLlxuICovXG5leHBvcnQgZnVuY3Rpb24gdG9Qb3NpeFBhdGgob3NQYXRoOiBzdHJpbmcsIGN1cnJlbnRTZXA/OiBzdHJpbmcpIHtcbiAgY29uc3QgcmVnZXggPSBuZXcgUmVnRXhwKGBcXFxcJHtjdXJyZW50U2VwID8/IHBhdGguc2VwfWAsICdnJyk7XG4gIHJldHVybiBvc1BhdGgucmVwbGFjZShyZWdleCwgJy8nKTtcbn0iXX0=