"use strict";
(self["webpackChunkmito_ai"] = self["webpackChunkmito_ai"] || []).push([["vendors-node_modules_aws-amplify_dist_esm_index_mjs"],{

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/IdentityIdProvider.mjs":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/IdentityIdProvider.mjs ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cognitoIdentityIdProvider: () => (/* binding */ cognitoIdentityIdProvider)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/createGetIdClient.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _factories_createCognitoIdentityPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../factories/createCognitoIdentityPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoIdentityPoolEndpointResolver.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/utils.mjs");









// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Provides a Cognito identityId
 *
 * @param tokens - The AuthTokens received after SignIn
 * @returns string
 * @throws configuration exceptions: `InvalidIdentityPoolIdException`
 *  - Auth errors that may arise from misconfiguration.
 * @throws service exceptions: {@link GetIdException }
 */
async function cognitoIdentityIdProvider({ tokens, authConfig, identityIdStore, }) {
    identityIdStore.setAuthConfig({ Cognito: authConfig });
    // will return null only if there is no identityId cached or if there is an error retrieving it
    const identityId = await identityIdStore.loadIdentityId();
    if (identityId) {
        return identityId.id;
    }
    const logins = tokens?.idToken
        ? (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.formLoginsMap)(tokens.idToken.toString())
        : {};
    const generatedIdentityId = await generateIdentityId(logins, authConfig);
    // Store generated identityId
    identityIdStore.storeIdentityId({
        id: generatedIdentityId,
        type: tokens ? 'primary' : 'guest',
    });
    return generatedIdentityId;
}
async function generateIdentityId(logins, authConfig) {
    const identityPoolId = authConfig?.identityPoolId;
    const region = (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_1__.getRegionFromIdentityPoolId)(identityPoolId);
    const getId = (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.createGetIdClient)({
        endpointResolver: (0,_factories_createCognitoIdentityPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoIdentityPoolEndpointResolver)({
            endpointOverride: authConfig.identityPoolEndpoint,
        }),
    });
    // IdentityId is absent so get it using IdentityPoolId with Cognito's GetId API
    let idResult;
    // for a first-time user, this will return a brand new identity
    // for a returning user, this will retrieve the previous identity assocaited with the logins
    try {
        idResult = (await getId({
            region,
        }, {
            IdentityPoolId: identityPoolId,
            Logins: logins,
        })).IdentityId;
    }
    catch (e) {
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_4__.assertServiceError)(e);
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__.AuthError(e);
    }
    if (!idResult) {
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__.AuthError({
            name: 'GetIdResponseException',
            message: 'Received undefined response from getId operation',
            recoverySuggestion: 'Make sure to pass a valid identityPoolId in the configuration.',
        });
    }
    return idResult;
}


//# sourceMappingURL=IdentityIdProvider.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/IdentityIdStore.mjs":
/*!***********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/IdentityIdStore.mjs ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultIdentityIdStore: () => (/* binding */ DefaultIdentityIdStore)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/Logger/ConsoleLogger.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _tokenProvider_TokenStore_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../tokenProvider/TokenStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/TokenStore.mjs");
/* harmony import */ var _types_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/types.mjs");





// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const logger = new _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.ConsoleLogger('DefaultIdentityIdStore');
class DefaultIdentityIdStore {
    setAuthConfig(authConfigParam) {
        (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertIdentityPoolIdConfig)(authConfigParam.Cognito);
        this.authConfig = authConfigParam;
        this._authKeys = createKeysForAuthStorage('Cognito', authConfigParam.Cognito.identityPoolId);
    }
    constructor(keyValueStorage) {
        this._authKeys = {};
        this._hasGuestIdentityId = false;
        this.keyValueStorage = keyValueStorage;
    }
    async loadIdentityId() {
        (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertIdentityPoolIdConfig)(this.authConfig?.Cognito);
        try {
            if (this._primaryIdentityId) {
                return {
                    id: this._primaryIdentityId,
                    type: 'primary',
                };
            }
            else {
                const storedIdentityId = await this.keyValueStorage.getItem(this._authKeys.identityId);
                if (storedIdentityId) {
                    this._hasGuestIdentityId = true;
                    return {
                        id: storedIdentityId,
                        type: 'guest',
                    };
                }
                return null;
            }
        }
        catch (err) {
            logger.log('Error getting stored IdentityId.', err);
            return null;
        }
    }
    async storeIdentityId(identity) {
        (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertIdentityPoolIdConfig)(this.authConfig?.Cognito);
        if (identity.type === 'guest') {
            this.keyValueStorage.setItem(this._authKeys.identityId, identity.id);
            // Clear in-memory storage of primary identityId
            this._primaryIdentityId = undefined;
            this._hasGuestIdentityId = true;
        }
        else {
            this._primaryIdentityId = identity.id;
            // Clear locally stored guest id
            if (this._hasGuestIdentityId) {
                this.keyValueStorage.removeItem(this._authKeys.identityId);
                this._hasGuestIdentityId = false;
            }
        }
    }
    async clearIdentityId() {
        this._primaryIdentityId = undefined;
        await this.keyValueStorage.removeItem(this._authKeys.identityId);
    }
}
const createKeysForAuthStorage = (provider, identifier) => {
    return (0,_tokenProvider_TokenStore_mjs__WEBPACK_IMPORTED_MODULE_2__.getAuthStorageKeys)(_types_mjs__WEBPACK_IMPORTED_MODULE_3__.IdentityIdStorageKeys)(`com.amplify.${provider}`, identifier);
};


//# sourceMappingURL=IdentityIdStore.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/credentialsProvider.mjs":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/credentialsProvider.mjs ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CognitoAWSCredentialsAndIdentityIdProvider: () => (/* binding */ CognitoAWSCredentialsAndIdentityIdProvider)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/Logger/ConsoleLogger.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/createGetCredentialsForIdentityClient.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_types_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");
/* harmony import */ var _factories_createCognitoIdentityPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../factories/createCognitoIdentityPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoIdentityPoolEndpointResolver.mjs");
/* harmony import */ var _IdentityIdProvider_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IdentityIdProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/IdentityIdProvider.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/utils.mjs");











// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const logger = new _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.ConsoleLogger('CognitoCredentialsProvider');
const CREDENTIALS_TTL = 50 * 60 * 1000; // 50 min, can be modified on config if required in the future
class CognitoAWSCredentialsAndIdentityIdProvider {
    constructor(identityIdStore) {
        this._nextCredentialsRefresh = 0;
        this._identityIdStore = identityIdStore;
    }
    async clearCredentialsAndIdentityId() {
        logger.debug('Clearing out credentials and identityId');
        this._credentialsAndIdentityId = undefined;
        await this._identityIdStore.clearIdentityId();
    }
    async clearCredentials() {
        logger.debug('Clearing out in-memory credentials');
        this._credentialsAndIdentityId = undefined;
    }
    async getCredentialsAndIdentityId(getCredentialsOptions) {
        const isAuthenticated = getCredentialsOptions.authenticated;
        const { tokens } = getCredentialsOptions;
        const { authConfig } = getCredentialsOptions;
        try {
            (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertIdentityPoolIdConfig)(authConfig?.Cognito);
        }
        catch {
            // No identity pool configured, skipping
            return;
        }
        if (!isAuthenticated && !authConfig.Cognito.allowGuestAccess) {
            // TODO(V6): return partial result like Native platforms
            return;
        }
        const { forceRefresh } = getCredentialsOptions;
        const tokenHasChanged = this.hasTokenChanged(tokens);
        const identityId = await (0,_IdentityIdProvider_mjs__WEBPACK_IMPORTED_MODULE_2__.cognitoIdentityIdProvider)({
            tokens,
            authConfig: authConfig.Cognito,
            identityIdStore: this._identityIdStore,
        });
        // Clear cached credentials when forceRefresh is true OR the cache token has changed
        if (forceRefresh || tokenHasChanged) {
            this.clearCredentials();
        }
        if (!isAuthenticated) {
            return this.getGuestCredentials(identityId, authConfig.Cognito);
        }
        else {
            (0,_utils_types_mjs__WEBPACK_IMPORTED_MODULE_3__.assertIdTokenInAuthTokens)(tokens);
            return this.credsForOIDCTokens(authConfig.Cognito, tokens, identityId);
        }
    }
    async getGuestCredentials(identityId, authConfig) {
        // Return existing in-memory cached credentials only if it exists, is not past it's lifetime and is unauthenticated credentials
        if (this._credentialsAndIdentityId &&
            !this.isPastTTL() &&
            this._credentialsAndIdentityId.isAuthenticatedCreds === false) {
            logger.info('returning stored credentials as they neither past TTL nor expired.');
            return this._credentialsAndIdentityId;
        }
        // Clear to discard if any authenticated credentials are set and start with a clean slate
        this.clearCredentials();
        const region = (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromIdentityPoolId)(authConfig.identityPoolId);
        const getCredentialsForIdentity = (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_5__.createGetCredentialsForIdentityClient)({
            endpointResolver: (0,_factories_createCognitoIdentityPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__.createCognitoIdentityPoolEndpointResolver)({
                endpointOverride: authConfig.identityPoolEndpoint,
            }),
        });
        // use identityId to obtain guest credentials
        // save credentials in-memory
        // No logins params should be passed for guest creds:
        // https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html
        let clientResult;
        try {
            clientResult = await getCredentialsForIdentity({ region }, {
                IdentityId: identityId,
            });
        }
        catch (e) {
            (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_7__.assertServiceError)(e);
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_8__.AuthError(e);
        }
        if (clientResult?.Credentials?.AccessKeyId &&
            clientResult?.Credentials?.SecretKey) {
            this._nextCredentialsRefresh = new Date().getTime() + CREDENTIALS_TTL;
            const res = {
                credentials: {
                    accessKeyId: clientResult.Credentials.AccessKeyId,
                    secretAccessKey: clientResult.Credentials.SecretKey,
                    sessionToken: clientResult.Credentials.SessionToken,
                    expiration: clientResult.Credentials.Expiration,
                },
                identityId,
            };
            if (clientResult.IdentityId) {
                res.identityId = clientResult.IdentityId;
                this._identityIdStore.storeIdentityId({
                    id: clientResult.IdentityId,
                    type: 'guest',
                });
            }
            this._credentialsAndIdentityId = {
                ...res,
                isAuthenticatedCreds: false,
            };
            return res;
        }
        else {
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_8__.AuthError({
                name: 'CredentialsNotFoundException',
                message: `Cognito did not respond with either Credentials, AccessKeyId or SecretKey.`,
            });
        }
    }
    async credsForOIDCTokens(authConfig, authTokens, identityId) {
        if (this._credentialsAndIdentityId &&
            !this.isPastTTL() &&
            this._credentialsAndIdentityId.isAuthenticatedCreds === true) {
            logger.debug('returning stored credentials as they neither past TTL nor expired.');
            return this._credentialsAndIdentityId;
        }
        // Clear to discard if any unauthenticated credentials are set and start with a clean slate
        this.clearCredentials();
        const logins = authTokens.idToken
            ? (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_9__.formLoginsMap)(authTokens.idToken.toString())
            : {};
        const region = (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromIdentityPoolId)(authConfig.identityPoolId);
        const getCredentialsForIdentity = (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_5__.createGetCredentialsForIdentityClient)({
            endpointResolver: (0,_factories_createCognitoIdentityPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__.createCognitoIdentityPoolEndpointResolver)({
                endpointOverride: authConfig.identityPoolEndpoint,
            }),
        });
        let clientResult;
        try {
            clientResult = await getCredentialsForIdentity({ region }, {
                IdentityId: identityId,
                Logins: logins,
            });
        }
        catch (e) {
            (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_7__.assertServiceError)(e);
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_8__.AuthError(e);
        }
        if (clientResult?.Credentials?.AccessKeyId &&
            clientResult?.Credentials?.SecretKey) {
            this._nextCredentialsRefresh = new Date().getTime() + CREDENTIALS_TTL;
            const res = {
                credentials: {
                    accessKeyId: clientResult.Credentials.AccessKeyId,
                    secretAccessKey: clientResult.Credentials.SecretKey,
                    sessionToken: clientResult.Credentials.SessionToken,
                    expiration: clientResult.Credentials.Expiration,
                },
                identityId,
            };
            if (clientResult.IdentityId) {
                res.identityId = clientResult.IdentityId;
                // note: the following call removes guest identityId from the persistent store (localStorage)
                this._identityIdStore.storeIdentityId({
                    id: clientResult.IdentityId,
                    type: 'primary',
                });
            }
            // Store the credentials in-memory along with the expiration
            this._credentialsAndIdentityId = {
                ...res,
                isAuthenticatedCreds: true,
                associatedIdToken: authTokens.idToken?.toString(),
            };
            return res;
        }
        else {
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_8__.AuthError({
                name: 'CredentialsException',
                message: `Cognito did not respond with either Credentials, AccessKeyId or SecretKey.`,
            });
        }
    }
    isPastTTL() {
        return this._nextCredentialsRefresh === undefined
            ? true
            : this._nextCredentialsRefresh <= Date.now();
    }
    hasTokenChanged(tokens) {
        return (!!tokens &&
            !!this._credentialsAndIdentityId?.associatedIdToken &&
            tokens.idToken?.toString() !==
                this._credentialsAndIdentityId.associatedIdToken);
    }
}


//# sourceMappingURL=credentialsProvider.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/index.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/index.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CognitoAWSCredentialsAndIdentityIdProvider: () => (/* reexport safe */ _credentialsProvider_mjs__WEBPACK_IMPORTED_MODULE_0__.CognitoAWSCredentialsAndIdentityIdProvider),
/* harmony export */   DefaultIdentityIdStore: () => (/* reexport safe */ _IdentityIdStore_mjs__WEBPACK_IMPORTED_MODULE_1__.DefaultIdentityIdStore),
/* harmony export */   cognitoCredentialsProvider: () => (/* binding */ cognitoCredentialsProvider)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/storage/index.mjs");
/* harmony import */ var _IdentityIdStore_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IdentityIdStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/IdentityIdStore.mjs");
/* harmony import */ var _credentialsProvider_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./credentialsProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/credentialsProvider.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Cognito specific implmentation of the CredentialsProvider interface
 * that manages setting and getting of AWS Credentials.
 *
 * @throws configuration expections: `InvalidIdentityPoolIdException`
 *  - Auth errors that may arise from misconfiguration.
 * @throws service expections: {@link GetCredentialsForIdentityException}, {@link GetIdException}
 *
 */
const cognitoCredentialsProvider = new _credentialsProvider_mjs__WEBPACK_IMPORTED_MODULE_0__.CognitoAWSCredentialsAndIdentityIdProvider(new _IdentityIdStore_mjs__WEBPACK_IMPORTED_MODULE_1__.DefaultIdentityIdStore(_aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.defaultStorage));


//# sourceMappingURL=index.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/types.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/types.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IdentityIdStorageKeys: () => (/* binding */ IdentityIdStorageKeys)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const IdentityIdStorageKeys = {
    identityId: 'identityId',
};


//# sourceMappingURL=types.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/utils.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/utils.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formLoginsMap: () => (/* binding */ formLoginsMap)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function formLoginsMap(idToken) {
    const issuer = (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.decodeJWT)(idToken).payload.iss;
    const res = {};
    if (!issuer) {
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthError({
            name: 'InvalidIdTokenException',
            message: 'Invalid Idtoken.',
        });
    }
    const domainName = issuer.replace(/(^\w+:|^)\/\//, '');
    res[domainName] = idToken;
    return res;
}


//# sourceMappingURL=utils.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoIdentityPoolEndpointResolver.mjs":
/*!***************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoIdentityPoolEndpointResolver.mjs ***!
  \***************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCognitoIdentityPoolEndpointResolver: () => (/* binding */ createCognitoIdentityPoolEndpointResolver)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/cognitoIdentityPoolEndpointResolver.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/amplifyUrl/index.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createCognitoIdentityPoolEndpointResolver = ({ endpointOverride }) => (input) => {
    if (endpointOverride) {
        return { url: new _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.AmplifyUrl(endpointOverride) };
    }
    return (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__.cognitoIdentityPoolEndpointResolver)(input);
};


//# sourceMappingURL=createCognitoIdentityPoolEndpointResolver.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/middleware/createDisableCacheMiddleware.mjs":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/foundation/factories/middleware/createDisableCacheMiddleware.mjs ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDisableCacheMiddleware: () => (/* binding */ createDisableCacheMiddleware)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * A Cognito Identity-specific middleware that disables caching for all requests.
 */
const createDisableCacheMiddleware = () => next => async function disableCacheMiddleware(request) {
    request.headers['cache-control'] = 'no-store';
    return next(request);
};


//# sourceMappingURL=createDisableCacheMiddleware.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/cognitoIdentityPoolEndpointResolver.mjs":
/*!*********************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/cognitoIdentityPoolEndpointResolver.mjs ***!
  \*********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cognitoIdentityPoolEndpointResolver: () => (/* binding */ cognitoIdentityPoolEndpointResolver)
/* harmony export */ });
/* harmony import */ var _clients_endpoints_getDnsSuffix_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../clients/endpoints/getDnsSuffix.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/endpoints/getDnsSuffix.mjs");
/* harmony import */ var _utils_amplifyUrl_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../utils/amplifyUrl/index.mjs */ "./node_modules/@aws-amplify/core/dist/esm/utils/amplifyUrl/index.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _smithy_util_hex_encoding__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @smithy/util-hex-encoding */ "./node_modules/@aws-amplify/core/node_modules/@smithy/util-hex-encoding/dist-es/index.js");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/constants.mjs");



















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const cognitoIdentityPoolEndpointResolver = ({ region, }) => ({
    url: new _utils_amplifyUrl_index_mjs__WEBPACK_IMPORTED_MODULE_2__.AmplifyUrl(`https://${_constants_mjs__WEBPACK_IMPORTED_MODULE_3__.COGNITO_IDENTITY_SERVICE_NAME}.${region}.${(0,_clients_endpoints_getDnsSuffix_mjs__WEBPACK_IMPORTED_MODULE_4__.getDnsSuffix)(region)}`),
});


//# sourceMappingURL=cognitoIdentityPoolEndpointResolver.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/constants.mjs":
/*!*******************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/constants.mjs ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COGNITO_IDENTITY_SERVICE_NAME: () => (/* binding */ COGNITO_IDENTITY_SERVICE_NAME),
/* harmony export */   DEFAULT_SERVICE_CLIENT_API_CONFIG: () => (/* binding */ DEFAULT_SERVICE_CLIENT_API_CONFIG)
/* harmony export */ });
/* harmony import */ var _clients_middleware_retry_jitteredBackoff_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../clients/middleware/retry/jitteredBackoff.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/middleware/retry/jitteredBackoff.mjs");
/* harmony import */ var _clients_middleware_retry_defaultRetryDecider_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../clients/middleware/retry/defaultRetryDecider.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/middleware/retry/defaultRetryDecider.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _smithy_util_hex_encoding__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @smithy/util-hex-encoding */ "./node_modules/@aws-amplify/core/node_modules/@smithy/util-hex-encoding/dist-es/index.js");
/* harmony import */ var _clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../clients/serde/json.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/serde/json.mjs");



















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * The service name used to sign requests if the API requires authentication.
 */
const COGNITO_IDENTITY_SERVICE_NAME = 'cognito-identity';
const DEFAULT_SERVICE_CLIENT_API_CONFIG = {
    service: COGNITO_IDENTITY_SERVICE_NAME,
    retryDecider: (0,_clients_middleware_retry_defaultRetryDecider_mjs__WEBPACK_IMPORTED_MODULE_2__.getRetryDecider)(_clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_3__.parseJsonError),
    computeDelay: _clients_middleware_retry_jitteredBackoff_mjs__WEBPACK_IMPORTED_MODULE_4__.jitteredBackoff,
    cache: 'no-store',
};


//# sourceMappingURL=constants.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/createGetCredentialsForIdentityClient.mjs":
/*!***********************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/createGetCredentialsForIdentityClient.mjs ***!
  \***********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGetCredentialsForIdentityClient: () => (/* binding */ createGetCredentialsForIdentityClient)
/* harmony export */ });
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _smithy_util_hex_encoding__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @smithy/util-hex-encoding */ "./node_modules/@aws-amplify/core/node_modules/@smithy/util-hex-encoding/dist-es/index.js");
/* harmony import */ var _Platform_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../Platform/index.mjs */ "./node_modules/@aws-amplify/core/dist/esm/Platform/index.mjs");
/* harmony import */ var _clients_serde_responseInfo_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../clients/serde/responseInfo.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/serde/responseInfo.mjs");
/* harmony import */ var _clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../clients/serde/json.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/serde/json.mjs");
/* harmony import */ var _clients_internal_composeServiceApi_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../clients/internal/composeServiceApi.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/constants.mjs");
/* harmony import */ var _handler_cognitoIdentityTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./handler/cognitoIdentityTransferHandler.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/handler/cognitoIdentityTransferHandler.mjs");
/* harmony import */ var _serde_createClientSerializer_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serde/createClientSerializer.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/serde/createClientSerializer.mjs");






















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createGetCredentialsForIdentityClient = (config) => (0,_clients_internal_composeServiceApi_mjs__WEBPACK_IMPORTED_MODULE_2__.composeServiceApi)(_handler_cognitoIdentityTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_3__.cognitoIdentityTransferHandler, (0,_serde_createClientSerializer_mjs__WEBPACK_IMPORTED_MODULE_4__.createClientSerializer)('GetCredentialsForIdentity'), getCredentialsForIdentityDeserializer, {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_5__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
    userAgentValue: (0,_Platform_index_mjs__WEBPACK_IMPORTED_MODULE_6__.getAmplifyUserAgent)(),
});
const getCredentialsForIdentityDeserializer = async (response) => {
    if (response.statusCode >= 300) {
        const error = await (0,_clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_7__.parseJsonError)(response);
        throw error;
    }
    const body = await (0,_clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_7__.parseJsonBody)(response);
    return {
        IdentityId: body.IdentityId,
        Credentials: deserializeCredentials(body.Credentials),
        $metadata: (0,_clients_serde_responseInfo_mjs__WEBPACK_IMPORTED_MODULE_8__.parseMetadata)(response),
    };
};
const deserializeCredentials = ({ Expiration, ...rest } = {}) => ({
    ...rest,
    Expiration: Expiration && new Date(Expiration * 1000),
});


//# sourceMappingURL=createGetCredentialsForIdentityClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/createGetIdClient.mjs":
/*!***************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/createGetIdClient.mjs ***!
  \***************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGetIdClient: () => (/* binding */ createGetIdClient)
/* harmony export */ });
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _smithy_util_hex_encoding__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @smithy/util-hex-encoding */ "./node_modules/@aws-amplify/core/node_modules/@smithy/util-hex-encoding/dist-es/index.js");
/* harmony import */ var _Platform_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../Platform/index.mjs */ "./node_modules/@aws-amplify/core/dist/esm/Platform/index.mjs");
/* harmony import */ var _clients_serde_responseInfo_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../clients/serde/responseInfo.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/serde/responseInfo.mjs");
/* harmony import */ var _clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../clients/serde/json.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/serde/json.mjs");
/* harmony import */ var _clients_internal_composeServiceApi_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../clients/internal/composeServiceApi.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/constants.mjs");
/* harmony import */ var _handler_cognitoIdentityTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./handler/cognitoIdentityTransferHandler.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/handler/cognitoIdentityTransferHandler.mjs");
/* harmony import */ var _serde_createClientSerializer_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serde/createClientSerializer.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/serde/createClientSerializer.mjs");






















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createGetIdClient = (config) => (0,_clients_internal_composeServiceApi_mjs__WEBPACK_IMPORTED_MODULE_2__.composeServiceApi)(_handler_cognitoIdentityTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_3__.cognitoIdentityTransferHandler, (0,_serde_createClientSerializer_mjs__WEBPACK_IMPORTED_MODULE_4__.createClientSerializer)('GetId'), getIdDeserializer, {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_5__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
    userAgentValue: (0,_Platform_index_mjs__WEBPACK_IMPORTED_MODULE_6__.getAmplifyUserAgent)(),
});
const getIdDeserializer = async (response) => {
    if (response.statusCode >= 300) {
        const error = await (0,_clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_7__.parseJsonError)(response);
        throw error;
    }
    const body = await (0,_clients_serde_json_mjs__WEBPACK_IMPORTED_MODULE_7__.parseJsonBody)(response);
    return {
        IdentityId: body.IdentityId,
        $metadata: (0,_clients_serde_responseInfo_mjs__WEBPACK_IMPORTED_MODULE_8__.parseMetadata)(response),
    };
};


//# sourceMappingURL=createGetIdClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/handler/cognitoIdentityTransferHandler.mjs":
/*!************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/handler/cognitoIdentityTransferHandler.mjs ***!
  \************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cognitoIdentityTransferHandler: () => (/* binding */ cognitoIdentityTransferHandler)
/* harmony export */ });
/* harmony import */ var _clients_handlers_aws_unauthenticated_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../clients/handlers/aws/unauthenticated.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/handlers/aws/unauthenticated.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _smithy_util_hex_encoding__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @smithy/util-hex-encoding */ "./node_modules/@aws-amplify/core/node_modules/@smithy/util-hex-encoding/dist-es/index.js");
/* harmony import */ var _clients_internal_composeTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../clients/internal/composeTransferHandler.mjs */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeTransferHandler.mjs");
/* harmony import */ var _middleware_createDisableCacheMiddleware_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../middleware/createDisableCacheMiddleware.mjs */ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/middleware/createDisableCacheMiddleware.mjs");



















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * A Cognito Identity-specific transfer handler that does NOT sign requests, and
 * disables caching.
 *
 * @internal
 */
const cognitoIdentityTransferHandler = (0,_clients_internal_composeTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_2__.composeTransferHandler)(_clients_handlers_aws_unauthenticated_mjs__WEBPACK_IMPORTED_MODULE_3__.unauthenticatedHandler, [_middleware_createDisableCacheMiddleware_mjs__WEBPACK_IMPORTED_MODULE_4__.createDisableCacheMiddleware]);


//# sourceMappingURL=cognitoIdentityTransferHandler.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/serde/createClientSerializer.mjs":
/*!**************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/foundation/factories/serviceClients/cognitoIdentity/serde/createClientSerializer.mjs ***!
  \**************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buildHttpRpcRequest: () => (/* binding */ buildHttpRpcRequest),
/* harmony export */   createClientSerializer: () => (/* binding */ createClientSerializer)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createClientSerializer = (operation) => (input, endpoint) => {
    const headers = getSharedHeaders(operation);
    const body = JSON.stringify(input);
    return buildHttpRpcRequest(endpoint, headers, body);
};
const getSharedHeaders = (operation) => ({
    'content-type': 'application/x-amz-json-1.1',
    'x-amz-target': `AWSCognitoIdentityService.${operation}`,
});
const buildHttpRpcRequest = ({ url }, headers, body) => ({
    headers,
    url,
    body,
    method: 'POST',
});


//# sourceMappingURL=createClientSerializer.mjs.map


/***/ }),

/***/ "./node_modules/aws-amplify/dist/esm/index.mjs":
/*!*****************************************************!*\
  !*** ./node_modules/aws-amplify/dist/esm/index.mjs ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Amplify: () => (/* reexport safe */ _initSingleton_mjs__WEBPACK_IMPORTED_MODULE_0__.DefaultAmplify)
/* harmony export */ });
/* harmony import */ var _initSingleton_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./initSingleton.mjs */ "./node_modules/aws-amplify/dist/esm/initSingleton.mjs");

//# sourceMappingURL=index.mjs.map


/***/ }),

/***/ "./node_modules/aws-amplify/dist/esm/initSingleton.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/aws-amplify/dist/esm/initSingleton.mjs ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultAmplify: () => (/* binding */ DefaultAmplify)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/storage/CookieStorage.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/storage/index.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/parseAmplifyConfig.mjs");
/* harmony import */ var _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/auth/cognito */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/credentialsProvider.mjs");
/* harmony import */ var _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/auth/cognito */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/IdentityIdStore.mjs");
/* harmony import */ var _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/auth/cognito */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/credentialsProvider/index.mjs");
/* harmony import */ var _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/auth/cognito */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const DefaultAmplify = {
    /**
     * Configures Amplify with the {@link resourceConfig} and {@link libraryOptions}.
     *
     * @param resourceConfig The {@link ResourcesConfig} object that is typically imported from the
     * `amplifyconfiguration.json` file. It can also be an object literal created inline when calling `Amplify.configure`.
     * @param libraryOptions The {@link LibraryOptions} additional options for the library.
     *
     * @example
     * import config from './amplifyconfiguration.json';
     *
     * Amplify.configure(config);
     */
    configure(resourceConfig, libraryOptions) {
        const resolvedResourceConfig = (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.parseAmplifyConfig)(resourceConfig);
        const cookieBasedKeyValueStorage = new _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__.CookieStorage({ sameSite: 'lax' });
        const resolvedKeyValueStorage = libraryOptions?.ssr
            ? cookieBasedKeyValueStorage
            : _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.defaultStorage;
        const resolvedCredentialsProvider = libraryOptions?.ssr
            ? new _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_3__.CognitoAWSCredentialsAndIdentityIdProvider(new _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_4__.DefaultIdentityIdStore(cookieBasedKeyValueStorage))
            : _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_5__.cognitoCredentialsProvider;
        // If no Auth config is provided, no special handling will be required, configure as is.
        // Otherwise, we can assume an Auth config is provided from here on.
        if (!resolvedResourceConfig.Auth) {
            _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.configure(resolvedResourceConfig, libraryOptions);
            return;
        }
        // If Auth options are provided, always just configure as is.
        // Otherwise, we can assume no Auth libraryOptions were provided from here on.
        if (libraryOptions?.Auth) {
            _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.configure(resolvedResourceConfig, libraryOptions);
            return;
        }
        // If no Auth libraryOptions were previously configured, then always add default providers.
        if (!_aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.libraryOptions.Auth) {
            _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_7__.cognitoUserPoolsTokenProvider.setAuthConfig(resolvedResourceConfig.Auth);
            _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_7__.cognitoUserPoolsTokenProvider.setKeyValueStorage(
            // TODO: allow configure with a public interface
            resolvedKeyValueStorage);
            _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.configure(resolvedResourceConfig, {
                ...libraryOptions,
                Auth: {
                    tokenProvider: _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_7__.cognitoUserPoolsTokenProvider,
                    credentialsProvider: resolvedCredentialsProvider,
                },
            });
            return;
        }
        // At this point, Auth libraryOptions would have been previously configured and no overriding
        // Auth options were given, so we should preserve the currently configured Auth libraryOptions.
        if (libraryOptions) {
            const authLibraryOptions = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.libraryOptions.Auth;
            // If ssr is provided through libraryOptions, we should respect the intentional reconfiguration.
            if (libraryOptions.ssr !== undefined) {
                _aws_amplify_auth_cognito__WEBPACK_IMPORTED_MODULE_7__.cognitoUserPoolsTokenProvider.setKeyValueStorage(
                // TODO: allow configure with a public interface
                resolvedKeyValueStorage);
                authLibraryOptions.credentialsProvider = resolvedCredentialsProvider;
            }
            _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.configure(resolvedResourceConfig, {
                Auth: authLibraryOptions,
                ...libraryOptions,
            });
            return;
        }
        // Finally, if there were no libraryOptions given at all, we should simply not touch the currently
        // configured libraryOptions.
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.configure(resolvedResourceConfig);
    },
    /**
     * Returns the {@link ResourcesConfig} object passed in as the `resourceConfig` parameter when calling
     * `Amplify.configure`.
     *
     * @returns An {@link ResourcesConfig} object.
     */
    getConfig() {
        return _aws_amplify_core__WEBPACK_IMPORTED_MODULE_6__.Amplify.getConfig();
    },
};


//# sourceMappingURL=initSingleton.mjs.map


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_aws-amplify_dist_esm_index_mjs.6bac1a8c4cc93f15f6b7.js.map