# mypy-boto3-iot

[![PyPI - mypy-boto3-iot](https://img.shields.io/pypi/v/mypy-boto3-iot.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iot.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.IoT 1.11.8](https://boto3.amazonaws.com/v1/documentation/api/1.11.8/reference/services/iot.html#IoT) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-iot](#mypy-boto3-iot)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `IoT` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-iot]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import iot
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_iot as iot

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("iot")
client: iot.IoTClient = boto3.client("iot")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: iot.IoTClient = session.client("iot")


# Paginators need type annotation on creation
list_active_violations_paginator: iot.ListActiveViolationsPaginator = client.get_paginator("list_active_violations")
list_attached_policies_paginator: iot.ListAttachedPoliciesPaginator = client.get_paginator("list_attached_policies")
list_audit_findings_paginator: iot.ListAuditFindingsPaginator = client.get_paginator("list_audit_findings")
list_audit_tasks_paginator: iot.ListAuditTasksPaginator = client.get_paginator("list_audit_tasks")
list_authorizers_paginator: iot.ListAuthorizersPaginator = client.get_paginator("list_authorizers")
list_billing_groups_paginator: iot.ListBillingGroupsPaginator = client.get_paginator("list_billing_groups")
list_ca_certificates_paginator: iot.ListCACertificatesPaginator = client.get_paginator("list_ca_certificates")
list_certificates_paginator: iot.ListCertificatesPaginator = client.get_paginator("list_certificates")
list_certificates_by_ca_paginator: iot.ListCertificatesByCAPaginator = client.get_paginator("list_certificates_by_ca")
list_indices_paginator: iot.ListIndicesPaginator = client.get_paginator("list_indices")
list_job_executions_for_job_paginator: iot.ListJobExecutionsForJobPaginator = client.get_paginator("list_job_executions_for_job")
list_job_executions_for_thing_paginator: iot.ListJobExecutionsForThingPaginator = client.get_paginator("list_job_executions_for_thing")
list_jobs_paginator: iot.ListJobsPaginator = client.get_paginator("list_jobs")
list_ota_updates_paginator: iot.ListOTAUpdatesPaginator = client.get_paginator("list_ota_updates")
list_outgoing_certificates_paginator: iot.ListOutgoingCertificatesPaginator = client.get_paginator("list_outgoing_certificates")
list_policies_paginator: iot.ListPoliciesPaginator = client.get_paginator("list_policies")
list_policy_principals_paginator: iot.ListPolicyPrincipalsPaginator = client.get_paginator("list_policy_principals")
list_principal_policies_paginator: iot.ListPrincipalPoliciesPaginator = client.get_paginator("list_principal_policies")
list_principal_things_paginator: iot.ListPrincipalThingsPaginator = client.get_paginator("list_principal_things")
list_role_aliases_paginator: iot.ListRoleAliasesPaginator = client.get_paginator("list_role_aliases")
list_scheduled_audits_paginator: iot.ListScheduledAuditsPaginator = client.get_paginator("list_scheduled_audits")
list_security_profiles_paginator: iot.ListSecurityProfilesPaginator = client.get_paginator("list_security_profiles")
list_security_profiles_for_target_paginator: iot.ListSecurityProfilesForTargetPaginator = client.get_paginator("list_security_profiles_for_target")
list_streams_paginator: iot.ListStreamsPaginator = client.get_paginator("list_streams")
list_tags_for_resource_paginator: iot.ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_targets_for_policy_paginator: iot.ListTargetsForPolicyPaginator = client.get_paginator("list_targets_for_policy")
list_targets_for_security_profile_paginator: iot.ListTargetsForSecurityProfilePaginator = client.get_paginator("list_targets_for_security_profile")
list_thing_groups_paginator: iot.ListThingGroupsPaginator = client.get_paginator("list_thing_groups")
list_thing_groups_for_thing_paginator: iot.ListThingGroupsForThingPaginator = client.get_paginator("list_thing_groups_for_thing")
list_thing_registration_tasks_paginator: iot.ListThingRegistrationTasksPaginator = client.get_paginator("list_thing_registration_tasks")
list_thing_types_paginator: iot.ListThingTypesPaginator = client.get_paginator("list_thing_types")
list_things_paginator: iot.ListThingsPaginator = client.get_paginator("list_things")
list_things_in_billing_group_paginator: iot.ListThingsInBillingGroupPaginator = client.get_paginator("list_things_in_billing_group")
list_things_in_thing_group_paginator: iot.ListThingsInThingGroupPaginator = client.get_paginator("list_things_in_thing_group")
list_topic_rules_paginator: iot.ListTopicRulesPaginator = client.get_paginator("list_topic_rules")
list_v2_logging_levels_paginator: iot.ListV2LoggingLevelsPaginator = client.get_paginator("list_v2_logging_levels")
list_violation_events_paginator: iot.ListViolationEventsPaginator = client.get_paginator("list_violation_events")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.