
This is an MCP server that integrates PRD and TRD building tool [Nautex AI](https://nautex.ai) with the Coding Agents.

Supported agents: Cursor, Claude Code, Gemini CLI (coming soon)

# Motivation

Since LLM Coding Agents do not attend team meetings, there is the challenge of conveying complete and detailed product and technical requirements to them. 

Nautex AI tool-chain manages step by step guiding of Coding Agents so they implement specification using small, relevant and testable steps. 

Core principles are: 
1) start from foundational parts, de-risk them, then build up; 
2) do not overwhelm Coding Agents by large problem at once;
3) plan project files map and link them to requirements and to tasks: Coding Agents don't get lost, you know how to navigate brand new code base;
4) manage developer attention for verification and validation in right moment for review.

# How It Works 

Nautex AI acts as an Architect, Technical Product Manager, and Project Manager for coding agents, 
speeding up AI-assisted development by communicating requirements effectively. 
This MCP server pulls guidance instructions from Nautex AI; tasks contain to-do items, 
references to the affected files, and requirements that are automatically synced for the Coding Agent's availability.

By [Ivan Makarov](https://x.com/ivan_mkrv)


⬇️⬇️⬇️ 📚 **Check Presentation** ⬇️⬇️⬇️


<details>
<summary>💡 Usage Flow Presentation (unfold me)</summary>

## Requirements Specifications

The chatbot conducts a briefing session with you, gathering questions and ideas until complete. It then generates comprehensive product and technical specifications.

(Example: A project I initiated to explore WebRTC.)

Product requirements:
![howitworks_specifications](doc/howitworks_specifications.png)

Technical requirements:
![howitworks_diagram.png](doc/howitworks_diagram.png)

## Specification Refinement

You fill in details, clarify the specification, and resolve any TODOs flagged by the chatbot during the interview.

![howitworks_refinement](doc/howitworks_refinement.png)

## Codebase Map and Project Files

You'll occasionally need to review the code, so it's best to know in advance where to look and how everything is organized. This prevents the AI from making decisions—allowing it to focus on writing higher-quality code with greater attention to the task.

The image displays a file map generated by Nautex AI, with files linked to specific requirements and sections.

![howitworks_filemap](doc/howitworks_filemap.png)

## Agent Tasks

With the code location clarified, tasks are planned: Coding, Testing, and Review.

Reviews are scheduled early to demonstrate progress and verify alignment with goals.

The plan is structured in small, self-contained layers, building your project incrementally like floors in a skyscraper.

![howitworks_tasks](doc/howitworks_tasks.png)

## Integration

Next, configure the MCP server for Cursor integration: connect to the Nautex cloud platform for tasks, select the project, and choose the plan.

Set the MCP server parameters and provide usage rules for Cursor. Use mouse clicks for automation—the terminal UI functions like a web page.

This utility is available on GitHub.

Once all indicators are green, initiate plan execution.

![howitworks_integration](doc/howitworks_integration.png)

## Coding with Coding Agents

In agent mode, instruct: "pull nautex rules, and proceed with the next scope."

At this stage, your specifications are synchronized in the .nautex directory and accessible to the Coding Agent. The MCP server continuously monitors their relevance.

That's it. You then review and accept substantial code segments that fully align with your expectations and requirements.

![howitworks_coding](doc/howitworks_coding.png)

</details>

# Setup

## Via Terminal UI

1. Go to the new project folder and run in the terminal:
```bash
uvx nautex setup
```

<details>
<summary>How to Install uv</summary>

On macOS and linux:
```bash
curl -LsSf https://astral.sh/uv/install.sh | sh
```

On Windows
```bash
powershell -ExecutionPolicy ByPass -c "irm https://astral.sh/uv/install.ps1 | iex"
```

Check the latest instruction from [UV repo](https://github.com/astral-sh/uv) for details and updates
</details>

You should see the terminal user interface

![Setup Screenshot](doc/setup_screen.png)

2. Follow the guidelines via UI 
 - go [Nautex.ai](https://app.nautex.ai/settings/nautex-api) to sign up and create API token
 - In the web app, create PRD and TRD documents:
   - Chat with the bot for capturing requirements. 
   - After initial documents generation Create files map of the project inside the map.
   - Then, after reviewing resulted map create implementation plan.
   - You can follow `Connect Coding Agent` onboarding flow or setup via TUI. Button will disappear on first MCP request
   - Go back to the CLI UI
- Select project
- Select implementation plan
- Select agent type
- Ensure you've got right MCP config: manually or via TUI (it will merge with any existing config)
<details>
<summary>For cursor</summary>

- in `.cursor/mcp.json`, 

```json
{
  "mcpServers": {
    "nautex": {
      "command": "uvx",
      "args": [
        "nautex",
        "mcp"
      ]
    }
  }
}
```

**Note:** At config update Cursor asks via popup either you want to enable new MCP, answer yes. In any case in 
`File -> Preferences -> Cursor Preferences -> Tools & Integrations` nautex MCP should be enabled and green. 

- Rules are in `.cursor/rules/` folder via TUI command.
</details>

<details>
<summary>For Claude Code</summary>

TUI setup is going to launch this command via a menu for setting up nautex MCP:
```
claude mcp add nautex -s local -- uvx nautex mcp
```

- Rules are in `./CLAUDE.md` after set via TUI.
</details>

3. (Optional) Check MCP server response ```uvx nautex mcp test next_scope```
4. Check MCP configuration works and Coding Agent sees the tools: 
 > Check nautex status
5. Tell Coding Agent: 
 > Pull nautex rules and proceed to the next scope

6. Proceed with the plan by reviewing progress and supporting the Agent with validation feedback and inputs.

# Projects built with nautex

- [Collaborative Pixel Canvas](https://pixall.art) - [repo](https://github.com/hmldns/pix-canvas)

# Best practice from the community

<a href="https://discord.gg/nautex" target="_blank"><img src="doc/join_discord.png" alt="drawing" width="200"/></a>
