import pickle
from unittest import result;
import pandas as pd;
def predict(model_path,preprocessor_path,input_data, encoder_path=None):
        """
    Load a trained model and make predictions on input data.

    Args:
        model_path (str): 
            Path to the serialized trained model file.
        preprocessor_path (str): 
            Path to the serialized preprocessor file (used for feature transformation).
        input_data (str): 
            Path to the input CSV file containing data for prediction.
        encoder_path (Optional[str], optional): 
            Path to the serialized encoder file (for categorical target encoding). Defaults to None.

    Returns:
        List[Any]: 
            List of predictions generated by the model.

    Examples:
        >>> predict("model.pkl", "preprocessor.pkl", "input.csv")
        [1, 0, 1]
    """
        print("Loading the pickled model and preprocessor...")
        model = pickle.load(open(model_path, 'rb'))
        preprocessor = pickle.load(open(preprocessor_path, 'rb'))
        encoder = pickle.load(open(encoder_path, 'rb')) if encoder_path else None
        df= pd.read_csv(input_data)
        X = preprocessor.transform(df)
        predictions = model.predict(X)
        if encoder_path:
            predictions = encoder.inverse_transform(predictions)
        return {"prediction": predictions.tolist()}
def main():
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("--model_path", required=True,help="Path to the model file")
    parser.add_argument("--input_data", required=True,help="Path to the input data CSV file")
    parser.add_argument("--preprocessor_path", required=True,help="Path to the preprocessor file")
    parser.add_argument("--encoder_path", required=False,help="Path to the encoder file")
    args = parser.parse_args()
    print(predict(args.model_path, args.preprocessor_path, args.input_data, args.encoder_path))

