# Copyright (c) Alibaba, Inc. and its affiliates.
import datasets
import json

# flake8: noqa

# NOTE: AUTOGENERATED, DO NOT CHANGE.

_DESCRIPTION = """\
The HumanEval dataset released by OpenAI contains 164 handcrafted programming challenges together with unittests to very the viability of a proposed solution.
"""

# _URL = "https://raw.githubusercontent.com/openai/human-eval/master/data/HumanEval.jsonl.gz"
_URL = 'https://sail-moe.oss-cn-hangzhou.aliyuncs.com/open_data/humaneval/HumanEval.jsonl.gz'

_CITATION = """\
@misc{chen2021evaluating,
      title={Evaluating Large Language Models Trained on Code},
      author={Mark Chen and Jerry Tworek and Heewoo Jun and Qiming Yuan and Henrique Ponde de Oliveira Pinto and Jared Kaplan and Harri Edwards and Yuri Burda and Nicholas Joseph and Greg Brockman and Alex Ray and Raul Puri and Gretchen Krueger and Michael Petrov and Heidy Khlaaf and Girish Sastry and Pamela Mishkin and Brooke Chan and Scott Gray and Nick Ryder and Mikhail Pavlov and Alethea Power and Lukasz Kaiser and Mohammad Bavarian and Clemens Winter and Philippe Tillet and Felipe Petroski Such and Dave Cummings and Matthias Plappert and Fotios Chantzis and Elizabeth Barnes and Ariel Herbert-Voss and William Hebgen Guss and Alex Nichol and Alex Paino and Nikolas Tezak and Jie Tang and Igor Babuschkin and Suchir Balaji and Shantanu Jain and William Saunders and Christopher Hesse and Andrew N. Carr and Jan Leike and Josh Achiam and Vedant Misra and Evan Morikawa and Alec Radford and Matthew Knight and Miles Brundage and Mira Murati and Katie Mayer and Peter Welinder and Bob McGrew and Dario Amodei and Sam McCandlish and Ilya Sutskever and Wojciech Zaremba},
      year={2021},
      eprint={2107.03374},
      archivePrefix={arXiv},
      primaryClass={cs.LG}
}"""

_HOMEPAGE = 'https://github.com/openai/human-eval'

_LICENSE = 'MIT'


class OpenaiHumaneval(datasets.GeneratorBasedBuilder):
    """HumanEval: A benchmark for code generation."""

    VERSION = datasets.Version('1.0.0')

    BUILDER_CONFIGS = [
        datasets.BuilderConfig(
            name='openai_humaneval',
            version=datasets.Version('1.0.0'),
            description=_DESCRIPTION,
        )
    ]

    def _info(self):
        features = datasets.Features({
            'task_id': datasets.Value('string'),
            'prompt': datasets.Value('string'),
            'canonical_solution': datasets.Value('string'),
            'test': datasets.Value('string'),
            'entry_point': datasets.Value('string'),
        })

        return datasets.DatasetInfo(
            description=_DESCRIPTION,
            features=features,
            supervised_keys=None,
            homepage=_HOMEPAGE,
            license=_LICENSE,
            citation=_CITATION,
        )

    def _split_generators(self, dl_manager):
        """Returns SplitGenerators."""
        data_dir = dl_manager.download_and_extract(_URL)
        return [datasets.SplitGenerator(
            name=datasets.Split.TEST,
            gen_kwargs={
                'filepath': data_dir,
            },
        )]

    def _generate_examples(self, filepath):
        """Yields examples."""
        with open(filepath, encoding='utf-8') as file:
            data = [json.loads(line) for line in file]
            id_ = 0
            for sample in data:
                yield id_, sample
                id_ += 1
