# generated by datamodel-codegen:
#   filename:  get_etf_details.199532.json
#   timestamp: 2025-01-29T16:29:55+00:00
#   version:   0.26.5

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import BaseModel


class Quote(BaseModel):
    last: float
    highest: float
    lowest: float
    change: float
    changePercent: float
    timeOfLast: int
    totalValueTraded: int
    totalVolumeTraded: int
    updated: int
    isRealTime: bool


class Listing(BaseModel):
    shortName: str
    tickerSymbol: str
    countryCode: str
    currency: str
    marketPlaceCode: str
    marketPlaceName: str
    tickSizeListId: str
    marketTradesAvailable: bool


class Underlying(BaseModel):
    orderbookId: str
    name: str
    instrumentType: str
    quote: Quote
    listing: Listing
    previousClosingPrice: float


class Documents(BaseModel):
    kid: str
    prospectus: str


class BuySide(BaseModel):
    price: float
    priceString: str
    volume: int


class SellSide(BaseModel):
    price: float
    priceString: str
    volume: int


class Level(BaseModel):
    buySide: BuySide
    sellSide: SellSide


class OrderDepth(BaseModel):
    receivedTime: int
    levels: List[Level]


class OrderDepthLevel(BaseModel):
    buySide: BuySide
    sellSide: SellSide


class AccountAndPositionsViewItem(BaseModel):
    accountId: str
    encryptedAccountId: str
    accountName: str
    accountType: str
    accountTypeName: str
    amount: float
    volume: int
    acquiredAmount: float
    acquiredPrice: float
    amountDevelopment: float
    percentDevelopment: float
    averageAcquiredPriceOrderbookCurrency: float


class BrokerTradeSummary(BaseModel):
    brokerCode: str
    sellVolume: int
    buyVolume: int
    netBuyVolume: int
    brokerName: str


class Fee(BaseModel):
    totalMonetaryFee: float
    totalPercentageFee: float


class Trade(BaseModel):
    buyer: str
    buyerName: Optional[str] = None
    seller: str
    dealTime: int
    price: float
    volume: int
    matchedOnMarket: bool
    cancelled: bool
    sellerName: Optional[str] = None


class Account(BaseModel):
    accountId: str
    encryptedAccountId: str
    accountName: str
    accountType: str
    accountTypeName: str


class PastEvent(BaseModel):
    exDate: str
    paymentDate: str
    amount: float
    currencyCode: str
    dividendType: str


class Dividends(BaseModel):
    events: List[Any]
    pastEvents: List[PastEvent]


class FundExposure(BaseModel):
    orderbookId: str
    name: str
    exposure: float
    instrumentType: str
    countryCode: str
    hasPosition: bool


class CountryExposures(BaseModel):
    exposures: List[Any]


class SectorExposures(BaseModel):
    exposures: List[Any]


class SustainabilityDevelopmentGoal(BaseModel):
    value: str
    name: str
    type: str
    status: str


class EsgView(BaseModel):
    euArticleType: str
    sustainabilityDevelopmentGoals: List[SustainabilityDevelopmentGoal]


class EtfDetails(BaseModel):
    underlying: Underlying
    assetCategory: str
    category: str
    subCategory: str
    issuer: str
    description: str
    documents: Documents
    orderDepth: OrderDepth
    brokerTradeSummaries: List[BrokerTradeSummary]
    fee: Fee
    trades: List[Trade]
    tradingUnit: int
    collateralValue: float
    introDate: str
    dividends: Dividends
    fundExposures: List[FundExposure]
    riskScore: str
    holdingPeriod: str
    countryExposures: CountryExposures
    sectorExposures: SectorExposures
    portfolioDate: str
    esgView: EsgView
    superInterestApproved: bool
