def filter_tests(input_file: str, output_file: str, threshold: float):
    """Filter tests based on duration threshold."""
    with open(input_file, "r") as infile, open(output_file, "w") as outfile:
        for line in infile:
            parts = line.split()
            if len(parts) > 1:
                try:
                    duration = float(parts[0])
                    if duration >= threshold:
                        outfile.write(line)
                except ValueError:
                    continue
