import subprocess
from unittest.mock import patch, MagicMock


def test_cli_fetch():
    with patch('subprocess.run') as mock_run:
        mock_run.return_value = subprocess.CompletedProcess(args=[], returncode=0)
        result = subprocess.run(
            ["python", "-m", "pytest_cream.cli", "fetch", "--branch", "main"],
            capture_output=True,
        )
        assert result.returncode == 0


def test_cli_run():
    with patch('subprocess.run') as mock_run:
        mock_run.return_value = subprocess.CompletedProcess(args=[], returncode=0)
        result = subprocess.run(
            ["python", "-m", "pytest_cream.cli", "run", "--output", "test_durations.log"],
            capture_output=True,
        )
        assert result.returncode == 0


def test_cli_filter():
    with patch('subprocess.run') as mock_run:
        mock_run.return_value = subprocess.CompletedProcess(args=[], returncode=0)
        result = subprocess.run(
            [
                "python",
                "-m",
                "pytest_cream.cli",
                "filter",
                "--input",
                "input.log",
                "--output",
                "output.log",
                "--threshold",
                "0.5",
            ],
            capture_output=True,
        )
        assert result.returncode == 0
