import os
import requests
import io
import zipfile
from pytest_cream.fetch import fetch_tests


def test_fetch_tests(tmp_path):
    zip_path = tmp_path / "tests.zip"
    output_dir = tmp_path / "tests"

    class MockResponse:
        def __init__(self):
            self.status_code = 200

        def raise_for_status(self):
            pass

        def iter_content(self, chunk_size=8192):
            # Create a valid zip file in memory
            buffer = io.BytesIO()
            with zipfile.ZipFile(buffer, "w") as zf:
                zf.writestr("test_file.txt", "This is a test.")
            buffer.seek(0)
            yield buffer.read()

    requests.get = lambda url, stream: MockResponse()

    fetch_tests(branch="main", output_dir=str(output_dir))

    assert zip_path.exists() is False  # The zip file should be cleaned up
    assert output_dir.exists()
    assert (output_dir / "test_file.txt").exists()
