import os
from pytest_cream.filter import filter_tests


def test_filter_tests(tmp_path):
    input_file = tmp_path / "input.log"
    output_file = tmp_path / "output.log"

    with open(input_file, "w") as f:
        f.write("0.6 test_a\n0.4 test_b\n")

    filter_tests(
        input_file=str(input_file), output_file=str(output_file), threshold=0.5
    )

    with open(output_file, "r") as f:
        lines = f.readlines()

    assert len(lines) == 1
    assert "0.6 test_a" in lines[0]
